/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.xml.util;

import com.pingidentity.provisioner.mapping.FieldConfig;
import com.pingidentity.x2008.x06.saasProvisioner.FieldConfigType;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.lang.StringUtils;

public abstract class FieldConfigUtil {
    public static FieldConfig contructFieldConfig(FieldConfigType fieldConfigType) {
        FieldConfig fieldConfig = new FieldConfig();
        String attributes = fieldConfigType.getAttributes();
        if (attributes != null) {
            StringTokenizer tokenizer = new StringTokenizer(attributes, ",");
            while (tokenizer.hasMoreTokens()) {
                fieldConfig.addAttributeName(tokenizer.nextToken());
            }
        }
        fieldConfig.setDefault(fieldConfigType.getDefault());
        fieldConfig.setScript(fieldConfigType.getScript());
        fieldConfig.setCreateOnly(fieldConfigType.getCreateOnly());
        fieldConfig.setTrim(fieldConfigType.getTrim());
        fieldConfig.setStripDomain(fieldConfigType.getStripDomain());
        fieldConfig.setToUpper(fieldConfigType.getToUpper());
        fieldConfig.setToLower(fieldConfigType.getToLower());
        fieldConfig.setExtractCnFromDn(fieldConfigType.getExtractCnFromDn());
        fieldConfig.setExtractUserNameFromEmail(fieldConfigType.getExtractUserNameFromEmail());
        fieldConfig.setMasked(fieldConfigType.getMask());
        return fieldConfig;
    }

    public static void saveToBeanDoc(FieldConfigType fieldConfigType, FieldConfig fieldConfig) {
        String expression;
        String defaultVal;
        List<String> attributes = fieldConfig.getAttributeNames();
        if (attributes != null && !attributes.isEmpty()) {
            Object delimitedAttributes = null;
            for (String attr : attributes) {
                if (delimitedAttributes == null) {
                    delimitedAttributes = attr;
                    continue;
                }
                delimitedAttributes = (String)delimitedAttributes + "," + attr;
            }
            fieldConfigType.setAttributes(delimitedAttributes);
        }
        if (!StringUtils.isEmpty((String)(defaultVal = fieldConfig.getDefault()))) {
            fieldConfigType.setDefault(defaultVal);
        }
        if (!StringUtils.isEmpty((String)(expression = fieldConfig.getScript()))) {
            fieldConfigType.setScript(expression);
        }
        if (fieldConfig.isCreateOnly()) {
            fieldConfigType.setCreateOnly(fieldConfig.isCreateOnly());
        }
        if (fieldConfig.isTrim()) {
            fieldConfigType.setTrim(fieldConfig.isTrim());
        }
        if (fieldConfig.isStripDomain()) {
            fieldConfigType.setStripDomain(fieldConfig.isStripDomain());
        }
        if (fieldConfig.isToUpper()) {
            fieldConfigType.setToUpper(fieldConfig.isToUpper());
        } else if (fieldConfig.isToLower()) {
            fieldConfigType.setToLower(fieldConfig.isToLower());
        }
        if (fieldConfig.isExtractCnFromDn()) {
            fieldConfigType.setExtractCnFromDn(fieldConfig.isExtractCnFromDn());
        } else if (fieldConfig.isExtractUserNameFromEmail()) {
            fieldConfigType.setExtractUserNameFromEmail(fieldConfig.isExtractUserNameFromEmail());
        }
        if (fieldConfig.isMasked()) {
            fieldConfigType.setMask(fieldConfig.isMasked());
        }
    }
}

