/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.xml.util;

import com.pingidentity.provisioner.mapping.FieldInfo;
import com.pingidentity.x2008.x06.saasProvisioner.FieldInfoType;
import com.pingidentity.x2008.x06.saasProvisioner.OptionType;
import java.util.List;

public class FieldInfoUtil {
    public static FieldInfo contructFieldInfo(FieldInfoType fieldInfoType) {
        FieldInfo fieldInfo = new FieldInfo(fieldInfoType.getCode(), fieldInfoType.getLabel());
        fieldInfo.setRequired(fieldInfoType.getRequired());
        if (fieldInfoType.getLdapMap()) {
            fieldInfo.setLdapMap(fieldInfoType.getLdapMap());
        } else {
            OptionType[] optionTypes;
            fieldInfo.setUnique(fieldInfoType.getUnique());
            if (fieldInfoType.isSetMaxLength()) {
                fieldInfo.setMaxLength(fieldInfoType.getMaxLength());
            }
            if (fieldInfoType.isSetMinLength()) {
                fieldInfo.setMinLength(fieldInfoType.getMinLength());
            }
            if (fieldInfoType.isSetRegEx()) {
                fieldInfo.setRegEx(fieldInfoType.getRegEx());
            }
            if ((optionTypes = fieldInfoType.getOptionArray()) != null) {
                for (String string : optionTypes) {
                    FieldInfo.Option option = new FieldInfo.Option(string.getCode(), string.getLabel());
                    fieldInfo.addOption(option);
                }
            }
            fieldInfo.setMultiValue(fieldInfoType.getMultiValue());
        }
        String[] notes = fieldInfoType.getNoteArray();
        if (notes != null) {
            for (String string : notes) {
                fieldInfo.addNote(string);
            }
        }
        fieldInfo.setAttributeGroup(fieldInfoType.getAttributeGroup());
        return fieldInfo;
    }

    public static void saveToBeanDoc(FieldInfoType fieldInfoType, FieldInfo info) {
        List<String> notes;
        List<FieldInfo.Option> options;
        fieldInfoType.setCode(info.getCode());
        fieldInfoType.setLabel(info.getLabel());
        if (info.isRequired()) {
            fieldInfoType.setRequired(info.isRequired());
        }
        if (info.isUnique()) {
            fieldInfoType.setUnique(info.isUnique());
        }
        if (info.isDisplayMaxLength()) {
            fieldInfoType.setMaxLength(info.getMaxLength());
        }
        if (info.isDisplayMinLength()) {
            fieldInfoType.setMinLength(info.getMinLength());
        }
        if (info.isDisplayRegEx()) {
            fieldInfoType.setRegEx(info.getRegEx());
        }
        if (info.isLdapMap()) {
            fieldInfoType.setLdapMap(info.isLdapMap());
        }
        if ((options = info.getOptions()) != null && options.size() > 0) {
            for (FieldInfo.Option option : options) {
                OptionType optionType = fieldInfoType.addNewOption();
                optionType.setCode(option.getCode());
                optionType.setLabel(option.getLabel());
            }
        }
        if ((notes = info.getNotes()) != null && notes.size() > 0) {
            for (String note : notes) {
                fieldInfoType.addNote(note);
            }
        }
        if (info.isMultiValue()) {
            fieldInfoType.setMultiValue(info.isMultiValue());
        }
        fieldInfoType.setAttributeGroup(info.isAttributeGroup());
    }
}

