/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.xml.util;

import com.pingidentity.provisioner.domain.source.ChannelSource;
import com.pingidentity.provisioner.domain.source.LdapGuidFormatter;
import com.pingidentity.x2008.x06.saasProvisioner.DirectoryIdentityAttributesMapperType;
import com.pingidentity.x2008.x06.saasProvisioner.LdapGuidFormatterType;
import com.pingidentity.x2008.x06.saasProvisioner.SourceType;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.domain.LdapDataSource;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public abstract class LdapSourceUtil {
    public static ChannelSource constructChannelSource(SourceType srcType) {
        ChannelSource channelSource = new ChannelSource();
        String dataSourceId = srcType.getDataSourceId();
        channelSource.setDataSourceId(dataSourceId);
        LdapGuidFormatterType ldapGuidFormatterType = srcType.getLdapGuidFormatter();
        if (ldapGuidFormatterType != null) {
            LdapGuidFormatter guidFormatter = new LdapGuidFormatter();
            guidFormatter.setGuidAttributeName(ldapGuidFormatterType.getGuidAttributeName());
            guidFormatter.setGuidIsBinary(ldapGuidFormatterType.getGuidIsBinary());
            channelSource.setGuidFormatter(guidFormatter);
        }
        DirectoryIdentityAttributesMapperType directoryIdentityAttributesMapperType = srcType.getDirectoryIdentityAttributesMapper();
        channelSource.setAccountStatusAlgorithm(directoryIdentityAttributesMapperType.getStatusReader());
        channelSource.setAccountStatusAttributeName(directoryIdentityAttributesMapperType.getAttributeName());
        channelSource.setDefaultStatus(directoryIdentityAttributesMapperType.getDefault());
        if ("Flag".equals(directoryIdentityAttributesMapperType.getStatusReader())) {
            channelSource.setFlagComparisonValue(directoryIdentityAttributesMapperType.getComparisonValue());
            channelSource.setFlagComparisonStatus(directoryIdentityAttributesMapperType.getComparisonValueStatus());
        }
        channelSource.setTimeStampAttributeName(srcType.getTimestampAttributeName());
        String algName = srcType.getChangedUsersAlgorithm();
        if (algName != null) {
            channelSource.setChangedUsersAlgorithm(algName);
            if ("Active Directory USN".equals(algName)) {
                channelSource.setUsnAttributeName(srcType.getUsnAttributeName());
            } else if ("Timestamp".equals(algName) || "Timestamp No Negation".equals(algName)) {
                channelSource.setTimeStampAttributeName(srcType.getTimestampAttributeName());
            }
            if (srcType.getUserObjectClass() != null) {
                channelSource.setUserObjectClass(srcType.getUserObjectClass());
            }
        }
        if (srcType.getGroupObjectClass() != null) {
            channelSource.setGroupObjectClass(srcType.getGroupObjectClass());
        } else {
            LdapDataSource d = MgmtFactory.getDataSourceManager().getLdapDataSource(srcType.getDataSourceId());
            if (d == null || !d.isActiveDirectoryType()) {
                channelSource.setGroupObjectClass("groupOfUniqueNames");
            } else {
                channelSource.setGroupObjectClass("group");
            }
        }
        channelSource.setGroupMemberAttributeName(srcType.getGroupMemberAttributeName());
        channelSource.setMemberOfGroupAttributeName(srcType.getMemberOfGroupAttributeName());
        channelSource.setUserBaseDN(srcType.getUsersBaseDN());
        channelSource.setFilterForUsers(srcType.getFilter());
        channelSource.setGroupDNForUsers(srcType.getGroupDN());
        channelSource.setGroupFilterForGroups(srcType.getGroupFilterForGroups());
        channelSource.setGroupDNForGroups(srcType.getGroupDNForGroups());
        channelSource.setUserNestedSearch(srcType.getUserNestedSearch());
        channelSource.setGroupNestedSearch(srcType.getGroupNestedSearch());
        return channelSource;
    }

    public static void saveToBeanDoc(SourceType srcType, ChannelSource src) {
        String algName;
        String dataSourceId = src.getDataSourceId();
        srcType.setDataSourceId(dataSourceId);
        LdapGuidFormatter formatter = src.getGuidFormatter();
        LdapGuidFormatterType ldapGuidFormatterType = srcType.addNewLdapGuidFormatter();
        ldapGuidFormatterType.setGuidAttributeName(formatter.getGuidAttributeName());
        ldapGuidFormatterType.setGuidIsBinary(formatter.isGuidIsBinary());
        DirectoryIdentityAttributesMapperType directoryIdentityAttributesMapperType = srcType.addNewDirectoryIdentityAttributesMapper();
        directoryIdentityAttributesMapperType.setStatusReader(src.getAccountStatusAlgorithm());
        directoryIdentityAttributesMapperType.setAttributeName(src.getAccountStatusAttributeName());
        directoryIdentityAttributesMapperType.setDefault(src.isDefaultStatus());
        if ("Flag".equals(src.getAccountStatusAlgorithm())) {
            directoryIdentityAttributesMapperType.setComparisonValue(src.getFlagComparisonValue());
            directoryIdentityAttributesMapperType.setComparisonValueStatus(src.isFlagComparisonStatus());
        }
        if (src.getTimeStampAttributeName() != null) {
            srcType.setTimestampAttributeName(src.getTimeStampAttributeName());
        }
        if ((algName = src.getChangedUsersAlgorithm()) != null) {
            srcType.setChangedUsersAlgorithm(algName);
            if ("Active Directory USN".equals(algName)) {
                srcType.setUsnAttributeName(src.getUsnAttributeName());
            } else if ("Timestamp".equals(algName) || "Timestamp No Negation".equals(algName)) {
                srcType.setTimestampAttributeName(src.getTimeStampAttributeName());
            }
            if (src.getUserObjectClass() != null) {
                srcType.setUserObjectClass(src.getUserObjectClass());
            }
            if (src.getGroupObjectClass() != null) {
                srcType.setGroupObjectClass(src.getGroupObjectClass());
            }
        }
        if (src.getGroupMemberAttributeName() != null) {
            srcType.setGroupMemberAttributeName(src.getGroupMemberAttributeName());
        }
        if (src.getMemberOfGroupAttributeName() != null) {
            srcType.setMemberOfGroupAttributeName(src.getMemberOfGroupAttributeName());
        }
        srcType.setUsersBaseDN(src.getUserBaseDN());
        if (!StringUtils.isEmpty((String)src.getFilterForUsers())) {
            srcType.setFilter(src.getFilterForUsers());
        }
        if (!StringUtils.isEmpty((String)src.getGroupDNForUsers())) {
            srcType.setGroupDN(src.getGroupDNForUsers());
        }
        if (!StringUtils.isEmpty((String)src.getGroupFilterForGroups())) {
            srcType.setGroupFilterForGroups(src.getGroupFilterForGroups());
        }
        if (!StringUtils.isEmpty((String)src.getGroupDNForGroups())) {
            srcType.setGroupDNForGroups(src.getGroupDNForGroups());
        }
        srcType.setUserNestedSearch(src.isUserNestedSearch());
        srcType.setGroupNestedSearch(src.isGroupNestedSearch());
    }
}

