/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.xml.util;

import com.pingidentity.crypto.Password;
import com.pingidentity.provisioner.ProvisionerPluginNotFoundException;
import com.pingidentity.provisioner.domain.target.SaasTarget;
import com.pingidentity.provisioner.saas.BaseSaasPlugin;
import com.pingidentity.provisioner.saas.SaasPluginManager;
import com.pingidentity.provisioner.saas.SaasProvisionerPlugin;
import com.pingidentity.x2008.x06.saasProvisioner.TargetParameterType;
import com.pingidentity.x2008.x06.saasProvisioner.TargetType;
import java.util.ArrayList;
import java.util.List;
import org.sourceid.saml20.adapter.conf.Field;
import org.sourceid.saml20.adapter.conf.FieldList;
import org.sourceid.saml20.adapter.conf.SimpleFieldList;
import org.sourceid.saml20.adapter.gui.FieldDescriptor;
import org.sourceid.saml20.adapter.gui.TextFieldDescriptor;

public abstract class SaasDriverUtil {
    private static final String TARGET_DRIVER_CLASS_GOOGLE = "com.pingidentity.provisioner.saas.google.GoogleDriver";
    public static final String TARGET_ID_GOOGLE = "Google";
    public static final String ADMIN_PARAMETER_NAME_GOOGLE = "adminEmail";
    public static final String PASSWORD_PARAMETER_NAME_GOOGLE = "adminPassword";
    private static final String TARGET_DRIVER_CLASS_SFDC = "com.pingidentity.provisioner.saas.salesforce.SalesforceDriver";
    public static final String TARGET_ID_SFDC = "SalesForce";
    public static final String ADMIN_PARAMETER_NAME_SFDC = "adminUsername";
    public static final String PASSWORD_PARAMETER_NAME_SFDC = "adminPassword";
    public static final String ENVIRONMENT_PARAMETER_NAME_SFDC = "endPoint";

    public static SaasTarget constructSaasTarget(TargetType targetType) {
        ArrayList<Field> targetParameters = new ArrayList<Field>();
        String targetId = null;
        String saasDriverClass = targetType.getDriverClass();
        if (saasDriverClass != null) {
            String userParameterName = null;
            String passwordParameterName = null;
            if (saasDriverClass.equals(TARGET_DRIVER_CLASS_GOOGLE)) {
                targetId = TARGET_ID_GOOGLE;
                userParameterName = ADMIN_PARAMETER_NAME_GOOGLE;
                passwordParameterName = "adminPassword";
            } else if (saasDriverClass.equals(TARGET_DRIVER_CLASS_SFDC)) {
                targetId = TARGET_ID_SFDC;
                userParameterName = ADMIN_PARAMETER_NAME_SFDC;
                passwordParameterName = "adminPassword";
            }
            String adminUserName = targetType.getAdminUsername();
            Field adminParameter = new Field(userParameterName, adminUserName);
            targetParameters.add(adminParameter);
            String obfuscatredPass = targetType.getAdminPassword();
            Password password = new Password(obfuscatredPass);
            String adminPassword = password.getStrValue();
            Field passwordParameter = new Field(passwordParameterName, adminPassword);
            targetParameters.add(passwordParameter);
            if (saasDriverClass.equals(TARGET_DRIVER_CLASS_SFDC)) {
                String environmentValue = targetType.getEnvironment().toLowerCase();
                Field environmentParameter = new Field(ENVIRONMENT_PARAMETER_NAME_SFDC, environmentValue);
                targetParameters.add(environmentParameter);
            }
        } else {
            targetId = targetType.getId();
            List<TextFieldDescriptor> encryptedParameterDescriptors = SaasDriverUtil.getDescriptorsForEncryptedParameters(targetId);
            for (TargetParameterType parameterType : targetType.getParameterArray()) {
                String parameterName = parameterType.getName();
                String parameterValue = parameterType.getValue();
                for (TextFieldDescriptor encryptedParameterDescriptor : encryptedParameterDescriptors) {
                    if (!parameterName.equals(encryptedParameterDescriptor.getName())) continue;
                    Password password = new Password(parameterValue);
                    parameterValue = password.getStrValue();
                    break;
                }
                Field parameter = new Field(parameterName, parameterValue);
                targetParameters.add(parameter);
            }
        }
        SimpleFieldList parameterValues = new SimpleFieldList(targetParameters);
        return new SaasTarget(targetId, parameterValues);
    }

    public static BaseSaasPlugin constructSaasDriver(SaasTarget saasTarget) {
        SaasPluginManager pluginManager = SaasPluginManager.getInstance();
        BaseSaasPlugin saasPlugin = (BaseSaasPlugin)pluginManager.getPluginInstance(saasTarget.getPluginId());
        saasPlugin.setParameters((FieldList)saasTarget.getParameterValues());
        return saasPlugin;
    }

    public static void saveToBeanDoc(TargetType targetType, SaasTarget target) throws ProvisionerPluginNotFoundException {
        String pluginId = target.getPluginId();
        targetType.setId(target.getPluginId());
        SaasProvisionerPlugin plugin = SaasPluginManager.getInstance().getPluginInstance(pluginId);
        if (plugin == null) {
            throw new ProvisionerPluginNotFoundException("Unable to load plugin with ID: " + pluginId);
        }
        List<FieldDescriptor> parameterDesriptors = plugin.getParameterDescriptors();
        SimpleFieldList parameterValues = target.getParameterValues();
        for (FieldDescriptor parameterDescriptor : parameterDesriptors) {
            TargetParameterType parameterType = targetType.addNewParameter();
            String parameterName = parameterDescriptor.getName();
            String parameterValue = parameterValues.getFieldValue(parameterName);
            if (parameterDescriptor instanceof TextFieldDescriptor && ((TextFieldDescriptor)parameterDescriptor).isEncrypted() && parameterValue != null) {
                parameterValue = Password.obfuscateAndEncode((String)parameterValue);
            }
            parameterType.setName(parameterName);
            parameterType.setValue(parameterValue);
        }
    }

    private static List<TextFieldDescriptor> getDescriptorsForEncryptedParameters(String saasPluginId) {
        ArrayList<TextFieldDescriptor> encryptedParameters = new ArrayList<TextFieldDescriptor>();
        SaasProvisionerPlugin plugin = SaasPluginManager.getInstance().getPluginInstance(saasPluginId);
        if (plugin != null) {
            List<FieldDescriptor> parameterDesriptors = plugin.getParameterDescriptors();
            for (FieldDescriptor parameterDescriptor : parameterDesriptors) {
                if (!(parameterDescriptor instanceof TextFieldDescriptor) || !((TextFieldDescriptor)parameterDescriptor).isEncrypted()) continue;
                encryptedParameters.add((TextFieldDescriptor)parameterDescriptor);
            }
        }
        return encryptedParameters;
    }
}

