/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.access;

import com.pingidentity.sdk.internal.interfaces.CertWrapper;
import com.pingidentity.sdk.internal.interfaces.PkCertWrapper;
import com.pingidentity.sdk.internal.services.ArgPair;
import com.pingidentity.sdk.internal.services.ServiceFactory;
import com.pingidentity.sdk.internal.services.interfaces.KeyAccessorService;
import java.security.cert.X509Certificate;
import javax.security.auth.x500.X500PrivateCredential;

public class KeyAccessor {
    private final KeyAccessorService keyAccessorService = ServiceFactory.getSingleImpl(KeyAccessorService.class, new ArgPair[0]);

    public X500PrivateCredential getClientSslKeypair(String alias) {
        PkCertWrapper pkCert = this.keyAccessorService.getClientSslPkCert(alias);
        if (pkCert != null) {
            return new X500PrivateCredential(pkCert.getX509Certificate(), pkCert.getPrivateKey(), pkCert.getAlias());
        }
        throw new RuntimeException("No key pair found for alias: " + alias);
    }

    public X500PrivateCredential getDsigKeypair(String alias) {
        PkCertWrapper pkCert = this.keyAccessorService.getDsigPkCert(alias);
        if (pkCert != null) {
            return new X500PrivateCredential(pkCert.getX509Certificate(), pkCert.getPrivateKey(), pkCert.getAlias());
        }
        throw new RuntimeException("No key pair found for alias: " + alias);
    }

    public X509Certificate getEncryptionCertificate(String alias) {
        CertWrapper cert = this.keyAccessorService.getEncryptionCert(alias);
        if (cert != null) {
            return cert.getX509Certificate();
        }
        return null;
    }
}

