/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.sdk;

import com.pingidentity.sdk.internal.services.ArgPair;
import com.pingidentity.sdk.internal.services.ServiceFactory;
import com.pingidentity.sdk.internal.services.interfaces.CIDRService;
import java.net.UnknownHostException;

public class CIDRUtils {
    private final CIDRService cidrService;

    public CIDRUtils(String cidr) throws UnknownHostException {
        ArgPair<String> cidrArg = new ArgPair<String>(String.class, cidr);
        this.cidrService = ServiceFactory.getSingleImpl(CIDRService.class, cidrArg);
    }

    public String getNetworkAddress() {
        return this.cidrService.getNetworkAddress();
    }

    public String getBroadcastAddress() {
        return this.cidrService.getBroadcastAddress();
    }

    public boolean isInRange(String ipAddress) throws UnknownHostException {
        return this.cidrService.isInRange(ipAddress);
    }

    public String toString() {
        return this.cidrService.toString();
    }
}

