/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.sdk;

import java.util.AbstractCollection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.ClassUtils;
import org.sourceid.saml20.adapter.gui.ActionDescriptor;
import org.sourceid.saml20.adapter.gui.FieldDescriptor;
import org.sourceid.saml20.adapter.gui.ReadOnlyDescriptor;
import org.sourceid.saml20.adapter.gui.TableDescriptor;
import org.sourceid.saml20.adapter.gui.event.ConfigurationListener;
import org.sourceid.saml20.adapter.gui.event.PreRenderCallback;
import org.sourceid.saml20.adapter.gui.validation.ConfigurationValidator;

public class GuiConfigDescriptor {
    private String description;
    private List<FieldDescriptor> fields;
    private List<FieldDescriptor> advancedFields;
    private List<TableDescriptor> tables;
    private List<ActionDescriptor> actions;
    private List<ConfigurationValidator> validationChain;
    private List<ConfigurationListener> listenerChain;
    private List<PreRenderCallback> preRenderCallbackChain;
    private List<ReadOnlyDescriptor> summaryDescriptors = new LinkedList<ReadOnlyDescriptor>();

    public GuiConfigDescriptor() {
        this("");
    }

    public GuiConfigDescriptor(String description) {
        this.description = description;
        this.fields = new LinkedList<FieldDescriptor>();
        this.advancedFields = new LinkedList<FieldDescriptor>();
        this.tables = new LinkedList<TableDescriptor>();
        this.validationChain = new LinkedList<ConfigurationValidator>();
        this.listenerChain = new LinkedList<ConfigurationListener>();
        this.actions = new LinkedList<ActionDescriptor>();
        this.preRenderCallbackChain = new LinkedList<PreRenderCallback>();
    }

    public void addField(FieldDescriptor fieldDescriptor) {
        this.getFields().add(fieldDescriptor);
    }

    public List<FieldDescriptor> getFields() {
        return this.fields;
    }

    public void addAdvancedField(FieldDescriptor fieldDescriptor) {
        this.getAdvancedFields().add(fieldDescriptor);
    }

    public List<FieldDescriptor> getAdvancedFields() {
        return this.advancedFields;
    }

    public void addTable(TableDescriptor table) {
        this.getTables().add(table);
    }

    public List<TableDescriptor> getTables() {
        return this.tables;
    }

    public void addValidator(ConfigurationValidator configurationValidator) {
        this.getValidationChain().add(configurationValidator);
    }

    public void addListener(ConfigurationListener configurationListener) {
        this.getListenerChain().add(configurationListener);
    }

    public List<ConfigurationValidator> getValidationChain() {
        return this.validationChain;
    }

    public List<ConfigurationListener> getListenerChain() {
        return this.listenerChain;
    }

    public void addPreRenderCallback(PreRenderCallback callback) {
        this.getPreRenderCallbackChain().add(callback);
    }

    public List<PreRenderCallback> getPreRenderCallbackChain() {
        return this.preRenderCallbackChain;
    }

    public void addAction(ActionDescriptor action) {
        this.getActions().add(action);
    }

    public List<ActionDescriptor> getActions() {
        return this.actions;
    }

    public boolean hasActions() {
        return this.getActions().size() > 0;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Set<Class<? extends FieldDescriptor>> getAllDescriptorTypesInUse() {
        HashSet<Class> descriptorTypes = new HashSet<Class>();
        for (FieldDescriptor fieldDescriptor : this.getFields()) {
            descriptorTypes.addAll(this.getAllClassesFor(fieldDescriptor.getClass()));
        }
        for (FieldDescriptor fieldDescriptor : this.getAdvancedFields()) {
            descriptorTypes.addAll(this.getAllClassesFor(fieldDescriptor.getClass()));
        }
        for (TableDescriptor tableDescriptor : this.getTables()) {
            for (FieldDescriptor fieldDescriptor : tableDescriptor.getRowFields()) {
                descriptorTypes.addAll(this.getAllClassesFor(fieldDescriptor.getClass()));
            }
        }
        Set filteredDescriptors = descriptorTypes.stream().filter(clazz -> {
            try {
                clazz.asSubclass(FieldDescriptor.class);
                return true;
            }
            catch (ClassCastException e) {
                return false;
            }
        }).collect(() -> new HashSet(), HashSet::add, AbstractCollection::addAll);
        return filteredDescriptors;
    }

    private Set<Class> getAllClassesFor(Class clazz) {
        HashSet<Class> classes = new HashSet<Class>();
        classes.addAll(ClassUtils.getAllSuperclasses((Class)clazz));
        classes.addAll(ClassUtils.getAllInterfaces((Class)clazz));
        classes.addAll(Collections.singletonList(clazz));
        return classes;
    }

    public void addSummaryDescriptor(ReadOnlyDescriptor readOnlyDescriptor) {
        this.summaryDescriptors.add(readOnlyDescriptor);
    }

    public List<ReadOnlyDescriptor> getSummaryDescriptors() {
        return this.summaryDescriptors;
    }
}

