/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.sdk;

import java.util.Arrays;
import java.util.List;

public final class PingFederateProperties {
    private static final String PAGE_TITLE_PROPERTY_KEY = "pf.console.title";
    private static final String DEFAULT_ADMIN_PAGE_TITLE = "PingFederate";
    private static final String SHOW_BACKGROUND_IMAGE_PROPERTY_KEY = "pf.console.show.background.images";
    private static final String SHOW_BACKGROUND_IMAGE_PROPERTY_KEY_DEFAULT_VALUE = "true";
    private static final String PING_ONE_ADMIN_URL_REGION = "pf.pingone.admin.url.region";
    private static final String PING_ONE_ADMIN_URL_ENVIRONMENT_ID = "pf.pingone.admin.url.environment.id";
    private static final List<String> PING_ONE_ADMIN_URL_VALID_REGIONS = Arrays.asList("com", "eu", "asia", "ca", "com.au", "sg");

    private PingFederateProperties() {
    }

    public static String getAdminConsolePageTitle() {
        return System.getProperty(PAGE_TITLE_PROPERTY_KEY, DEFAULT_ADMIN_PAGE_TITLE);
    }

    public static boolean getShowBackgroundImage() {
        return Boolean.parseBoolean(System.getProperty(SHOW_BACKGROUND_IMAGE_PROPERTY_KEY, SHOW_BACKGROUND_IMAGE_PROPERTY_KEY_DEFAULT_VALUE));
    }

    public static String getPingOneAdminUrlRegion() {
        String region = System.getProperty(PING_ONE_ADMIN_URL_REGION, "");
        if (PING_ONE_ADMIN_URL_VALID_REGIONS.contains(region)) {
            return region;
        }
        return "";
    }

    public static String getPingOneAdminUrlEnvironmentId() {
        return System.getProperty(PING_ONE_ADMIN_URL_ENVIRONMENT_ID, "");
    }
}

