/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.sdk;

import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class SearchCriteria {
    private int startIndex;
    private int itemsRequested;
    private String query;
    private List<FilterItem> filterBy = new LinkedList<FilterItem>();
    private List<OrderByItem> orderBy = new LinkedList<OrderByItem>();

    private SearchCriteria(int startIndex, int itemsRequested) {
        this.startIndex = startIndex;
        this.itemsRequested = itemsRequested;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public void setStartIndex(int startIndex) {
        this.startIndex = startIndex;
    }

    public int getItemsRequested() {
        return this.itemsRequested;
    }

    public void setItemsRequested(int itemsRequested) {
        this.itemsRequested = itemsRequested;
    }

    public void addOrderBy(OrderByItem orderByItem) {
        this.orderBy.add(orderByItem);
    }

    public void addFilterBy(FilterItem filterItem) {
        this.filterBy.add(filterItem);
    }

    public List<FilterItem> getFilterBy() {
        return this.filterBy;
    }

    public void setFilterBy(List<FilterItem> filterBy) {
        this.filterBy = filterBy;
    }

    public List<OrderByItem> getOrderBy() {
        return this.orderBy;
    }

    public void setOrderBy(List<OrderByItem> orderBy) {
        this.orderBy = orderBy;
    }

    public static final class Builder {
        private static final String ASTERISK = "*";
        private SearchCriteria searchCriteria;

        public Builder(int startIndex, int itemsRequested) {
            this.searchCriteria = new SearchCriteria(startIndex, itemsRequested);
        }

        public Builder(SearchCriteria searchCriteria) {
            this.searchCriteria = searchCriteria;
        }

        public Builder query(String query) {
            String normalizedQuery = StringUtils.stripStart((String)query, (String)ASTERISK);
            normalizedQuery = StringUtils.stripEnd((String)normalizedQuery, (String)ASTERISK);
            this.searchCriteria.setQuery(normalizedQuery);
            return this;
        }

        public Builder addOrderBy(OrderByItem orderByItem) {
            this.searchCriteria.addOrderBy(orderByItem);
            return this;
        }

        public Builder addFilter(FilterItem filterItem) {
            this.searchCriteria.addFilterBy(filterItem);
            return this;
        }

        public Builder setFilterItems(List<FilterItem> filterItemList) {
            this.searchCriteria.setFilterBy(filterItemList);
            return this;
        }

        private void setOrderBy(List<OrderByItem> orderByItems) {
            this.searchCriteria.setOrderBy(orderByItems);
        }

        public SearchCriteria build() {
            return this.searchCriteria;
        }
    }

    public static final class FilterItem {
        private String fieldName;
        private Object value;

        public FilterItem(String fieldName, Object value) {
            this.fieldName = fieldName;
            this.value = value;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }
    }

    public static final class OrderByItem {
        private String sortFieldName;
        private Order order;

        public OrderByItem(String sortFieldName, Order order) {
            this.sortFieldName = sortFieldName;
            this.order = order;
        }

        public String getSortFieldName() {
            return this.sortFieldName;
        }

        public void setSortFieldName(String sortFieldName) {
            this.sortFieldName = sortFieldName;
        }

        public Order getOrder() {
            return this.order;
        }

        public void setOrder(Order order) {
            this.order = order;
        }
    }

    public static enum Order {
        ASC,
        DESC;

    }
}

