/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.sdk.accessgrant;

import com.pingidentity.sdk.authorizationdetails.AuthorizationDetails;
import com.pingidentity.sdk.internal.services.ArgPair;
import com.pingidentity.sdk.internal.services.ServiceFactory;
import com.pingidentity.sdk.internal.services.interfaces.AccessGrantService;
import com.pingidentity.sdk.oauth20.Scope;
import java.util.Date;

public class AccessGrant {
    private String guid;
    private String hashedRefreshTokenValue;
    private String uniqueUserIdentifier;
    private String grantType;
    private String contextualQualifier;
    private Scope scope;
    private String clientId;
    private AuthorizationDetails authorizationDetails;
    private long issued;
    private long updated;
    private Long expires;

    public AccessGrant(String hashedRefreshTokenValue, String guid, String uniqueUserId, String grantType, Scope scope, String clientId, long issued, long updated, Long expires, String ctxQual) {
        this.hashedRefreshTokenValue = hashedRefreshTokenValue;
        this.guid = guid;
        this.uniqueUserIdentifier = uniqueUserId;
        this.issued = issued;
        this.updated = updated;
        this.expires = expires;
        this.scope = scope;
        this.clientId = clientId;
        this.grantType = grantType;
        this.contextualQualifier = ctxQual;
    }

    public AccessGrant(String rawValue, String uniqueUserId, Scope scope, String clientId, String grantType, String ctxQual) {
        long now;
        this.setRawRefreshTokenValue(rawValue);
        this.guid = ServiceFactory.getSingleImpl(AccessGrantService.class, new ArgPair[0]).generateID(32);
        this.uniqueUserIdentifier = uniqueUserId;
        this.issued = now = System.currentTimeMillis();
        this.updated = now;
        this.expires = null;
        this.scope = scope;
        this.clientId = clientId;
        this.grantType = grantType;
        this.contextualQualifier = ctxQual;
    }

    public AccessGrant(String uniqueUserId, Scope scope, String clientId, String grantType, String ctxQual) {
        long now;
        this.guid = ServiceFactory.getSingleImpl(AccessGrantService.class, new ArgPair[0]).generateID(32);
        this.uniqueUserIdentifier = uniqueUserId;
        this.issued = now = System.currentTimeMillis();
        this.updated = now;
        this.expires = null;
        this.scope = scope;
        this.clientId = clientId;
        this.grantType = grantType;
        this.contextualQualifier = ctxQual;
    }

    public String getGuid() {
        return this.guid;
    }

    public void setGuid(String guid) {
        this.guid = guid;
    }

    public String getGrantType() {
        return this.grantType;
    }

    public String getHashedRefreshTokenValue() {
        return this.hashedRefreshTokenValue;
    }

    public void setRawRefreshTokenValue(String rawValue) {
        if (rawValue != null) {
            this.hashedRefreshTokenValue = ServiceFactory.getSingleImpl(AccessGrantService.class, new ArgPair[0]).digestToken(rawValue);
        }
    }

    public String getUniqueUserIdentifer() {
        return this.uniqueUserIdentifier;
    }

    public void setUniqueUserIdentifer(String uniqueUserIdentifier) {
        this.uniqueUserIdentifier = uniqueUserIdentifier;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public Scope getScope() {
        return this.scope;
    }

    public void setScope(Scope scope) {
        this.scope = scope;
    }

    public AuthorizationDetails getAuthorizationDetails() {
        return this.authorizationDetails;
    }

    public void setAuthorizationDetails(AuthorizationDetails authorizationDetails) {
        this.authorizationDetails = authorizationDetails;
    }

    public long getIssued() {
        return this.issued;
    }

    public long getUpdated() {
        return this.updated;
    }

    public void setExpires(Long expires) {
        this.expires = expires;
    }

    public Long getExpires() {
        return this.expires;
    }

    public String getContextualQualifier() {
        return this.contextualQualifier;
    }

    public void setContextualQualifier(String contextualQualifier) {
        this.contextualQualifier = contextualQualifier;
    }

    public boolean isExpired() {
        boolean expired = false;
        Long grantExpiration = this.getExpires();
        if (grantExpiration != null && this.getExpires() > 0L) {
            long nowInMilli = new Date().getTime();
            if (grantExpiration <= nowInMilli) {
                expired = true;
            }
        }
        return expired;
    }
}

