/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.sdk.captchaprovider;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CaptchaContext {
    private final HttpServletRequest request;
    private final HttpServletResponse response;
    private final String action;
    private final Map<String, Object> inParameters;

    private CaptchaContext(Builder builder) {
        this.request = builder.request;
        this.response = builder.response;
        this.action = builder.action;
        this.inParameters = builder.inParameters;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public String getAction() {
        return this.action;
    }

    public Map<String, Object> getInParameters() {
        return this.inParameters;
    }

    public static class Builder {
        private HttpServletRequest request;
        private HttpServletResponse response;
        private String action;
        private Map<String, Object> inParameters = new HashMap<String, Object>();

        public Builder setRequest(HttpServletRequest request) {
            this.request = request;
            return this;
        }

        public Builder setResponse(HttpServletResponse response) {
            this.response = response;
            return this;
        }

        public Builder setInParameters(Map<String, Object> inParameters) {
            this.inParameters = inParameters;
            return this;
        }

        public Builder setAction(String action) {
            this.action = action;
            return this;
        }

        public CaptchaContext build() {
            return new CaptchaContext(this);
        }
    }
}

