/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.sdk.captchaprovider;

import com.pingidentity.sdk.AuthnAdapterResponse;
import com.pingidentity.sdk.Plugin;
import com.pingidentity.sdk.captchaprovider.CaptchaContext;
import com.pingidentity.sdk.captchaprovider.CaptchaResult;
import java.util.Collections;
import java.util.Map;

public interface CaptchaProvider
extends Plugin {
    public static final String IDENTIFY_ACTION = "identify";
    public static final String LOGIN_ACTION = "login";
    public static final String USERNAME_RECOVERY_ACTION = "usernameRecovery";
    public static final String PASSWORD_RESET_ACTION = "passwordReset";
    public static final String PASSWORD_CHANGE_ACTION = "passwordChange";
    public static final String REGISTRATION_ACTION = "registration";

    public String getJavaScriptFileName();

    public Map<String, Object> getCaptchaAttributes(CaptchaContext var1);

    public CaptchaResult validateCaptcha(CaptchaContext var1);

    default public void postAuthenticationCallback(AuthenticationStatus authenticationStatus, CaptchaContext captchaContext) {
    }

    public static final class AuthenticationStatus {
        public final AuthnAdapterResponse authnAdapterResponse;

        public AuthenticationStatus(AuthnAdapterResponse authnAdapterResponse) {
            this.authnAdapterResponse = authnAdapterResponse;
        }

        public AuthnAdapterResponse.AUTHN_STATUS getAuthnStatus() {
            return this.authnAdapterResponse.getAuthnStatus();
        }

        public Map<String, Object> getAttributeMap() {
            return Collections.unmodifiableMap(this.authnAdapterResponse.getAttributeMap());
        }

        public int getErrorCode() {
            return this.authnAdapterResponse.getErrorCode();
        }

        public String getUsername() {
            return this.authnAdapterResponse.getUsername();
        }

        public String getErrorMessage() {
            return this.authnAdapterResponse.getErrorMessage();
        }
    }
}

