/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.sdk.internal.services;

import com.pingidentity.sdk.internal.services.ArgPair;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ServiceFactory {
    private static final Log logger = LogFactory.getLog(ServiceFactory.class);
    private static final Map<Class<?>, List<Class<?>>> SERVICE_CACHE = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <T> List<Class<?>> getImplClasses(Class<T> clazz) {
        List<Class<?>> returnValue = SERVICE_CACHE.get(clazz);
        if (returnValue != null) return new ArrayList(returnValue);
        Class<ServiceFactory> clazz2 = ServiceFactory.class;
        synchronized (ServiceFactory.class) {
            returnValue = SERVICE_CACHE.get(clazz);
            if (returnValue != null) return new ArrayList(returnValue);
            returnValue = new ArrayList();
            ServiceLoader<T> serviceLoader = ServiceLoader.load(clazz);
            try {
                for (T t : serviceLoader) {
                    returnValue.add(t.getClass());
                }
            }
            catch (ServiceConfigurationError e) {
                logger.error((Object)("Encountered ServiceConfigurationError trying to load Services for " + clazz), (Throwable)e);
                throw e;
            }
            SERVICE_CACHE.put(clazz, returnValue);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return new ArrayList(returnValue);
        }
    }

    public static <T> T getSingleImpl(Class<T> clazz, ArgPair<?> ... args) {
        List<Class<?>> classes = ServiceFactory.getImplClasses(clazz);
        if (classes.isEmpty() || classes.get(0) == null) {
            throw new RuntimeException("No Impl found for " + clazz);
        }
        Class<?> implClazz = classes.get(0);
        Constructor<?> declaredConstructor = ServiceFactory.getConstructor(args, implClazz);
        Object obj = ServiceFactory.getObject(clazz, args, declaredConstructor, implClazz);
        if (classes.size() > 1) {
            logger.warn((Object)("Multiple implementations found of (" + clazz.getName() + "). One expected. Using the first (" + implClazz.getName() + "). This is non-deterministic!"));
        }
        return clazz.cast(obj);
    }

    private static <T> Object getObject(Class<T> clazz, ArgPair<?>[] args, Constructor<?> declaredConstructor, Class<?> implClazz) {
        try {
            Object[] argPairValues = ServiceFactory.getArgPairValues(args);
            return declaredConstructor.newInstance(argPairValues);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException("Unable to instantiate " + implClazz + " was the impl found for " + clazz, e);
        }
    }

    private static Constructor<?> getConstructor(ArgPair<?>[] args, Class<?> implClazz) {
        try {
            Class<?>[] argClasses = ServiceFactory.getArgPairClasses(args);
            return implClazz.getDeclaredConstructor(argClasses);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("constructor not found for " + implClazz + " with args " + Arrays.toString(args));
        }
    }

    private static Class<?>[] getArgPairClasses(ArgPair<?> ... args) {
        Class[] classes = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            classes[i] = args[i].getClazz();
        }
        return classes;
    }

    private static Object[] getArgPairValues(ArgPair<?> ... args) {
        Object[] values = new Object[args.length];
        for (int i = 0; i < args.length; ++i) {
            values[i] = args[i].getValue();
        }
        return values;
    }
}

