/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.sdk.password;

import com.pingidentity.sdk.internal.services.ArgPair;
import com.pingidentity.sdk.internal.services.ServiceFactory;
import com.pingidentity.sdk.internal.services.interfaces.LocaleService;
import com.pingidentity.sdk.locale.LanguagePackMessages;
import com.pingidentity.sdk.locale.Message;
import com.pingidentity.sdk.password.PasswordPolicyRequirementValidationException;
import com.pingidentity.sdk.password.PasswordResetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class PasswordPolicyRequirementResetException
extends PasswordResetException {
    private final List<Message> requirementsMet;
    private final List<Message> requirementsNotMet;
    private final LocaleService localeService;

    public PasswordPolicyRequirementResetException(String message, List<Message> requirementsMet, List<Message> requirementsNotMet) {
        super(true, message);
        this.requirementsMet = requirementsMet;
        this.requirementsNotMet = requirementsNotMet;
        this.localeService = ServiceFactory.getSingleImpl(LocaleService.class, new ArgPair[0]);
    }

    public List<String> getRequirementsMet(Locale locale) {
        ArrayList<String> reqMetString = new ArrayList<String>(this.requirementsMet.size());
        LanguagePackMessages languagePackMessages = this.localeService.getLanguagePackMessagesForHtmlTemplates(locale);
        PasswordPolicyRequirementValidationException.populateMsgListFromReqMessages(reqMetString, languagePackMessages, this.requirementsMet);
        return reqMetString;
    }

    public List<String> getRequirementsNotMet(Locale locale) {
        ArrayList<String> reqMetString = new ArrayList<String>(this.requirementsNotMet.size());
        LanguagePackMessages languagePackMessages = this.localeService.getLanguagePackMessagesForHtmlTemplates(locale);
        PasswordPolicyRequirementValidationException.populateMsgListFromReqMessages(reqMetString, languagePackMessages, this.requirementsNotMet);
        return reqMetString;
    }
}

