/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.sdk.secretmanager;

import com.pingidentity.sdk.internal.services.ArgPair;
import com.pingidentity.sdk.internal.services.ServiceFactory;
import com.pingidentity.sdk.internal.services.interfaces.SecretManagerService;

public class SecretReferenceUtil {
    private SecretReferenceUtil() {
    }

    public static String getSecretManagerId(String secretReference) {
        if (!SecretReferenceUtil.isSecretReference(secretReference)) {
            return null;
        }
        String[] tokens = secretReference.split(":", 4);
        if (tokens.length < 3) {
            return null;
        }
        return tokens[2];
    }

    public static String getSecretId(String secretReference) {
        if (!SecretReferenceUtil.isSecretReference(secretReference)) {
            return null;
        }
        String[] tokens = secretReference.split(":", 4);
        if (tokens.length < 3) {
            return null;
        }
        if (tokens.length < 4) {
            return "";
        }
        return tokens[3];
    }

    public static boolean isSecretReference(String secretReference) {
        return secretReference != null && secretReference.startsWith("OBF:MGR:");
    }

    public static boolean validateSecretManagerId(String secretReference) {
        return ServiceFactory.getSingleImpl(SecretManagerService.class, new ArgPair[0]).validateSecretManagerId(SecretReferenceUtil.getSecretManagerId(secretReference));
    }
}

