/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.adapter.attribute;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;

public class AttributeValue
implements Serializable {
    private static final long serialVersionUID = 20050515L;
    static final String DEFAULT_NULL_MASK = "";
    private boolean masked;
    private Collection<String> values;
    private Collection<?> objValues;

    public AttributeValue() {
        this(Collections.emptyList());
    }

    public AttributeValue(Collection<String> values) {
        this.values = values == null ? new ArrayList() : values;
        this.objValues = this.values;
    }

    public AttributeValue(String value) {
        this(Arrays.asList(value));
    }

    public AttributeValue(Collection<String> strVals, Collection<?> objVals) {
        this.values = strVals;
        this.objValues = objVals;
    }

    public AttributeValue(AttributeValue copyFrom) {
        this.masked = copyFrom.masked;
        this.values = copyFrom.values;
        this.objValues = copyFrom.objValues;
    }

    public boolean isMultiValue() {
        return this.values.size() > 1;
    }

    public String getValue() {
        return this.getValue(false);
    }

    public String getValue(boolean enforceMasking) {
        String value = null;
        if (!this.values.isEmpty() && (value = this.values.iterator().next()) != null && enforceMasking && this.masked) {
            value = "*****";
        }
        return value;
    }

    public String getValue(String nullMask) {
        String value = this.getValue();
        return value == null ? nullMask : value;
    }

    public String getValueMaskNull() {
        return this.getValue(DEFAULT_NULL_MASK);
    }

    public Iterable<String> getValues() {
        return this.values;
    }

    public Collection<String> getValuesAsCollection() {
        return this.values;
    }

    public boolean hasValue(String value) {
        return this.values.contains(value);
    }

    public Iterable<? extends Object> getAllObjectValues() {
        return this.objValues;
    }

    public Object getObjectValue() {
        return this.objValues.isEmpty() ? null : this.objValues.iterator().next();
    }

    public String toString() {
        return this.isMultiValue() ? this.values.toString() : this.getValue("null");
    }

    public String sensitiveToString() {
        if (this.masked) {
            if (this.isMultiValue()) {
                return "*****(x" + this.values.size() + ")";
            }
            return this.getValue(true);
        }
        return this.toString();
    }

    public boolean isMasked() {
        return this.masked;
    }

    public void setMasked(boolean masked) {
        this.masked = masked;
    }

    public HashSet<String> getValuesAsHashSet() {
        HashSet<String> valuesAsHashSet = new HashSet<String>();
        for (String value : this.getValues()) {
            valuesAsHashSet.add(value);
        }
        return valuesAsHashSet;
    }
}

