/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.adapter.conf;

import com.pingidentity.sdk.SDKConstants;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.sourceid.saml20.adapter.conf.Field;
import org.sourceid.saml20.adapter.conf.FieldList;
import org.sourceid.saml20.adapter.conf.Table;

public class Configuration
extends FieldList
implements Serializable {
    private static final long serialVersionUID = 20050515L;
    private List<Table> tables;
    private FieldList advancedFields;
    private Set<String> maskedAttrNames = Collections.emptySet();
    private Set<String> additionalAttrNames = new HashSet<String>();
    private Set<String> multiValuedAttributes = new HashSet<String>();
    private String id;

    public Configuration() {
        this(new ArrayList<Field>(), new ArrayList<Table>(), new ArrayList<Field>());
    }

    public Configuration(List<Field> fields, List<Table> tables, List<Field> advancedFields) {
        super(fields);
        this.tables = tables;
        this.advancedFields = new FieldList(advancedFields){};
    }

    public Configuration(List<Field> fields, List<Table> tables, FieldList advancedFields) {
        super(fields);
        this.tables = tables;
        this.advancedFields = advancedFields;
    }

    public Configuration(Configuration configuration) {
        super(new ArrayList<Field>(configuration.getFields()));
        ArrayList<Object> advancedFieldsList = new ArrayList();
        if (configuration.getAdvancedFields() != null && CollectionUtils.isNotEmpty(configuration.getAdvancedFields().getFields())) {
            advancedFieldsList = new ArrayList<Field>(configuration.getAdvancedFields().getFields());
        }
        this.tables = configuration.getTables() != null ? new ArrayList<Table>(configuration.getTables()) : Collections.emptyList();
        this.advancedFields = new FieldList(advancedFieldsList){};
    }

    public List<Table> getTables() {
        return this.tables;
    }

    public Table getTable(String tableName) {
        for (Table table : this.getTables()) {
            if (!tableName.equals(table.getName())) continue;
            return table;
        }
        return null;
    }

    public FieldList getAdvancedFields() {
        return this.advancedFields;
    }

    public Set<String> getMaskedAttrNames() {
        return this.maskedAttrNames;
    }

    public void setMaskedAttrNames(Set<String> maskedAttrNames) {
        this.maskedAttrNames = maskedAttrNames;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Set<String> getAdditionalAttrNames() {
        return this.additionalAttrNames;
    }

    public void setAdditionalAttrNames(Set<String> additionalAttrNames) {
        this.additionalAttrNames = additionalAttrNames;
    }

    public Set<String> getMultiValuedAttributes() {
        return this.multiValuedAttributes;
    }

    public void setMultiValuedAttributes(Set<String> multiValuedAttributes) {
        this.multiValuedAttributes = multiValuedAttributes;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + ": " + SDKConstants.LINE_BREAK + super.toString() + SDKConstants.LINE_BREAK + " Tables: " + this.tables + SDKConstants.LINE_BREAK + "Advanced" + this.advancedFields.toString();
    }
}

