/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.adapter.conf;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StringDeserializer;
import com.pingidentity.common.util.B64;
import com.pingidentity.sdk.internal.services.ArgPair;
import com.pingidentity.sdk.internal.services.ServiceFactory;
import com.pingidentity.sdk.internal.services.interfaces.ObfuscatorService;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang3.StringUtils;

@ApiModel(value="FieldEntry", description="A simple name value pair to represent a field entry.")
@XmlRootElement(name="FieldEntry")
public class Field
implements Serializable {
    private static final long serialVersionUID = 20050515L;
    public static final int DEFAULT_NUM_VAL = 0;
    private String value;
    @JsonDeserialize(using=StringDeserializer.class)
    private String name;
    private String label;

    public Field() {
    }

    public Field(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public Field(String name, String label, String value) {
        this.name = name;
        this.label = label;
        this.value = value;
    }

    @ApiModelProperty(value="The name of this field.", required=true)
    public String getName() {
        return this.name;
    }

    @ApiModelProperty(value="The value of this field. Whether or not the value is required will be determined by plugin validation checks.")
    public String getValue() {
        return this.value;
    }

    @JsonIgnore
    public String getLabel() {
        if (StringUtils.isEmpty((CharSequence)this.label)) {
            return this.name;
        }
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    @JsonIgnore
    public int getValueAsInt() {
        try {
            return Integer.parseInt(this.value);
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return 0;
    }

    @JsonIgnore
    public long getValueAsLong() {
        try {
            return Long.parseLong(this.value);
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return 0L;
    }

    @JsonIgnore
    public float getValueAsFloat() {
        try {
            return Float.parseFloat(this.value);
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return 0.0f;
    }

    @JsonIgnore
    public double getValueAsDouble() {
        try {
            return Double.parseDouble(this.value);
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return 0.0;
    }

    @JsonIgnore
    public boolean getValueAsBoolean() {
        return Boolean.parseBoolean(this.value);
    }

    @JsonIgnore
    public byte[] getFileValueAsByteArray() {
        byte[] bytes = ServiceFactory.getSingleImpl(ObfuscatorService.class, new ArgPair[0]).deobfuscateBinary(this.value);
        if (bytes == null) {
            bytes = B64.decodeToBytes(this.value);
        }
        return bytes;
    }

    @JsonIgnore
    public String getFileValueAsString() {
        String text = null;
        try {
            text = ServiceFactory.getSingleImpl(ObfuscatorService.class, new ArgPair[0]).deobfuscate(this.value);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (StringUtils.isEmpty(text)) {
            text = B64.decodeToString(this.value);
        }
        return text;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":" + this.name + "=" + this.value;
    }
}

