/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.adapter.gui;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.sourceid.saml20.adapter.gui.FieldDescriptor;
import org.sourceid.saml20.adapter.gui.SelectFieldDescriptor;

public abstract class AbstractSelectionFieldDescriptor
extends FieldDescriptor {
    public static final String NONE_SELECTED = "None Selected";
    protected List<OptionValue> optionValues;

    protected AbstractSelectionFieldDescriptor(String name, String description, String[] optionValues) {
        super(name, description);
        this.optionValues = new ArrayList<OptionValue>(optionValues.length);
        for (String s : optionValues) {
            this.optionValues.add(new OptionValue(s, s));
        }
    }

    protected AbstractSelectionFieldDescriptor(String name, String description, List<OptionValue> optionValues) {
        super(name, description);
        this.optionValues = new ArrayList<OptionValue>(optionValues);
    }

    public List<OptionValue> getOptionValues() {
        return this.optionValues;
    }

    public void setOptionValues(List<OptionValue> optionValues) {
        this.optionValues = optionValues;
    }

    @Override
    public String getFormattedValue(String value) {
        String result = value;
        for (OptionValue optionValue : this.getOptionValues()) {
            if (!StringUtils.equals((CharSequence)optionValue.value, (CharSequence)value) && (!StringUtils.isEmpty((CharSequence)optionValue.value) || !StringUtils.isEmpty((CharSequence)value)) && !optionValue.getIsDefault()) continue;
            result = optionValue.name;
        }
        if (StringUtils.isEmpty((CharSequence)value) && StringUtils.equals((CharSequence)SelectFieldDescriptor.SELECT_ONE.getName(), (CharSequence)result)) {
            result = NONE_SELECTED;
        }
        return result;
    }

    public static class OptionValue
    implements Serializable {
        String name;
        String value;
        boolean isDefault = false;
        public static final Comparator<OptionValue> NAME_COMPARATOR = (a, b) -> a.getName().compareToIgnoreCase(b.getName());

        public OptionValue(String name, String value, boolean aDefault) {
            this(name, value);
            this.isDefault = aDefault;
        }

        public OptionValue(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public boolean getIsDefault() {
            return this.isDefault;
        }
    }
}

