/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.adapter.gui;

import com.pingidentity.sdk.internal.interfaces.CertWrapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.sourceid.saml20.adapter.gui.AbstractSelectionFieldDescriptor;
import org.sourceid.saml20.adapter.gui.SelectFieldDescriptor;

public abstract class CertificateSelectionFieldDescriptor
extends SelectFieldDescriptor {
    public static final int DEFAULT_SUBJECT_DN_LENGTH_FOR_DISPLAY = 35;

    public CertificateSelectionFieldDescriptor(String name, String description) {
        super(name, description);
    }

    protected abstract Set<? extends CertWrapper> getCertSet();

    @Override
    public List<AbstractSelectionFieldDescriptor.OptionValue> getOptionValues() {
        this.optionValues = new ArrayList();
        this.optionValues.add(SELECT_ONE);
        Set<? extends CertWrapper> certSet = this.getCertSet();
        if (certSet != null) {
            List certValues = certSet.stream().map(cert -> new AbstractSelectionFieldDescriptor.OptionValue(cert.getDescriptionForDisplay(35), cert.getAlias())).collect(Collectors.toList());
            this.optionValues.addAll(certValues);
        }
        return this.optionValues;
    }

    @Override
    public String getFormattedValue(String value) {
        String result = value;
        Set<? extends CertWrapper> certSet = this.getCertSet();
        for (CertWrapper certWrapper : certSet) {
            if (!StringUtils.equals((CharSequence)certWrapper.getAlias(), (CharSequence)value)) continue;
            result = certWrapper.getDescriptionForDisplay();
        }
        if (StringUtils.isEmpty((CharSequence)value)) {
            result = "None Selected";
        }
        return result;
    }
}

