/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.adapter.gui;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import org.sourceid.saml20.adapter.gui.validation.FieldValidator;

public abstract class FieldDescriptor
implements Serializable {
    private static final long serialVersionUID = 20050515L;
    private final String name;
    private final String description;
    private final List<FieldValidationWrapper> validationChain;
    private String label;
    private String defaultValue;
    private String defaultForLegacyConfig;
    private boolean isHidden;

    protected FieldDescriptor(String name, String description) {
        this.name = name;
        this.label = name;
        this.description = description;
        this.validationChain = new LinkedList<FieldValidationWrapper>();
    }

    public String getName() {
        return this.name;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getLabel() {
        return this.label;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String getFormattedValue(String value) {
        return value;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void setDefaultForLegacyConfig(String defaultValue) {
        this.defaultForLegacyConfig = defaultValue;
    }

    public String getDefaultForLegacyConfig() {
        return this.defaultForLegacyConfig;
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public void setHidden(boolean hidden) {
        this.isHidden = hidden;
    }

    public void addValidator(FieldValidator validator) {
        this.addValidator(validator, false);
    }

    public void addValidator(FieldValidator validator, boolean skipIfEmptyValue) {
        this.validationChain.add(new FieldValidationWrapper(validator, skipIfEmptyValue));
    }

    public List<FieldValidationWrapper> getValidationChain() {
        return this.validationChain;
    }

    public class FieldValidationWrapper
    implements Serializable {
        private static final long serialVersionUID = 20050515L;
        private final FieldValidator validator;
        private final boolean skipIfValueIsEmpty;

        public FieldValidationWrapper(FieldValidator validator, boolean skipIfValueIsEmpty) {
            this.validator = validator;
            this.skipIfValueIsEmpty = skipIfValueIsEmpty;
        }

        public FieldValidator getValidator() {
            return this.validator;
        }

        public boolean isSkipIfValueIsEmpty() {
            return this.skipIfValueIsEmpty;
        }
    }
}

