/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.adapter.gui;

import com.pingidentity.sdk.internal.services.ArgPair;
import com.pingidentity.sdk.internal.services.ServiceFactory;
import com.pingidentity.sdk.internal.services.interfaces.FilterableSearchFieldService;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.sourceid.saml20.adapter.conf.Field;
import org.sourceid.saml20.adapter.gui.FieldDescriptor;
import org.sourceid.saml20.adapter.gui.PolicyContractFieldDescriptor;
import org.sourceid.saml20.adapter.gui.validation.FieldValidator;
import org.sourceid.saml20.adapter.gui.validation.ValidationException;

public abstract class FilterableSelectionFieldDescriptor
extends FieldDescriptor {
    private static final long serialVersionUID = 1L;
    public static final String SELECTED_VALUE_DELIMITER = "-";
    public static final String STORAGE_KEY_DELIMITER = "|";

    private List<String> getSupportedSearchTypePrefix() {
        return this.getSearchableTypes().stream().map(searchableTypeConfig -> searchableTypeConfig.getSearchableType().getTabTitle()).collect(Collectors.toList());
    }

    public final boolean isValidFormat(String selectedTypeAndId) {
        if (StringUtils.isNotBlank((CharSequence)selectedTypeAndId)) {
            for (String prefix : this.getSupportedSearchTypePrefix()) {
                if (!selectedTypeAndId.matches(Pattern.quote(prefix + SELECTED_VALUE_DELIMITER) + ".+")) continue;
                return true;
            }
        }
        return false;
    }

    public abstract List<SearchableTypeConfig> getSearchableTypes();

    public String parseSelectedValueForStorage(String selectedValue) {
        String prefix = StringUtils.substringBefore((String)selectedValue, (String)SELECTED_VALUE_DELIMITER);
        String id = StringUtils.substringAfter((String)selectedValue, (String)SELECTED_VALUE_DELIMITER);
        if (StringUtils.isEmpty((CharSequence)prefix) || StringUtils.isEmpty((CharSequence)id)) {
            throw new RuntimeException("Invalid format for selected value: " + selectedValue);
        }
        SearchableTypeConfig typeConfig = this.getSearchableTypes().stream().filter(aConfig -> prefix.equals(aConfig.getSearchableType().getTabTitle())).findFirst().orElse(null);
        if (typeConfig == null) {
            throw new RuntimeException("Unexpected prefix for selected value: " + selectedValue);
        }
        return typeConfig.getStorageKeyPrefix() + STORAGE_KEY_DELIMITER + typeConfig.getSearchableType().getStorageIdFromSearchableId(id);
    }

    public String getSelectedDisplayName(String valueForStorage) {
        if (StringUtils.isNotEmpty((CharSequence)valueForStorage)) {
            String prefix = StringUtils.substringBefore((String)valueForStorage, (String)STORAGE_KEY_DELIMITER);
            String id = StringUtils.substringAfter((String)valueForStorage, (String)STORAGE_KEY_DELIMITER);
            SearchableTypeConfig typeConfig = this.getSearchableTypes().stream().filter(aConfig -> prefix.equals(aConfig.getStorageKeyPrefix())).findFirst().orElse(null);
            if (typeConfig == null) {
                throw new RuntimeException("Unexpected prefix for stored value: " + valueForStorage);
            }
            return typeConfig.getSearchableType().getDisplayFromStorageId(id);
        }
        return "";
    }

    @Override
    public String getFormattedValue(String value) {
        return this.getSelectedDisplayName(value);
    }

    public FilterableSelectionFieldDescriptor(String name, String description) {
        super(name, description);
    }

    public static class FilterableSelectionFieldDefaultValidator
    implements FieldValidator {
        private final FilterableSelectionFieldDescriptor fieldDescriptor;

        public FilterableSelectionFieldDefaultValidator(FilterableSelectionFieldDescriptor fieldDescriptor) {
            this.fieldDescriptor = fieldDescriptor;
        }

        @Override
        public void validate(Field field) throws ValidationException {
            String storageKey = field.getValue();
            if (StringUtils.isBlank((CharSequence)this.fieldDescriptor.getSelectedDisplayName(storageKey))) {
                throw new ValidationException(this.fieldDescriptor.getName() + " " + storageKey + " is not found.");
            }
        }
    }

    public static class SearchableTypeConfig
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public static final String IDP_CONNECTION_KEY_PREFIX = "idp-conn";
        public static final String SP_CONNECTION_KEY_PREFIX = "sp-conn";
        public static final String IDP_ADAPTER_KEY_PREFIX = "idp-adapter";
        public static final String SP_ADAPTER_KEY_PREFIX = "sp-adapter";
        public static final String OAUTH_CLIENT_KEY_PREFIX = "oauth-client";
        public static final String OAUTH_COMMON_SCOPE_PREFIX = "oauth-common-scope";
        public static final String OAUTH_COMMON_SCOPE_GROUP_PREFIX = "oauth-common-scope-group";
        public static final String OAUTH_EXCLUSIVE_SCOPE_PREFIX = "oauth-exclusive-scope";
        public static final String OAUTH_EXCLUSIVE_SCOPE_GROUP_PREFIX = "oauth-exclusive-scope-group";
        public static final String APC_KEY_PREFIX = "apc";
        public static final String SELECTOR_KEY_PREFIX = "selector";
        public static final String LOCAL_IDENTITY_PROFILE_KEY_PREFIX = "lip";
        public static final String POLICY_FRAGMENT_PREFIX = "fragment";
        private final SearchableType searchableType;
        private final List<QueryParam> queryParamList;
        private String storageKeyPrefix;
        public static final SearchableTypeConfig IDP_CONNECTION = new SearchableTypeConfig(SearchableType.IDP_CONNECTION, Collections.emptyList(), "idp-conn");
        public static final SearchableTypeConfig SP_CONNECTION = new SearchableTypeConfig(SearchableType.SP_CONNECTION, Collections.emptyList(), "sp-conn");
        public static final SearchableTypeConfig IDP_ADAPTER = new SearchableTypeConfig(SearchableType.IDP_ADAPTER, Collections.emptyList(), "idp-adapter");
        public static final SearchableTypeConfig SP_ADAPTER = new SearchableTypeConfig(SearchableType.SP_ADAPTER, Collections.emptyList(), "sp-adapter");
        public static final SearchableTypeConfig OAUTH_CLIENT = new SearchableTypeConfig(SearchableType.OAUTH_CLIENT, Collections.emptyList(), "oauth-client");
        public static final SearchableTypeConfig OAUTH_COMMON_SCOPE = new SearchableTypeConfig(SearchableType.OAUTH_COMMON_SCOPE, Collections.emptyList(), "oauth-common-scope");
        public static final SearchableTypeConfig OAUTH_COMMON_SCOPE_GROUP = new SearchableTypeConfig(SearchableType.OAUTH_COMMON_SCOPE_GROUP, Collections.emptyList(), "oauth-common-scope-group");
        public static final SearchableTypeConfig OAUTH_EXCLUSIVE_SCOPE = new SearchableTypeConfig(SearchableType.OAUTH_EXCLUSIVE_SCOPE, Collections.emptyList(), "oauth-exclusive-scope");
        public static final SearchableTypeConfig OAUTH_EXCLUSIVE_SCOPE_GROUP = new SearchableTypeConfig(SearchableType.OAUTH_EXCLUSIVE_SCOPE_GROUP, Collections.emptyList(), "oauth-exclusive-scope-group");
        public static final SearchableTypeConfig AUTH_POLICY_CONTRACT = new SearchableTypeConfig(SearchableType.AUTHN_POLICY_CONTRACT, Collections.emptyList(), "apc");
        public static final SearchableTypeConfig SELECTOR = new SearchableTypeConfig(SearchableType.SELECTOR, Collections.emptyList(), "selector");
        public static final SearchableTypeConfig LOCAL_IDENTITY_PROFILE = new SearchableTypeConfig(SearchableType.LOCAL_IDENTITY_PROFILE, Collections.emptyList(), "lip");
        public static final SearchableTypeConfig POLICY_FRAGMENT = new SearchableTypeConfig(SearchableType.POLICY_FRAGMENT, Collections.emptyList(), "fragment");

        public SearchableTypeConfig(SearchableType searchableType, List<QueryParam> queryParamList) {
            this.searchableType = searchableType;
            this.queryParamList = queryParamList;
        }

        public SearchableTypeConfig(SearchableType searchableType, List<QueryParam> queryParamList, String storageKeyPrefix) {
            this(searchableType, queryParamList);
            this.storageKeyPrefix = storageKeyPrefix;
        }

        public SearchableType getSearchableType() {
            return this.searchableType;
        }

        public List<QueryParam> getQueryParamConfigList() {
            return this.queryParamList;
        }

        public String getStorageKeyPrefix() {
            return this.storageKeyPrefix;
        }
    }

    public static class QueryParam
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String queryParam;
        private final String value;

        public QueryParam(String queryParam, String value) {
            this.queryParam = queryParam;
            this.value = value;
        }

        public String getQueryParam() {
            return this.queryParam;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static class SearchableType
    implements Serializable {
        public static final SearchableType IDP_CONNECTION = new SearchableType("IDP_CONNECTION", "IdP Connections", "/sp/idpConnections", "entityId", "name"){

            @Override
            String getStorageIdFromSearchableId(String searchableId) {
                return ServiceFactory.getSingleImpl(FilterableSearchFieldService.class, new ArgPair[0]).getConnectionStorageIdFromSearchableId(searchableId, this.name());
            }

            @Override
            String getDisplayFromStorageId(String storageId) {
                return ServiceFactory.getSingleImpl(FilterableSearchFieldService.class, new ArgPair[0]).getConnectionDisplayFromStorageId(storageId, this.name());
            }
        };
        public static final SearchableType SP_CONNECTION = new SearchableType("SP_CONNECTION", "SP Connections", "/idp/spConnections", "entityId", "name"){

            @Override
            String getStorageIdFromSearchableId(String searchableId) {
                return ServiceFactory.getSingleImpl(FilterableSearchFieldService.class, new ArgPair[0]).getConnectionStorageIdFromSearchableId(searchableId, this.name());
            }

            @Override
            String getDisplayFromStorageId(String storageId) {
                return ServiceFactory.getSingleImpl(FilterableSearchFieldService.class, new ArgPair[0]).getConnectionDisplayFromStorageId(storageId, this.name());
            }
        };
        public static final SearchableType IDP_ADAPTER = new SearchableType("IDP_ADAPTER", "IdP Adapters", "/idp/adapters", "id", "name");
        public static final SearchableType SP_ADAPTER = new SearchableType("SP_ADAPTER", "SP Adapters", "/sp/adapters", "id", "name");
        public static final SearchableType OAUTH_CLIENT = new SearchableType("OAUTH_CLIENT", "OAuth Clients", "/oauth/clients", "clientId", "name");
        public static final SearchableType OAUTH_COMMON_SCOPE = new SearchableType("OAUTH_COMMON_SCOPE", "OAuth Common Scopes", "/oauth/authServerSettings/scopes/commonScopes", "name", "name");
        public static final SearchableType OAUTH_COMMON_SCOPE_GROUP = new SearchableType("OAUTH_COMMON_SCOPE_GROUP", "OAuth Common Scope Groups", "/oauth/authServerSettings/scopes/commonScopeGroups", "name", "name");
        public static final SearchableType OAUTH_EXCLUSIVE_SCOPE = new SearchableType("OAUTH_EXCLUSIVE_SCOPE", "OAuth Exclusive Scopes", "/oauth/authServerSettings/scopes/exclusiveScopes", "name", "name");
        public static final SearchableType OAUTH_EXCLUSIVE_SCOPE_GROUP = new SearchableType("OAUTH_EXCLUSIVE_SCOPE_GROUP", "OAuth Exclusive Scope Groups", "/oauth/authServerSettings/scopes/exclusiveScopeGroups", "name", "name");
        public static final SearchableType AUTHN_POLICY_CONTRACT = new SearchableType("AUTHN_POLICY_CONTRACT", "Policy Contracts", "/authenticationPolicyContracts", "id", "name"){

            @Override
            String getDisplayFromStorageId(String storageId) {
                return ServiceFactory.getSingleImpl(FilterableSearchFieldService.class, new ArgPair[0]).getDisplayNameForStorage(storageId, new PolicyContractFieldDescriptor(null, null));
            }
        };
        public static final SearchableType SELECTOR = new SearchableType("SELECTOR", "Selectors", "/authenticationSelectors", "id", "name");
        public static final SearchableType LOCAL_IDENTITY_PROFILE = new SearchableType("LOCAL_IDENTITY_PROFILE", "Local Identity Profiles", "/localIdentity/identityProfiles", "id", "name");
        public static final SearchableType POLICY_FRAGMENT = new SearchableType("POLICY_FRAGMENT", "Fragments", "/authenticationPolicies/fragments", "id", "name");
        private static final String apiPrefix = "/pf-admin-api/v1";
        private static final Map<String, SearchableType> tabTitleToSearchableTypeMap = new HashMap<String, SearchableType>();
        private final String name;
        private final String tabTitle;
        private final String endpoint;
        private final String idField;
        private final String displayNameField;

        public SearchableType(String name, String tabTitle, String endpoint, String idField, String displayNameField) {
            this.name = name;
            this.tabTitle = tabTitle;
            this.endpoint = apiPrefix + endpoint;
            this.idField = idField;
            this.displayNameField = displayNameField;
        }

        String getStorageIdFromSearchableId(String searchableId) {
            return searchableId;
        }

        String getDisplayFromStorageId(String storageId) {
            return storageId;
        }

        public static String getApiPrefix() {
            return apiPrefix;
        }

        public String getEndpoint() {
            return this.endpoint;
        }

        public String getIdField() {
            return this.idField;
        }

        public String getDisplayNameField() {
            return this.displayNameField;
        }

        public String getTabTitle() {
            return this.tabTitle;
        }

        public String name() {
            return this.name;
        }

        public static SearchableType fromTabTitle(String title) throws SearchableTypeNotFound {
            SearchableType type = tabTitleToSearchableTypeMap.get(title);
            if (type != null) {
                return type;
            }
            throw new SearchableTypeNotFound("No type found for '" + title + "'");
        }

        static {
            tabTitleToSearchableTypeMap.put(IDP_CONNECTION.getTabTitle(), IDP_CONNECTION);
            tabTitleToSearchableTypeMap.put(SP_CONNECTION.getTabTitle(), SP_CONNECTION);
            tabTitleToSearchableTypeMap.put(IDP_ADAPTER.getTabTitle(), IDP_ADAPTER);
            tabTitleToSearchableTypeMap.put(SP_ADAPTER.getTabTitle(), SP_ADAPTER);
            tabTitleToSearchableTypeMap.put(OAUTH_CLIENT.getTabTitle(), OAUTH_CLIENT);
            tabTitleToSearchableTypeMap.put(OAUTH_COMMON_SCOPE.getTabTitle(), OAUTH_COMMON_SCOPE);
            tabTitleToSearchableTypeMap.put(OAUTH_COMMON_SCOPE_GROUP.getTabTitle(), OAUTH_COMMON_SCOPE_GROUP);
            tabTitleToSearchableTypeMap.put(OAUTH_EXCLUSIVE_SCOPE.getTabTitle(), OAUTH_EXCLUSIVE_SCOPE);
            tabTitleToSearchableTypeMap.put(OAUTH_EXCLUSIVE_SCOPE_GROUP.getTabTitle(), OAUTH_EXCLUSIVE_SCOPE_GROUP);
            tabTitleToSearchableTypeMap.put(AUTHN_POLICY_CONTRACT.getTabTitle(), AUTHN_POLICY_CONTRACT);
            tabTitleToSearchableTypeMap.put(SELECTOR.getTabTitle(), SELECTOR);
            tabTitleToSearchableTypeMap.put(LOCAL_IDENTITY_PROFILE.getTabTitle(), LOCAL_IDENTITY_PROFILE);
            tabTitleToSearchableTypeMap.put(POLICY_FRAGMENT.getTabTitle(), POLICY_FRAGMENT);
        }

        public static class SearchableTypeNotFound
        extends Exception {
            private static final long serialVersionUID = 1L;

            SearchableTypeNotFound(String message) {
                super(message);
            }

            public SearchableTypeNotFound(String message, Throwable cause) {
                super(message, cause);
            }
        }
    }
}

