/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.adapter.gui;

import com.pingidentity.sdk.internal.services.ArgPair;
import com.pingidentity.sdk.internal.services.ServiceFactory;
import com.pingidentity.sdk.internal.services.interfaces.FilterableSearchFieldService;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.sourceid.saml20.adapter.gui.FilterableSelectionFieldDescriptor;

public class OAuthClientSelectionFieldDescriptor
extends FilterableSelectionFieldDescriptor {
    private final List<FilterableSelectionFieldDescriptor.SearchableTypeConfig> oAuthClientSearchableConfigList;
    private final Set<String> includeGrantTypeSet;

    public OAuthClientSelectionFieldDescriptor(String name, String description, List<GrantType> includeGrantTypeList) {
        super(name, description);
        this.includeGrantTypeSet = includeGrantTypeList.stream().map(GrantType::getId).collect(Collectors.toSet());
        FilterableSelectionFieldDescriptor.QueryParam queryParam = new FilterableSelectionFieldDescriptor.QueryParam(FilterableField.GRANT_TYPE.toString(), StringUtils.join(this.includeGrantTypeSet, (String)","));
        this.oAuthClientSearchableConfigList = Collections.singletonList(new FilterableSelectionFieldDescriptor.SearchableTypeConfig(FilterableSelectionFieldDescriptor.SearchableType.OAUTH_CLIENT, Collections.singletonList(queryParam)));
    }

    @Override
    public String parseSelectedValueForStorage(String selectedValue) {
        if (this.isValidFormat(selectedValue)) {
            return selectedValue.split("-", 2)[1];
        }
        return selectedValue;
    }

    @Override
    public String getSelectedDisplayName(String valueForStorage) {
        return ServiceFactory.getSingleImpl(FilterableSearchFieldService.class, new ArgPair[0]).getDisplayNameForStorage(valueForStorage, this);
    }

    @Override
    public String getFormattedValue(String value) {
        if (value != null) {
            String result = this.getSelectedDisplayName(value);
            if (!"".equals(result)) {
                return result;
            }
            return String.format("%s (Deleted)", value);
        }
        return "";
    }

    @Override
    public List<FilterableSelectionFieldDescriptor.SearchableTypeConfig> getSearchableTypes() {
        return this.oAuthClientSearchableConfigList;
    }

    public Set<String> getIncludeGrantTypeSet() {
        return this.includeGrantTypeSet;
    }

    public static enum GrantType {
        AUTHORIZATION_CODE("authorization_code"),
        RESOURCE_OWNER_PASSWORD_CREDENTIALS("password"),
        CLIENT_CREDENTIALS("client_credentials"),
        REFRESH_TOKEN("refresh_token"),
        IMPLICIT("implicit"),
        EXTENSION("extension"),
        PING_VALIDATE("urn:pingidentity.com:oauth2:grant_type:validate_bearer"),
        SAML2_BEARER("urn:ietf:params:oauth:grant-type:saml2-bearer"),
        DEVICE_CODE("urn:ietf:params:oauth:grant-type:device_code");

        private final String id;

        private GrantType(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }
    }

    public static enum FilterableField {
        CERT_ISSUER_ID,
        CIBA_POLICY_ID,
        DEFAULT_ATM_ID,
        GRANT_TYPE,
        OIDC_POLICY_ID,
        TEPP_ID;

    }
}

