/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.adapter.gui;

import java.util.LinkedList;
import java.util.List;
import org.sourceid.saml20.adapter.gui.FieldDescriptor;
import org.sourceid.saml20.adapter.gui.validation.RowValidator;
import org.sourceid.saml20.adapter.gui.validation.TableValidator;

public class TableDescriptor {
    private String name;
    private String label;
    private String description;
    private boolean requireDefaultRow;
    private List<FieldDescriptor> row;
    private List<RowValidator> validationChain;
    private List<TableValidator> tableValidatorChain;

    public TableDescriptor(String name, String description) {
        this(name, description, new LinkedList<FieldDescriptor>());
    }

    public TableDescriptor(String name, String description, boolean requireDefaultRow) {
        this(name, description, new LinkedList<FieldDescriptor>());
        this.requireDefaultRow = requireDefaultRow;
    }

    public TableDescriptor(String name, String description, List<FieldDescriptor> row) {
        this.name = name;
        this.label = name;
        this.description = description;
        this.row = row;
        this.validationChain = new LinkedList<RowValidator>();
        this.tableValidatorChain = new LinkedList<TableValidator>();
    }

    public String getDescription() {
        return this.description;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getLabel() {
        return this.label;
    }

    public String getName() {
        return this.name;
    }

    public List<FieldDescriptor> getRowFields() {
        return this.row;
    }

    public void addRowField(FieldDescriptor fieldDescriptor) {
        this.getRowFields().add(fieldDescriptor);
    }

    public void addValidator(RowValidator validator) {
        this.getValidationChain().add(validator);
    }

    public List<RowValidator> getValidationChain() {
        return this.validationChain;
    }

    public void addTableValidator(TableValidator validator) {
        this.tableValidatorChain.add(validator);
    }

    public List<TableValidator> getTableValidationChain() {
        return this.tableValidatorChain;
    }

    public boolean getRequireDefaultRow() {
        return this.requireDefaultRow;
    }
}

