/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.adapter.gui.validation.impl;

import org.sourceid.saml20.adapter.conf.Field;
import org.sourceid.saml20.adapter.gui.validation.FieldValidator;
import org.sourceid.saml20.adapter.gui.validation.ValidationException;

public class IntegerValidator
implements FieldValidator {
    private int lowerBound = Integer.MIN_VALUE;
    private int upperBound = Integer.MAX_VALUE;

    public IntegerValidator() {
    }

    public IntegerValidator(int lowerBound, int upperBound) {
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
    }

    @Override
    public void validate(Field field) throws ValidationException {
        try {
            Integer tmpInt = Integer.parseInt(field.getValue());
            if (tmpInt < this.lowerBound || tmpInt > this.upperBound) {
                throw new ValidationException("'" + field.getLabel() + "' is out of range, please enter a value between " + this.lowerBound + " and " + this.upperBound + ".");
            }
        }
        catch (NumberFormatException ex) {
            throw new ValidationException("'" + field.getLabel() + "' is not a valid Integer: '" + field.getValue() + "'.");
        }
    }
}

