/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.adapter.gui.validation.impl;

import org.sourceid.saml20.adapter.conf.Field;
import org.sourceid.saml20.adapter.gui.validation.FieldValidator;
import org.sourceid.saml20.adapter.gui.validation.ValidationException;

public class LongValidator
implements FieldValidator {
    private long lowerBound = Long.MIN_VALUE;
    private long upperBound = Long.MAX_VALUE;

    public LongValidator() {
    }

    public LongValidator(long lowerBound, long upperBound) {
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
    }

    @Override
    public void validate(Field field) throws ValidationException {
        try {
            Long tmp = Long.parseLong(field.getValue());
            if (tmp < this.lowerBound || tmp > this.upperBound) {
                throw new ValidationException("'" + field.getLabel() + "' is out of range, please enter a value between " + this.lowerBound + " and " + this.upperBound + ".");
            }
        }
        catch (NumberFormatException ex) {
            throw new ValidationException("'" + field.getLabel() + "' is not a valid Long: '" + field.getValue() + "'.");
        }
    }
}

