/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.adapter.gui.validation.impl;

import com.pingidentity.sdk.secretmanager.SecretReferenceUtil;
import org.apache.commons.lang3.StringUtils;
import org.sourceid.saml20.adapter.conf.Field;
import org.sourceid.saml20.adapter.gui.validation.FieldValidator;
import org.sourceid.saml20.adapter.gui.validation.ValidationException;

public class SecretReferenceFieldValidator
implements FieldValidator {
    private static final String INVALID_FORMAT_ERROR_MSG = "'%s' invalid: Expected format 'OBF:MGR:{secretManagerId}:{secretId}'";
    private static final String INSTANCE_NOT_FOUND_ERROR_MSG = "Invalid secret manager id for %s. The specified secret manager is not found.";

    @Override
    public void validate(Field field) throws ValidationException {
        String fieldLabel = field.getLabel();
        String fieldValue = field.getValue();
        if (StringUtils.isNotBlank((CharSequence)fieldValue)) {
            if (!SecretReferenceUtil.isSecretReference(fieldValue.trim())) {
                throw new ValidationException(String.format(INVALID_FORMAT_ERROR_MSG, fieldLabel));
            }
            if (!SecretReferenceUtil.validateSecretManagerId(fieldValue.trim())) {
                throw new ValidationException(String.format(INSTANCE_NOT_FOUND_ERROR_MSG, fieldLabel));
            }
        }
    }
}

