/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.adapter.gui.validation.impl;

import org.apache.commons.lang3.StringUtils;
import org.sourceid.saml20.adapter.conf.Field;
import org.sourceid.saml20.adapter.gui.validation.FieldValidator;
import org.sourceid.saml20.adapter.gui.validation.ValidationException;

public class StringLengthValidator
implements FieldValidator {
    private final int maxLength;

    public StringLengthValidator(int maxLength) {
        this.maxLength = maxLength;
    }

    @Override
    public void validate(Field field) throws ValidationException {
        int length;
        String str = field.getValue();
        if (StringUtils.isNotBlank((CharSequence)str) && (length = str.length()) > this.maxLength) {
            throw new ValidationException("Length of '" + field.getLabel() + "' (" + length + ") is longer than the permitted max length of: " + this.maxLength);
        }
    }
}

