/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.adapter.idp.authn;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;

public class AuthnPolicy
implements Serializable {
    private boolean allowUserInteraction;
    private boolean reauthenticate;
    private boolean registrationRequested;
    private List<String> requestedAuthnContexts = Collections.emptyList();

    public AuthnPolicy(boolean allowUserInteraction, boolean reauthenticate) {
        this.allowUserInteraction = allowUserInteraction;
        this.reauthenticate = reauthenticate;
        this.registrationRequested = false;
    }

    public AuthnPolicy(boolean allowUserInteraction, boolean reauthenticate, List<String> requestedAuthnContexts) {
        this(allowUserInteraction, reauthenticate);
        if (requestedAuthnContexts != null) {
            this.requestedAuthnContexts = requestedAuthnContexts;
        }
    }

    public AuthnPolicy(boolean allowUserInteraction, boolean reauthenticate, boolean registrationRequested) {
        this.allowUserInteraction = allowUserInteraction;
        this.reauthenticate = reauthenticate;
        this.registrationRequested = registrationRequested;
    }

    public AuthnPolicy(boolean allowUserInteraction, boolean reauthenticate, boolean registrationRequested, List<String> requestedAuthnContexts) {
        this(allowUserInteraction, reauthenticate, registrationRequested);
        if (requestedAuthnContexts != null) {
            this.requestedAuthnContexts = requestedAuthnContexts;
        }
    }

    public boolean allowUserInteraction() {
        return this.allowUserInteraction;
    }

    public boolean reauthenticate() {
        return this.reauthenticate;
    }

    public boolean registrationRequested() {
        return this.registrationRequested;
    }

    public List<String> getRequestAuthnContexts() {
        return this.requestedAuthnContexts;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.allowUserInteraction ? 1231 : 1237);
        result = 31 * result + (this.reauthenticate ? 1231 : 1237);
        result = 31 * result + (this.registrationRequested ? 1231 : 1237);
        result = 31 * result + (this.requestedAuthnContexts == null ? 0 : this.requestedAuthnContexts.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AuthnPolicy other = (AuthnPolicy)obj;
        if (this.allowUserInteraction != other.allowUserInteraction) {
            return false;
        }
        if (this.reauthenticate != other.reauthenticate) {
            return false;
        }
        if (this.registrationRequested != other.registrationRequested) {
            return false;
        }
        return !(this.requestedAuthnContexts == null ? other.requestedAuthnContexts != null : !this.requestedAuthnContexts.equals(other.requestedAuthnContexts));
    }
}

