/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.adapter.state;

import java.io.Serializable;
import java.time.Clock;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.sourceid.saml20.adapter.state.SessionStateCleanable;
import org.sourceid.saml20.adapter.state.SessionStateSupport;

public class ApplicationSessionStateSupport
extends SessionStateSupport {
    private final int maxTimeoutInMinutes;
    private final int idleTimeoutInMinutes;
    private final String activityKey;
    private final SessionStateCleanable cleanable;
    private Clock clock = Clock.systemDefaultZone();

    public ApplicationSessionStateSupport(String baseApplicationKey, SessionStateCleanable cleanable) {
        this.idleTimeoutInMinutes = this.getSessionStateSupportService().getCapIdleTimeoutMins();
        this.maxTimeoutInMinutes = this.getSessionStateSupportService().getApplicationPolicyMaxTimeoutMins();
        this.cleanable = cleanable;
        this.activityKey = this.getClass().getSimpleName() + ":" + baseApplicationKey + ":activity";
    }

    public ApplicationSessionStateSupport(String baseApplicationKey, int idleTimeoutInMinutes, int maxTimeoutInMinutes, SessionStateCleanable cleanable) {
        this.activityKey = this.getClass().getSimpleName() + ":" + baseApplicationKey + ":activity";
        this.idleTimeoutInMinutes = this.getSessionStateSupportService().getCapIdleTimeoutMins(idleTimeoutInMinutes);
        this.maxTimeoutInMinutes = maxTimeoutInMinutes;
        this.cleanable = cleanable;
    }

    @Override
    @Deprecated
    public void setAttribute(String name, Object value, HttpServletRequest req, HttpServletResponse resp) {
        this.manageSession(req, resp);
        super.setAttribute(name, value, req, resp);
    }

    @Override
    public void setAttribute(String name, Object value, HttpServletRequest req, HttpServletResponse resp, boolean usedAsLoginCtx) {
        this.manageSession(req, resp);
        super.setAttribute(name, value, req, resp, usedAsLoginCtx);
    }

    @Override
    public Object getAttribute(String name, HttpServletRequest req, HttpServletResponse resp) {
        this.manageSession(req, resp);
        return super.getAttribute(name, req, resp);
    }

    private void manageSession(HttpServletRequest req, HttpServletResponse resp) {
        ActivitySession activitySession = (ActivitySession)req.getAttribute(this.activityKey);
        if (activitySession != null) {
            return;
        }
        activitySession = (ActivitySession)super.getAttribute(this.activityKey, req, resp);
        boolean saveActivitySession = true;
        if (activitySession == null) {
            activitySession = new ActivitySession(this.clock.millis(), this.clock.millis());
        } else {
            boolean isSessionExpired;
            long lastActivity = activitySession.getLastActivity();
            boolean bl = isSessionExpired = this.isTimeout(this.maxTimeoutInMinutes, activitySession.getStartActivity()) || this.isTimeout(this.idleTimeoutInMinutes, activitySession.getLastActivity());
            if (isSessionExpired) {
                if (this.cleanable != null) {
                    this.cleanable.cleanSessionState(this, req, resp);
                }
                activitySession = new ActivitySession(this.clock.millis(), this.clock.millis());
            } else {
                long thirtySecondsAgo = this.clock.millis() - 30000L;
                if (lastActivity < thirtySecondsAgo) {
                    activitySession = new ActivitySession(this.clock.millis(), activitySession.getStartActivity());
                } else {
                    saveActivitySession = false;
                }
            }
        }
        if (saveActivitySession) {
            super.setAttribute(this.activityKey, activitySession, req, resp, false);
            this.getSessionStateSupportService().refreshSessionInfo(req, resp);
        }
        req.setAttribute(this.activityKey, (Object)activitySession);
    }

    private boolean isTimeout(int inactivityTimeout, long lastActivity) {
        if (inactivityTimeout < 0) {
            return false;
        }
        if (lastActivity < 0L) {
            return true;
        }
        return lastActivity + (long)inactivityTimeout * 1000L * 60L <= this.clock.millis();
    }

    protected synchronized void setClock(Clock clock) {
        this.clock = clock;
    }

    private static class ActivitySession
    implements Serializable {
        private static final long serialVersionUID = -2910936897219052024L;
        private final long lastActivity;
        private final long startActivity;

        ActivitySession(long lastActivity, long startActivity) {
            this.lastActivity = lastActivity;
            this.startActivity = startActivity;
        }

        long getLastActivity() {
            return this.lastActivity;
        }

        long getStartActivity() {
            return this.startActivity;
        }
    }
}

