/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain;

import com.pingidentity.sdk.internal.services.ArgPair;
import com.pingidentity.sdk.internal.services.ServiceFactory;
import com.pingidentity.sdk.internal.services.interfaces.HashedPasswordService;
import java.io.Serializable;
import java.time.Instant;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.kerberos.KerberosKey;
import org.sourceid.saml20.domain.KerberosRealm;

public class KerberosKeySet
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Instant deactivatedAt;
    private final Set<KerberosKey> keys;
    private final String username;
    private final String realmName;
    private final String hashedPassword;

    public KerberosKeySet(Instant deactivatedAt, Set<KerberosKey> keys, String username, String realmName, String hashedPassword) {
        this.deactivatedAt = deactivatedAt;
        this.keys = keys;
        this.username = username;
        this.realmName = realmName;
        this.hashedPassword = hashedPassword;
    }

    public KerberosKeySet(KerberosRealm realm, Set<KerberosKey> keys) {
        this.username = realm.getKerberosUsername();
        this.realmName = realm.getKerberosRealmName();
        this.hashedPassword = ServiceFactory.getSingleImpl(HashedPasswordService.class, new ArgPair[0]).fromClearTextToEncodedText(realm.getKerberosPassword());
        this.keys = Collections.unmodifiableSet(new HashSet<KerberosKey>(keys));
        this.deactivatedAt = null;
    }

    public KerberosKeySet(KerberosKeySet copyFrom, Instant deactivatedAt) {
        this.username = copyFrom.getUsername();
        this.realmName = copyFrom.getRealmName();
        this.hashedPassword = copyFrom.getHashedPassword();
        this.keys = copyFrom.getKeys();
        this.deactivatedAt = deactivatedAt;
    }

    public String getUsername() {
        return this.username;
    }

    public String getRealmName() {
        return this.realmName;
    }

    public String getHashedPassword() {
        return this.hashedPassword;
    }

    public Instant getDeactivatedAt() {
        return this.deactivatedAt;
    }

    public Set<KerberosKey> getKeys() {
        return this.keys;
    }
}

