/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain;

import com.pingidentity.sdk.internal.services.ArgPair;
import com.pingidentity.sdk.internal.services.ServiceFactory;
import com.pingidentity.sdk.internal.services.interfaces.KerberosRealmAccessorService;
import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.sourceid.saml20.domain.KerberosConnectionType;
import org.sourceid.saml20.domain.KerberosKeySet;

public class KerberosRealm
implements Serializable {
    private static final long serialVersionUID = 20120121L;
    private String id;
    private String kerberosRealmName;
    private List<String> keyDistributionCenters;
    private String kerberosUsername;
    private String kerberosPassword;
    private boolean defaultRealm = false;
    private boolean suppressDomainNameConcatenation = false;
    private boolean retainPreviousKeysOnPasswordChange = false;
    private List<KerberosKeySet> keySets = new ArrayList<KerberosKeySet>();
    private KerberosConnectionType connectionType = KerberosConnectionType.DIRECT;
    private String ldapGatewayDatastoreId;
    private final transient KerberosRealmAccessorService kerberosRealmAccessorService;

    public KerberosRealm() {
        this.keyDistributionCenters = new ArrayList<String>();
        this.kerberosRealmAccessorService = ServiceFactory.getSingleImpl(KerberosRealmAccessorService.class, new ArgPair[0]);
    }

    public KerberosRealm(KerberosRealm source) {
        this.id = source.getId();
        this.kerberosRealmName = source.getKerberosRealmName();
        this.kerberosUsername = this.getKerberosUsername();
        this.kerberosPassword = source.getKerberosPassword();
        this.keyDistributionCenters = source.getKeyDistributionCenters();
        this.defaultRealm = source.isDefaultRealm();
        this.suppressDomainNameConcatenation = source.isSuppressDomainNameConcatenation();
        this.retainPreviousKeysOnPasswordChange = source.isRetainPreviousKeysOnPasswordChange();
        this.keySets = new ArrayList<KerberosKeySet>(source.getKeySets());
        this.connectionType = source.getConnectionType();
        this.ldapGatewayDatastoreId = source.getLdapGatewayDatastoreId();
        this.kerberosRealmAccessorService = ServiceFactory.getSingleImpl(KerberosRealmAccessorService.class, new ArgPair[0]);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getKerberosRealmName() {
        return this.kerberosRealmName;
    }

    public void setKerberosRealmName(String kerberosRealmName) {
        this.kerberosRealmName = kerberosRealmName;
    }

    public String getKeyDistributionCenter() {
        if (!this.keyDistributionCenters.isEmpty()) {
            return this.keyDistributionCenters.iterator().next();
        }
        return null;
    }

    public void setKeyDistributionCenter(String keyDistributionCenter) {
        this.keyDistributionCenters.clear();
        this.keyDistributionCenters.add(keyDistributionCenter);
    }

    public List<String> getKeyDistributionCenters() {
        return this.keyDistributionCenters;
    }

    public void setKeyDistributionCenters(List<String> keyDistributionCenters) {
        this.keyDistributionCenters = keyDistributionCenters;
    }

    public String getKerberosUsername() {
        return this.kerberosUsername;
    }

    public void setKerberosUsername(String kerberosUsername) {
        this.kerberosUsername = kerberosUsername;
    }

    public String getKerberosPassword() {
        return this.kerberosPassword;
    }

    public void setKerberosPassword(String kerberosPassword) {
        this.kerberosPassword = kerberosPassword;
    }

    public boolean isDefaultRealm() {
        return this.defaultRealm;
    }

    public void setDefaultRealm(boolean defaultRealm) {
        this.defaultRealm = defaultRealm;
    }

    public boolean isSuppressDomainNameConcatenation() {
        return this.suppressDomainNameConcatenation;
    }

    public void setSuppressDomainNameConcatenation(boolean suppressDomainNameConcatenation) {
        this.suppressDomainNameConcatenation = suppressDomainNameConcatenation;
    }

    public List<KerberosKeySet> getKeySets() {
        return Collections.unmodifiableList(this.keySets);
    }

    public List<KerberosKeySet> getValidKeySets(Instant now) {
        int keySetRetentionPeriodMins = this.kerberosRealmAccessorService.getKerberosRealmsSettings().getKeySetRetentionPeriodMins();
        return this.keySets.stream().filter(keySet -> keySet.getDeactivatedAt() == null || keySet.getDeactivatedAt().plus(Duration.ofMinutes(keySetRetentionPeriodMins)).isAfter(now)).collect(Collectors.toList());
    }

    public void setKeySets(List<KerberosKeySet> keySets) {
        if (keySets == null) {
            throw new IllegalArgumentException("keySets cannot be null");
        }
        this.keySets = new ArrayList<KerberosKeySet>(keySets);
    }

    public boolean isRetainPreviousKeysOnPasswordChange() {
        return this.retainPreviousKeysOnPasswordChange;
    }

    public void setRetainPreviousKeysOnPasswordChange(boolean retainPreviousKeysOnPasswordChange) {
        this.retainPreviousKeysOnPasswordChange = retainPreviousKeysOnPasswordChange;
    }

    public KerberosConnectionType getConnectionType() {
        return this.connectionType;
    }

    public void setConnectType(KerberosConnectionType connectionType) {
        this.connectionType = connectionType;
    }

    public String getLdapGatewayDatastoreId() {
        return this.ldapGatewayDatastoreId;
    }

    public void setLdapGatewayDatastoreId(String ldapGatewayDatastoreId) {
        this.ldapGatewayDatastoreId = ldapGatewayDatastoreId;
    }

    public boolean isDirectConnection() {
        return KerberosConnectionType.DIRECT.equals((Object)this.connectionType);
    }

    public boolean isLdapGatewayConnection() {
        return KerberosConnectionType.LDAP_GATEWAY.equals((Object)this.connectionType);
    }

    public boolean isLocalValidationConnection() {
        return KerberosConnectionType.LOCAL_VALIDATION.equals((Object)this.connectionType);
    }
}

