/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.datasource.info;

import com.pingidentity.sdk.internal.services.ArgPair;
import com.pingidentity.sdk.internal.services.ServiceFactory;
import com.pingidentity.sdk.internal.services.interfaces.DataSourceAccessorService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.saml20.domain.datasource.info.LdapTypeNotFoundException;
import org.sourceid.saml20.domain.datasource.tag.LdapInstanceIdentifier;
import org.sourceid.saml20.domain.datasource.tag.LdapTagConfig;

public class LdapInfo
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 20050515L;
    private static final String LDAP_PROTOCOL = "ldap://";
    private static final String LDAPS_PROTOCOL = "ldaps://";
    private String id;
    private String name;
    private String host;
    private String principal = null;
    private String credentials = null;
    private String clientTlsCertificate = null;
    private String authenticationMethod;
    private boolean useSSL = false;
    private boolean useDnsSrvRecords = false;
    private boolean useLdapReferral = false;
    private LdapType ldapType = LdapType.Generic;
    private String ldapTypeDesc = "";
    private List<LdapTagConfig> ldapTagConfigList = new LinkedList<LdapTagConfig>();
    private boolean useStartTLS = false;
    private static final Log log = LogFactory.getLog(LdapInfo.class);
    private boolean testOnBorrow;
    private boolean testOnReturn;
    private boolean createIfNecessary;
    private boolean retryFailedOperations = false;
    private int min;
    private int max;
    private int maxWait;
    private int timeBetweenEvictionRunsMillis;
    private int readTimeoutMillis;
    private int connTimeoutMillis;
    private boolean verifyHost;
    private int dnsTtlMillis;
    private String ldapDnsSrvPrefix;
    private String ldapsDnsSrvPrefix;
    private String pingOneConnection;
    private String pingOneEnvironment;
    private String pingOneGateway;
    private List<String> binaryAttributes = new ArrayList<String>();

    public LdapInfo() {
        this.setDefaultPoolOptions();
    }

    private void setDefaultPoolOptions() {
        ServiceFactory.getSingleImpl(DataSourceAccessorService.class, new ArgPair[0]).populateDefaultPoolOptions(this);
    }

    LdapInfo(String id, String host, String principal, String creds, String authMethod, boolean useSSL, boolean useDnsSrvRecords, boolean useAdReferral, boolean useStartTLS) {
        this.id = id;
        this.host = host;
        this.principal = principal;
        this.credentials = creds;
        this.authenticationMethod = authMethod;
        this.useSSL = useSSL;
        this.useDnsSrvRecords = useDnsSrvRecords;
        this.useLdapReferral = useAdReferral;
        this.useStartTLS = useStartTLS;
        this.setDefaultPoolOptions();
    }

    public String toString() {
        return "\nLDAP DATA SOURCE: \n\tID = " + this.getId() + "\n\thost = " + this.host + "\n\tuseSSL = " + this.useSSL + "\n\tuseDnsSrvRecords = " + this.useDnsSrvRecords + (String)(this.ldapType != LdapType.PingDirectory && this.ldapType != LdapType.PingDS ? "\n\tuseLdapReferral = " + this.useLdapReferral : "") + "\n\tprincipal = " + this.principal + "\n\tauthenticationMethod = " + this.authenticationMethod + "\n\tldapType = " + this.ldapType + "\n\tldapTypeDescription = " + this.getLdapTypeDesc() + "\n\tpingOneConnection = " + this.getPingOneConnection() + "\n\tpingOneEnvironment = " + this.getPingOneEnvironment() + "\n\tpingOneGateway = " + this.getPingOneGateway() + "\n\tuseStartTLS = " + this.useStartTLS;
    }

    public LdapInfo clone() {
        try {
            LdapInfo clone = (LdapInfo)super.clone();
            clone.ldapTagConfigList = new LinkedList<LdapTagConfig>();
            for (LdapTagConfig ldapTagConfig : this.ldapTagConfigList) {
                clone.ldapTagConfigList.add(ldapTagConfig.clone());
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            log.error((Object)e);
            return null;
        }
    }

    public String getServerUrl() {
        return this.getServerUrl(this.getHost());
    }

    public String getServerUrl(String hosts) {
        boolean useSSL = this.isUseSSL();
        boolean useDnsSrvRecords = this.isUseDnsSrvRecords();
        String dnsSrvRecordsPrefix = useSSL ? this.getLdapsDnsSrvPrefix() : this.getLdapDnsSrvPrefix();
        String uriPrefix = useSSL ? LDAPS_PROTOCOL : LDAP_PROTOCOL;
        Object protocol = useDnsSrvRecords ? dnsSrvRecordsPrefix + "." : uriPrefix;
        StringBuilder serverUrl = new StringBuilder(hosts.length() * 2);
        for (String host : hosts.split("[ \t]")) {
            if ((host = host.trim()).isEmpty()) {
                if (!useDnsSrvRecords) continue;
                serverUrl.append(dnsSrvRecordsPrefix).append(' ');
                continue;
            }
            serverUrl.append((String)protocol).append(host).append(' ');
        }
        return serverUrl.toString().trim();
    }

    public String getAuthenticationMethod() {
        return this.authenticationMethod;
    }

    public void setAuthenticationMethod(String authenticationMethod) {
        this.authenticationMethod = authenticationMethod;
    }

    public String getCredentials() {
        return this.credentials;
    }

    public void setCredentials(String credentials) {
        this.credentials = credentials;
    }

    public String getClientTlsCertificate() {
        return this.clientTlsCertificate;
    }

    public void setClientTlsCertificate(String clientTlsCertificate) {
        this.clientTlsCertificate = clientTlsCertificate;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getPrincipal() {
        return this.principal;
    }

    public void setPrincipal(String principal) {
        this.principal = principal;
    }

    public boolean isUseSSL() {
        return this.useSSL;
    }

    public void setUseSSL(boolean useSSL) {
        this.useSSL = useSSL;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public LdapType getLdapType() {
        return this.ldapType;
    }

    public void setLdapType(LdapType ldapType) {
        this.ldapType = ldapType;
    }

    public String getLdapTypeDesc() {
        return this.ldapTypeDesc;
    }

    public void setLdapTypeDesc(String ldapTypeDesc) {
        this.ldapTypeDesc = ldapTypeDesc;
    }

    public boolean isTestOnBorrow() {
        return this.testOnBorrow;
    }

    public void setTestOnBorrow(boolean testOnBorrow) {
        this.testOnBorrow = testOnBorrow;
    }

    public boolean isTestOnReturn() {
        return this.testOnReturn;
    }

    public void setTestOnReturn(boolean testOnReturn) {
        this.testOnReturn = testOnReturn;
    }

    public boolean isCreateIfNecessary() {
        return this.createIfNecessary;
    }

    public void setCreateIfNecessary(boolean createIfNecessary) {
        this.createIfNecessary = createIfNecessary;
    }

    public boolean isRetryFailedOperations() {
        return this.retryFailedOperations;
    }

    public void setRetryFailedOperations(boolean retryFailedOperations) {
        this.retryFailedOperations = retryFailedOperations;
    }

    public int getMin() {
        return this.min;
    }

    public void setMin(int min) {
        this.min = min;
    }

    public int getMax() {
        return this.max;
    }

    public void setMax(int max) {
        this.max = max;
    }

    public int getMaxWait() {
        return this.maxWait;
    }

    public void setMaxWait(int maxWait) {
        this.maxWait = maxWait;
    }

    public int getTimeBetweenEvictionRunsMillis() {
        return this.timeBetweenEvictionRunsMillis;
    }

    public void setTimeBetweenEvictionRunsMillis(int timeBetweenEvictionRunsMillis) {
        this.timeBetweenEvictionRunsMillis = timeBetweenEvictionRunsMillis;
    }

    public List<String> getBinaryAttributes() {
        return this.binaryAttributes;
    }

    public void setBinaryAttributes(List<String> binaryAttributes) {
        this.binaryAttributes = binaryAttributes;
    }

    public int getReadTimeoutMillis() {
        return this.readTimeoutMillis;
    }

    public void setReadTimeoutMillis(int readTimeoutMillis) {
        this.readTimeoutMillis = readTimeoutMillis;
    }

    public int getConnTimeoutMillis() {
        return this.connTimeoutMillis;
    }

    public void setConnTimeoutMillis(int connTimeoutMillis) {
        this.connTimeoutMillis = connTimeoutMillis;
    }

    public boolean isVerifyHost() {
        return this.verifyHost;
    }

    public void setVerifyHost(boolean verifyHost) {
        this.verifyHost = verifyHost;
    }

    public boolean isUseDnsSrvRecords() {
        return this.useDnsSrvRecords;
    }

    public void setUseDnsSrvRecords(boolean useDnsSrvRecords) {
        this.useDnsSrvRecords = useDnsSrvRecords;
    }

    public boolean isUseLdapReferral() {
        return this.useLdapReferral;
    }

    public void setUseLdapReferral(boolean useLdapReferral) {
        this.useLdapReferral = useLdapReferral;
    }

    public int getDnsTtlMillis() {
        return this.dnsTtlMillis;
    }

    public void setDnsTtlMillis(int dnsTtlMillis) {
        this.dnsTtlMillis = dnsTtlMillis;
    }

    public String getLdapDnsSrvPrefix() {
        return this.ldapDnsSrvPrefix;
    }

    public void setLdapDnsSrvPrefix(String ldapDnsSrvPrefix) {
        this.ldapDnsSrvPrefix = ldapDnsSrvPrefix;
    }

    public String getLdapsDnsSrvPrefix() {
        return this.ldapsDnsSrvPrefix;
    }

    public void setLdapsDnsSrvPrefix(String ldapsDnsSrvPrefix) {
        this.ldapsDnsSrvPrefix = ldapsDnsSrvPrefix;
    }

    public String getPingOneConnection() {
        return this.pingOneConnection;
    }

    public void setPingOneConnection(String pingOneConnection) {
        this.pingOneConnection = pingOneConnection;
    }

    public String getPingOneEnvironment() {
        return this.pingOneEnvironment;
    }

    public void setPingOneEnvironment(String pingOneEnvironment) {
        this.pingOneEnvironment = pingOneEnvironment;
    }

    public String getPingOneGateway() {
        return this.pingOneGateway;
    }

    public void setPingOneGateway(String pingOneGateway) {
        this.pingOneGateway = pingOneGateway;
    }

    public List<LdapTagConfig> getLdapTagConfigList() {
        return Collections.unmodifiableList(this.ldapTagConfigList);
    }

    public void setLdapTagConfigList(List<LdapTagConfig> ldapTagConfigList) {
        if (ldapTagConfigList == null) {
            ldapTagConfigList = new LinkedList<LdapTagConfig>();
        }
        this.ldapTagConfigList = ldapTagConfigList;
    }

    public List<LdapTag> getLdapTags() {
        return this.ldapTagConfigList.stream().map(x$0 -> new LdapTag((LdapTagConfig)x$0)).collect(Collectors.toList());
    }

    public void setLdapTags(List<LdapTag> ldapTags) {
        this.ldapTagConfigList = ldapTags.stream().map(ldapTag -> {
            LdapInstanceIdentifier identifier = new LdapInstanceIdentifier(ldapTag.getHostname());
            return new LdapTagConfig(identifier, ldapTag.getTags(), ldapTag.isDefaultSource());
        }).collect(Collectors.toList());
    }

    public boolean isUseStartTLS() {
        return this.useStartTLS;
    }

    public void setUseStartTLS(boolean useStartTLS) {
        this.useStartTLS = useStartTLS;
    }

    public static class LdapTag {
        private final String hostname;
        private final String tags;
        private final boolean defaultSource;

        public LdapTag(String hostname, String tags, boolean defaultSource) {
            this.hostname = hostname;
            this.tags = tags;
            this.defaultSource = defaultSource;
        }

        private LdapTag(LdapTagConfig ldapTagConfig) {
            this.hostname = ldapTagConfig.getIdentifier() != null ? ldapTagConfig.getIdentifier().getHostname() : "";
            this.tags = ldapTagConfig.getTags();
            this.defaultSource = ldapTagConfig.isDefaultSource();
        }

        public String getHostname() {
            return this.hostname;
        }

        public String getTags() {
            return this.tags;
        }

        public boolean isDefaultSource() {
            return this.defaultSource;
        }
    }

    public static enum LdapType {
        Undefined("Undefined"),
        Generic("Generic"),
        ActiveDirectory("Active Directory"),
        SunDirectoryServer("Sun Directory Server"),
        OracleUnifiedDirectory("Oracle Unified Directory"),
        UnboundID("UnboundID DS"),
        PingDirectory("PingDirectory"),
        PingDS("PingDS"),
        Custom("Custom");

        private final String description;

        private LdapType(String description) {
            this.description = description;
        }

        public static LdapType canonicalName(String name) throws LdapTypeNotFoundException {
            for (LdapType type : LdapType.values()) {
                if (!type.name().equalsIgnoreCase(name)) continue;
                return type;
            }
            throw new LdapTypeNotFoundException("No Enum found with the name '" + name + "'");
        }

        public String getDescription() {
            return this.description;
        }
    }
}

