/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.htmlform.idp;

import com.pingidentity.access.BaseUrlAccessor;
import com.pingidentity.access.CaptchaProviderAccessor;
import com.pingidentity.access.PasswordCredentialValidatorAccessor;
import com.pingidentity.adapter.support.LogoutHandler;
import com.pingidentity.adapters.htmlform.config.HtmlFormGuiConfiguration;
import com.pingidentity.adapters.htmlform.idp.AuthenticateFormHandler;
import com.pingidentity.adapters.htmlform.idp.HtmlFormIdpAuthnAdapterUtils;
import com.pingidentity.adapters.htmlform.idp.HtmlFormLoginContext;
import com.pingidentity.adapters.htmlform.idp.PasswordManagementAuthenticationContext;
import com.pingidentity.adapters.htmlform.idrecovery.common.RecoverUsernameSessionState;
import com.pingidentity.adapters.htmlform.idrecovery.servlet.RecoverUsernameServlet;
import com.pingidentity.adapters.htmlform.pwdchange.common.ChangePasswordSessionState;
import com.pingidentity.adapters.htmlform.pwdchange.servlet.IdentifyServlet;
import com.pingidentity.adapters.htmlform.pwdchange.servlet.SuccessServlet;
import com.pingidentity.adapters.htmlform.pwdmgmt.common.PasswordManagementSessionState;
import com.pingidentity.adapters.htmlform.pwdmgmt.servlet.AbstractPasswordManagementServlet;
import com.pingidentity.adapters.htmlform.pwdreset.common.PasswordResetSessionState;
import com.pingidentity.adapters.htmlform.pwdreset.servlet.AccountUnlockServlet;
import com.pingidentity.adapters.htmlform.pwdreset.servlet.ErrorServlet;
import com.pingidentity.adapters.htmlform.pwdreset.servlet.PingIDServlet;
import com.pingidentity.adapters.htmlform.pwdreset.servlet.PolicyServlet;
import com.pingidentity.adapters.htmlform.pwdreset.servlet.ResetServlet;
import com.pingidentity.adapters.htmlform.pwdreset.servlet.ResumeServlet;
import com.pingidentity.adapters.htmlform.pwdreset.servlet.SecurityCodeServlet;
import com.pingidentity.adapters.htmlform.render.ChallengeWithForm;
import com.pingidentity.adapters.htmlform.render.handler.api.HtmlFormAuthnApiHandler;
import com.pingidentity.adapters.htmlform.render.handler.api.passwordchange.PasswordChangeHandler;
import com.pingidentity.adapters.htmlform.render.handler.api.passwordreset.PasswordResetHandler;
import com.pingidentity.adapters.htmlform.session.HtmlFormSessionStateSupport;
import com.pingidentity.captcha.util.CaptchaProviderUtil;
import com.pingidentity.common.security.AccountLockingService;
import com.pingidentity.common.security.InputValidator;
import com.pingidentity.common.security.LockingService;
import com.pingidentity.common.security.UsernameRule;
import com.pingidentity.common.security.ValidationRule;
import com.pingidentity.common.util.Base64URL;
import com.pingidentity.common.util.CookieMonster;
import com.pingidentity.common.util.EOLUtil;
import com.pingidentity.common.util.PropertyInfo;
import com.pingidentity.localidentity.LocalIdentityProfile;
import com.pingidentity.sdk.AuthenticationSession;
import com.pingidentity.sdk.AuthnAdapterResponse;
import com.pingidentity.sdk.IdpAuthenticationAdapterV2;
import com.pingidentity.sdk.PluginFipsStatus;
import com.pingidentity.sdk.PostRegistrationSessionAwareAdapter;
import com.pingidentity.sdk.SessionAwareAuthenticationAdapter;
import com.pingidentity.sdk.TransactionAwareAuthenticationAdapter;
import com.pingidentity.sdk.api.authn.AuthnApiPlugin;
import com.pingidentity.sdk.api.authn.common.CommonActionSpec;
import com.pingidentity.sdk.api.authn.common.CommonErrorDetailSpec;
import com.pingidentity.sdk.api.authn.common.CommonErrorSpec;
import com.pingidentity.sdk.api.authn.common.CommonStateSpec;
import com.pingidentity.sdk.api.authn.model.AuthnError;
import com.pingidentity.sdk.api.authn.model.AuthnErrorDetail;
import com.pingidentity.sdk.api.authn.model.action.AuthenticationSourceSelection;
import com.pingidentity.sdk.api.authn.model.action.CheckChallengeResponse;
import com.pingidentity.sdk.api.authn.model.action.CheckUsernamePassword;
import com.pingidentity.sdk.api.authn.spec.AuthnStateSpec;
import com.pingidentity.sdk.api.authn.spec.PluginApiSpec;
import com.pingidentity.sdk.api.authn.util.AuthnApiSupport;
import com.pingidentity.sdk.api.authn.util.ParamMapping;
import com.pingidentity.sdk.captchaprovider.CaptchaContext;
import com.pingidentity.sdk.captchaprovider.CaptchaProvider;
import com.pingidentity.sdk.captchaprovider.CaptchaResult;
import com.pingidentity.sdk.password.PasswordCredentialChallengeException;
import com.pingidentity.sdk.password.PasswordCredentialValidator;
import com.pingidentity.sdk.password.PasswordValidationException;
import com.pingidentity.sdk.password.RecoverableUsername;
import com.pingidentity.sdk.template.TemplateRendererUtil;
import com.pingidentity.templates.mgmt.TemplateParamUtil;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.common.Util;
import org.sourceid.common.VersionUtil;
import org.sourceid.saml20.adapter.ConfigurableAuthnAdapter;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.adapter.conf.Field;
import org.sourceid.saml20.adapter.conf.Row;
import org.sourceid.saml20.adapter.idp.authn.AuthnPolicy;
import org.sourceid.saml20.adapter.idp.authn.IdpAuthenticationAdapter;
import org.sourceid.saml20.adapter.idp.authn.IdpAuthnAdapterDescriptor;
import org.sourceid.saml20.adapter.state.SessionStateSupport;
import org.sourceid.saml20.adapter.state.TransactionalStateSupport;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.validation.CommonValidator;
import org.sourceid.saml20.profiles.AdapterPathSupport;
import org.sourceid.saml20.profiles.ProfileProcessFactory;
import org.sourceid.util.log.AttributeMap;
import org.sourceid.websso.profiles.ResumeRequestFromAuthnResponseHandler;
import org.sourceid.websso.profiles.idp.IdpAuditLogger;
import org.sourceid.websso.servlet.adapter.Handler;
import org.sourceid.websso.servlet.adapter.HandlerRegistry;

public class HtmlFormIdpAuthnAdapter
implements IdpAuthenticationAdapterV2,
SessionAwareAuthenticationAdapter,
AuthnApiPlugin,
PostRegistrationSessionAwareAdapter,
TransactionAwareAuthenticationAdapter {
    private static final Log log = LogFactory.getLog(HtmlFormIdpAuthnAdapter.class);
    private static final String ADAPTER_NAME = "HTML Form IdP Adapter";
    private final HtmlFormSessionStateSupport sessionStateSupport = new HtmlFormSessionStateSupport();
    private final HtmlFormGuiConfiguration httpFormGuiConfiguration = new HtmlFormGuiConfiguration();
    private LockingService accountLockingService;
    private Configuration config;
    private int maxConsecutiveFailures;
    private final List<String> pwdCrdVal = new ArrayList<String>();
    private Integer sessionTimeout = null;
    private Integer sessionMaxTimeout = null;
    private String loginTemplateName = null;
    private String sessionState = null;
    private String loginChallengeTemplateName = null;
    private boolean adminAllowsPasswordChanges = false;
    private boolean enableRememberUsername = false;
    private int rememberUsernameCookieLifetime = Integer.parseInt("30");
    private int myDeviceCookieLifetimeDays = Integer.parseInt("30");
    private boolean enableMyDevice = false;
    private String pwmLocation = null;
    private String pwmTemplateName = null;
    private boolean allowUsernameEdits = false;
    private boolean trackAuthenticationTime;
    private boolean enablePasswordExpiryNotification = false;
    private String passwordExpiryTemplateName = null;
    private Long expiringPasswordWarningThreshold = 604800000L;
    private int expiringPasswordSnoozeInterval = 86400;
    private String resetType = null;
    public static final String USERNAME_FIELD = "pf.username";
    private static final String ADAPTER_ID_FIELD = "pf.adapterId";
    private static final String PASS = "pf.pass";
    private static final String CHANGE_PASSWORD = "ChangePassword";
    static final String CHALLENGE_RESPONSE = "pf.challengeResponse";
    static final String OK = "pf.ok";
    static final String CANCEL = "pf.cancel";
    private static final String REMEMBER_USERNAME = "pf.rememberUsername";
    private static final String MY_DEVICE = "pf.myDevice";
    public static final String PASSWORD_RESET_FIELD = "pf.passwordreset";
    private static final String USERNAME_RECOVERY_FIELD = "pf.usernamerecovery";
    private static final String PCV_ID_FIELD = "pf.pcvId";
    private static final String PASSWORD_EXPIRING = "pf.passwordExpiring";
    static final String SESSION_KEY_RADIUS_STATE = "radius-state";
    static final String SESSION_KEY_RADIUS_USERNAME = "radius-username";
    static final String SESSION_KEY_RADIUS_REPLY_MESSAGE = "radius-reply-message";
    static final String SESSION_KEY_RADIUS_CHALLENGE_IN_PROGRESS = "radius-challenge-in-progress";
    private static final String ALTERNATE_AUTHN_SYSTEM = "pf.alternateAuthnSystem";
    private static final String REGISTRATION = "pf.registration";
    private static final ParamMapping<CheckUsernamePassword, String> USERNAME_MAPPING = new ParamMapping("pf.username", CheckUsernamePassword.class, CheckUsernamePassword::getUsername, Function.identity());
    private static final ParamMapping<CheckUsernamePassword, String> PASSWORD_MAPPING = new ParamMapping("pf.pass", CheckUsernamePassword.class, CheckUsernamePassword::getPassword, Function.identity());
    private static final ParamMapping<CheckUsernamePassword, Boolean> REMEMBER_USERNAME_MAPPING = new ParamMapping("pf.rememberUsername", CheckUsernamePassword.class, CheckUsernamePassword::getRememberMyUsername, "on"::equalsIgnoreCase);
    private static final ParamMapping<CheckUsernamePassword, Boolean> REMEMBER_DEVICE_MAPPING = new ParamMapping("pf.myDevice", CheckUsernamePassword.class, CheckUsernamePassword::getThisIsMyDevice, "on"::equalsIgnoreCase);
    private static final ParamMapping<AuthenticationSourceSelection, String> ALTERNATE_AUTHN_SOURCE_MAPPING = new ParamMapping("pf.alternateAuthnSystem", AuthenticationSourceSelection.class, AuthenticationSourceSelection::getAuthenticationSource, Function.identity());
    private static final ParamMapping<CheckChallengeResponse, String> CHALLENGE_RESPONSE_MAPPING = new ParamMapping("pf.challengeResponse", CheckChallengeResponse.class, CheckChallengeResponse::getChallengeResponse, Function.identity());
    private String SESSION_KEY_AUTHN;
    private String SESSION_KEY_USERNAME;
    private String SESSION_KEY_FIRST_ACTIVITY;
    private String SESSION_KEY_LAST_ACTIVITY;
    private String SESSION_KEY_LOGIN_CONTEXT = null;
    public static final String ERROR_CHALLENGE_RESPONSE_BLANK = "challengeResponseBlankError";
    private String cookieName;
    private String myDeviceCookieName;
    static final String COOKIE_NAME_PREFIX = "pf-hfa-";
    static final String COOKIE_NAME_SUFFIX = "-rmu";
    static final String MY_DEVICE_COOKIE_NAME_SUFFIX = "-mcpt";
    public static final String EXPIRING_PASSWORD_COOKIE_NAME = "pf-hfa-exp-pwd";
    private static final String ENCODING_PREFIX = "B64:";
    private String localIdentityProfileId;
    private boolean failAuthenticationOnAccountLockout = false;
    private boolean requireReAuthenticationAfterChangePassword;
    private boolean requireReAuthenticationAfterPasswordReset;
    private Integer passwordUpdateTimeoutInMins;

    public Map lookupAuthN(HttpServletRequest req, HttpServletResponse resp, String entityId, AuthnPolicy authnPolicy, String resumeUrl) {
        throw new UnsupportedOperationException();
    }

    private boolean isAuthnApiPasswordResetInitiated(HttpServletRequest request) {
        return AuthnApiSupport.getDefault().isApiRequest(request) && CommonActionSpec.INITIATE_ACCOUNT_RECOVERY.isRequested(request);
    }

    private boolean isAuthnApiUsernameRecoveryInitiated(HttpServletRequest request) {
        return AuthnApiSupport.getDefault().isApiRequest(request) && CommonActionSpec.RECOVER_USERNAME.isRequested(request);
    }

    private boolean isUsernamePasswordSubmitted(HttpServletRequest request, String username, String password) {
        return !AuthnApiSupport.getDefault().isApiRequest(request) && username != null && password != null || AuthnApiSupport.getDefault().isApiRequest(request) && CommonActionSpec.CHECK_USERNAME_PASSWORD.isRequested(request);
    }

    private HtmlFormLoginContext handleLoginForm(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, AuthnPolicy authnPolicy, String resumeUrl, HtmlFormLoginContext loginContext, String username, boolean isChainedUsernameAvailable, PasswordManagementAuthenticationContext passwordManagementContext) throws IOException {
        boolean challengeResponsePosted;
        String password = (String)PASSWORD_MAPPING.getValue(req);
        if ("GET".equals(req.getMethod()) && StringUtils.isNotBlank((String)password)) {
            String tid = (String)inParameters.get("com.pingidentity.adapter.input.parameter.tracking.id");
            log.warn((Object)("Password received for " + tid + " in GET request. Passwords should not be sent in GET requests."));
        }
        String challengeResponse = (String)CHALLENGE_RESPONSE_MAPPING.getValue(req);
        String hiddenAdapterId = req.getParameter(ADAPTER_ID_FIELD);
        if (hiddenAdapterId != null && !hiddenAdapterId.equals(inParameters.get("com.pingidentity.adapter.input.parameter.instanceid"))) {
            password = null;
        }
        boolean bl = challengeResponsePosted = challengeResponse != null;
        if (this.isUsernamePasswordSubmitted(req, username, password) || this.isAuthnApiPasswordResetInitiated(req) || this.isAuthnApiUsernameRecoveryInitiated(req) || this.isAlternativeAuthenticationSystemSelected(req) || this.isRegistrationSelected(req) || passwordManagementContext != null && passwordManagementContext.isSuccess()) {
            loginContext = this.doLoginFormPosted(req, resp, inParameters, authnPolicy, resumeUrl, loginContext, username, password, isChainedUsernameAvailable, passwordManagementContext);
        } else if (this.isPasswordChange(req)) {
            HtmlFormIdpAuthnAdapter.promptForPasswordChange(req, resp, inParameters, authnPolicy, this.config.getId(), resumeUrl, null, isChainedUsernameAvailable, username, this.pwmLocation, this.pwmTemplateName, this.adminAllowsPasswordChanges, this.SESSION_KEY_LOGIN_CONTEXT);
        } else if (challengeResponsePosted || this.isCancelChallengeResponse(req)) {
            loginContext = this.doChallengeRespPosted(req, resp, inParameters, authnPolicy, resumeUrl, challengeResponse, isChainedUsernameAvailable);
        } else {
            this.doLoginFormRequested(req, resp, inParameters, authnPolicy, resumeUrl, loginContext, username, isChainedUsernameAvailable);
        }
        return loginContext;
    }

    private boolean isPasswordChange(HttpServletRequest request) {
        return AuthnApiSupport.getDefault().isApiRequest(request) && CommonActionSpec.INITIATE_PASSWORD_CHANGE.getId().equals(AuthnApiSupport.getDefault().getActionId(request)) || "true".equalsIgnoreCase(request.getParameter(CHANGE_PASSWORD));
    }

    private boolean isCancelChallengeResponse(HttpServletRequest request) {
        return AuthnApiSupport.getDefault().isApiRequest(request) && CommonActionSpec.CANCEL_AUTHENTICATION.getId().equals(AuthnApiSupport.getDefault().getActionId(request)) || "clicked".equalsIgnoreCase(request.getParameter(CANCEL));
    }

    public boolean checkUseAuthenticationSession(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, AuthenticationSession existingSession) {
        boolean registrationRequested;
        boolean requestedActionInParam;
        boolean bl = requestedActionInParam = this.getRequestedActionFromInParams(inParameters) != null;
        if (requestedActionInParam && log.isDebugEnabled()) {
            log.debug((Object)"Ignoring existing authentication session as policy.action was found in inParameters");
        }
        if ((registrationRequested = this.isRegistrationRequested(inParameters)) && log.isDebugEnabled()) {
            log.debug((Object)("Ignoring existing authentication session as com.pingidentity.adapter.input.parameter.authn.policy was found in inParameters with registrationRequested=true and registration is enabled for local identity profile with id '" + this.localIdentityProfileId + "'."));
        }
        return !requestedActionInParam && !registrationRequested;
    }

    private void doLoginFormRequested(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, AuthnPolicy authnPolicy, String resumeUrl, HtmlFormLoginContext loginContext, String username, boolean isChainedUsernameAvailable) throws IOException {
        if (this.isSessionTracking()) {
            boolean isSessionExpired = this.sessionStateSupport.isSessionExpired(this.SESSION_KEY_LAST_ACTIVITY, this.sessionTimeout, req, resp);
            boolean isSessionMaxExpired = this.isSessionMaxExpired(req, resp);
            if (isSessionExpired || isSessionMaxExpired) {
                this.sessionStateSupport.removeAttribute(this.SESSION_KEY_USERNAME, req, resp);
                this.sessionStateSupport.removeAttribute(this.SESSION_KEY_AUTHN, req, resp);
                loginContext.setAuthnIds(null);
            } else {
                Object storedUsernameObj;
                boolean reuseSession;
                boolean bl = reuseSession = username == null;
                if (!reuseSession && (storedUsernameObj = this.sessionStateSupport.getAttribute(this.SESSION_KEY_USERNAME, req, resp)) instanceof String) {
                    String storedUsername = (String)storedUsernameObj;
                    reuseSession = storedUsername.equals(username);
                }
                if (reuseSession) {
                    loginContext.setAuthnIds((Map)this.sessionStateSupport.getAttribute(this.SESSION_KEY_AUTHN, req, resp));
                }
            }
        }
        this.handleExpiringPasswordWarningCancel(req, resp, resumeUrl, loginContext);
        if (Util.isEmpty((Map)loginContext.getAuthnIds()) || authnPolicy.reauthenticate()) {
            boolean enableCookie = this.enableRememberChainedUsername(isChainedUsernameAvailable);
            if (enableCookie) {
                String cookieValue = CookieMonster.getCookieValue((String)this.cookieName, (HttpServletRequest)req);
                if (!this.enableRememberUsername && StringUtils.isNotBlank((String)cookieValue)) {
                    HtmlFormIdpAuthnAdapterUtils.addCookie(this.cookieName, "", 0, resp);
                } else if (StringUtils.isNotBlank((String)cookieValue)) {
                    username = HtmlFormIdpAuthnAdapter.decodeCookieValue(cookieValue);
                }
            }
            this.challengeWithForm(req, resp, inParameters, authnPolicy, resumeUrl, username, false, null, null, isChainedUsernameAvailable);
        } else if (this.isSessionTracking()) {
            this.sessionStateSupport.refreshSession(this.SESSION_KEY_LAST_ACTIVITY, req, resp);
        }
    }

    private boolean hasValidPcvId(HttpServletRequest request) {
        String pcvId = this.getPcvIdFromRequest(request);
        return pcvId != null && CommonValidator.isValidAdapterInstanceId((String)pcvId);
    }

    private String getPcvIdFromRequest(HttpServletRequest request) {
        String pcvId = request.getParameter(PCV_ID_FIELD);
        if (AuthnApiSupport.getDefault().isApiRequest(request)) {
            pcvId = PasswordChangeHandler.getExpiringUserPCVID(request);
        }
        return pcvId;
    }

    private void handleExpiringPasswordWarningCancel(HttpServletRequest req, HttpServletResponse resp, String resumeUrl, HtmlFormLoginContext loginContext) {
        String pcvId = null;
        HtmlFormLoginContext notificationLoginContext = null;
        if (Util.isEmpty((Map)loginContext.getAuthnIds())) {
            TransactionalStateSupport transactionalStateSupport = new TransactionalStateSupport(resumeUrl);
            notificationLoginContext = (HtmlFormLoginContext)transactionalStateSupport.getAttribute(this.SESSION_KEY_LOGIN_CONTEXT, req, resp);
            if (notificationLoginContext != null) {
                pcvId = notificationLoginContext.getPcvId();
            }
        } else if (this.hasValidPcvId(req)) {
            notificationLoginContext = loginContext;
            pcvId = EOLUtil.stripEOLs((String)this.getPcvIdFromRequest(req));
        }
        if (notificationLoginContext != null && !Util.isEmpty((Map)notificationLoginContext.getAuthnIds())) {
            String pendingPwdCookieValue;
            Object authenticatedUser = notificationLoginContext.getAuthnIds().get("username");
            if (authenticatedUser != null && HtmlFormIdpAuthnAdapter.isResetPendingPassword(req, authenticatedUser.toString()) && StringUtils.isNotBlank((String)(pendingPwdCookieValue = HtmlFormIdpAuthnAdapter.getPendingPwdCookieValue(pcvId, authenticatedUser.toString()))) && this.expiringPasswordSnoozeInterval > 0) {
                HtmlFormIdpAuthnAdapterUtils.addCookie(EXPIRING_PASSWORD_COOKIE_NAME, pendingPwdCookieValue, this.expiringPasswordSnoozeInterval, resp);
            }
            if (notificationLoginContext.isPasswordExpiring()) {
                loginContext.setAuthnIds(notificationLoginContext.getAuthnIds());
                if (this.isSessionTracking()) {
                    this.sessionStateSupport.setAttribute(this.SESSION_KEY_AUTHN, notificationLoginContext.getAuthnIds(), req, resp, true);
                    this.sessionStateSupport.setAttribute(this.SESSION_KEY_USERNAME, authenticatedUser, req, resp, false);
                    this.sessionStateSupport.refreshSession(this.SESSION_KEY_LAST_ACTIVITY, req, resp);
                    this.sessionStateSupport.refreshSession(this.SESSION_KEY_FIRST_ACTIVITY, req, resp);
                }
            }
        }
    }

    private static boolean isResetPendingPassword(HttpServletRequest req, String username) {
        boolean isPasswordExpiring = !AuthnApiSupport.getDefault().isApiRequest(req) ? StringUtils.isNotBlank((String)req.getParameter(PASSWORD_EXPIRING)) && Boolean.TRUE.toString().equals(req.getParameter(PASSWORD_EXPIRING)) : CommonActionSpec.CONTINUE_AUTHENTICATION.getId().equals(AuthnApiSupport.getDefault().getActionId(req)) && username != null && username.equals(PasswordChangeHandler.getExpiringUsername(req));
        return isPasswordExpiring;
    }

    private HtmlFormLoginContext doChallengeRespPosted(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, AuthnPolicy authnPolicy, String resumeUrl, String challengeResponse, boolean isChainedUsernameAvailable) throws IOException {
        HtmlFormLoginContext loginContext = new HtmlFormLoginContext();
        TransactionalStateSupport transactionalStateSupport = new TransactionalStateSupport(resumeUrl);
        String username = (String)transactionalStateSupport.removeAttribute(SESSION_KEY_RADIUS_USERNAME, req, resp);
        Object state = transactionalStateSupport.removeAttribute(SESSION_KEY_RADIUS_STATE, req, resp);
        if (!this.isCancelChallengeResponse(req)) {
            boolean showMyDeviceCheckbox = HtmlFormIdpAuthnAdapterUtils.showMyDeviceCheckbox(this.enableMyDevice, inParameters);
            AuthenticateFormHandler authenticateFormHandler = new AuthenticateFormHandler(this.SESSION_KEY_LOGIN_CONTEXT, this.pwdCrdVal, this.trackAuthenticationTime, this.maxConsecutiveFailures, this.accountLockingService, this.adminAllowsPasswordChanges, this.pwmLocation, this.enablePasswordExpiryNotification, this.config.getId(), this.localIdentityProfileId, this.loginTemplateName, this.passwordExpiryTemplateName, this.cookieName, this.myDeviceCookieName, this.enableRememberUsername, this.resetType, this.enableRememberUsername, showMyDeviceCheckbox, this.allowUsernameEdits, this.rememberUsernameCookieLifetime, this.expiringPasswordWarningThreshold, this.loginChallengeTemplateName, this.pwmTemplateName, this.isCaptchaEnabledAuthentication(this.config), this.getCaptchaProviderId(this.config));
            loginContext = authenticateFormHandler.authenticateForm(req, resp, inParameters, authnPolicy, username, challengeResponse, resumeUrl, null, transactionalStateSupport, true, state, isChainedUsernameAvailable, false, false, null);
            if (loginContext.isSuccess()) {
                this.accountLockingService.clearFailedLogins(AccountLockingService.getUserKey((String)req.getRemoteAddr(), (String)username));
                if (this.isSessionTracking() && !Util.isEmpty((Map)loginContext.getAuthnIds())) {
                    this.sessionStateSupport.setAttribute(this.SESSION_KEY_AUTHN, loginContext.getAuthnIds(), req, resp, true);
                    this.sessionStateSupport.setAttribute(this.SESSION_KEY_USERNAME, username, req, resp, false);
                    this.sessionStateSupport.refreshSession(this.SESSION_KEY_LAST_ACTIVITY, req, resp);
                    this.sessionStateSupport.refreshSession(this.SESSION_KEY_FIRST_ACTIVITY, req, resp);
                }
            }
        }
        return loginContext;
    }

    static String getPendingPwdCookieValue(String pcvId, String username) {
        if (pcvId != null && username != null) {
            return pcvId + "-" + username;
        }
        return "";
    }

    private boolean isAlternativeAuthenticationSystemSelected(HttpServletRequest request) {
        return StringUtils.isNotBlank((String)request.getParameter(ALTERNATE_AUTHN_SYSTEM)) || AuthnApiSupport.getDefault().isApiRequest(request) && CommonActionSpec.ALTERNATIVE_AUTHENTICATION.isRequested(request);
    }

    private boolean isRegistrationSelected(HttpServletRequest req) {
        return Boolean.parseBoolean(req.getParameter(REGISTRATION)) || AuthnApiSupport.getDefault().isApiRequest(req) && CommonActionSpec.INITIATE_REGISTRATION.isRequested(req);
    }

    private HtmlFormLoginContext doLoginFormPosted(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, AuthnPolicy authnPolicy, String resumeUrl, HtmlFormLoginContext loginContext, String username, String password, boolean isChainedUsernameAvailable, PasswordManagementAuthenticationContext passwordManagementContext) throws IOException {
        if (StringUtils.isNotBlank((String)req.getParameter(CANCEL))) {
            TransactionalStateSupport transactionalStateSupport = new TransactionalStateSupport(resumeUrl);
            transactionalStateSupport.removeAttribute(this.SESSION_KEY_LOGIN_CONTEXT, req, resp);
            loginContext.setAuthnIds(null);
        } else if (this.isAlternativeAuthenticationSystemSelected(req)) {
            TransactionalStateSupport transactionalStateSupport = new TransactionalStateSupport(resumeUrl);
            transactionalStateSupport.removeAttribute(this.SESSION_KEY_LOGIN_CONTEXT, req, resp);
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            attributes.put("policy.action", ALTERNATE_AUTHN_SOURCE_MAPPING.getValue(req));
            loginContext.setAuthnIds(attributes);
            loginContext.setUserName(null);
            loginContext.setAlternateAuthnSystem(true);
        } else if (this.isRegistrationSelected(req)) {
            TransactionalStateSupport transactionalStateSupport = new TransactionalStateSupport(resumeUrl);
            transactionalStateSupport.removeAttribute(this.SESSION_KEY_LOGIN_CONTEXT, req, resp);
            HashMap<String, String> attributes = new HashMap<String, String>();
            attributes.put("policy.action", "identity.registration");
            loginContext.setAuthnIds(attributes);
            loginContext.setUserName(null);
            loginContext.setAlternateAuthnSystem(true);
        } else if (this.isPasswordReset(req)) {
            PasswordResetSessionState sessionState = PasswordResetSessionState.create(req, resp);
            sessionState.setDefaultTemplateParams(TemplateParamUtil.populateDefaultTemplateParams(inParameters));
            sessionState.setFromHtmlFormAdapter(true);
            if ("POLICY".equals(this.resetType)) {
                Map trackedParams = (Map)inParameters.get("com.pingidentity.adapter.tracked.http.request.params");
                sessionState.setTrackedHttpParams(trackedParams);
            }
            sessionState.setAdapterId(this.config.getId());
            sessionState.setUsername(username);
            sessionState.setTargetResource(HtmlFormIdpAuthnAdapter.getResumeUrlWithBase(resumeUrl));
            sessionState.setResumeUrl(resumeUrl);
            sessionState.setPartnerId(HtmlFormIdpAuthnAdapter.getPartnerId(inParameters));
            Boolean rememberUsername = (Boolean)REMEMBER_USERNAME_MAPPING.getValue(req);
            if (rememberUsername != null) {
                sessionState.setRememberUsername(rememberUsername);
            }
            if (AuthnApiSupport.getDefault().isApiRequest(req)) {
                PasswordResetHandler.reissueRequestToPasswordResetIdentifyServlet(req, resp);
            } else {
                String forgotPasswordUrl = HtmlFormIdpAuthnAdapter.getForgetPasswordUrl(req, resp);
                resp.sendRedirect(forgotPasswordUrl);
            }
        } else if (this.isUsernameRecovery(req)) {
            RecoverUsernameSessionState sessionState = RecoverUsernameSessionState.create(req, resp);
            sessionState.setDefaultTemplateParams(TemplateParamUtil.populateDefaultTemplateParams(inParameters));
            sessionState.setFromHtmlFormAdapter(true);
            sessionState.setAdapterId(this.config.getId());
            sessionState.setTargetResource(HtmlFormIdpAuthnAdapter.getResumeUrlWithBase(resumeUrl));
            if (AuthnApiSupport.getDefault().isApiRequest(req)) {
                PasswordResetHandler.reissueRequestToUsernameRecoveryServlet(req, resp);
            } else {
                String usernameRecoveryUrl = HtmlFormIdpAuthnAdapter.getRecoverUsernameUrl(req, resp);
                resp.sendRedirect(usernameRecoveryUrl);
            }
        } else {
            AttributeMap captchaResponseAttributes = null;
            try {
                if (this.isCaptchaEnabledAuthentication(this.config)) {
                    CaptchaContext context;
                    if (AuthnApiSupport.getDefault().isApiRequest(req) && HtmlFormAuthnApiHandler.isMissingAuthnApiCaptchaResponse(req)) {
                        HtmlFormAuthnApiHandler.sendCaptchaResponseMissingResponse(req, resp);
                        return loginContext;
                    }
                    CaptchaProvider captchaProvider = CaptchaProviderAccessor.getCaptchaProvider((String)this.getCaptchaProviderId(this.config));
                    CaptchaResult captchaResult = captchaProvider.validateCaptcha(context = new CaptchaContext.Builder().setRequest(req).setResponse(resp).setAction("login").setInParameters(CaptchaProviderUtil.filterInParameters(inParameters, (String)username)).build());
                    boolean isValid = captchaResult.isValid();
                    if (!isValid) {
                        log.debug((Object)"Login failed: reCAPTCHA validation failure.");
                        TransactionalStateSupport transactionalStateSupport = new TransactionalStateSupport(resumeUrl);
                        transactionalStateSupport.removeAttribute(this.SESSION_KEY_LOGIN_CONTEXT, req, resp);
                        loginContext.setAuthnIds(null);
                        return loginContext;
                    }
                    captchaResponseAttributes = captchaResult.getResponseAttributes();
                }
            }
            catch (IOException e) {
                TransactionalStateSupport transactionalStateSupport = new TransactionalStateSupport(resumeUrl);
                transactionalStateSupport.removeAttribute(this.SESSION_KEY_LOGIN_CONTEXT, req, resp);
                loginContext.setAuthnIds(null);
                return loginContext;
            }
            InputValidator.validate((String)USERNAME_FIELD, (String)username, (ValidationRule[])new ValidationRule[]{new UsernameRule()});
            String passwordLockingKey = AccountLockingService.buildPasswordLockingKey((String)password);
            String userKey = AccountLockingService.getUserKey((String)req.getRemoteAddr(), (String)username);
            LockingService.IsLockedRequest usernameRequest = new LockingService.IsLockedRequest.Builder(userKey).loginType(LockingService.FailedLoginType.USERNAME).maxFailedLogins(this.maxConsecutiveFailures).lockoutPeriod(AccountLockingService.getLockoutPeriod()).build();
            LockingService.IsLockedRequest passwordRequest = new LockingService.IsLockedRequest.Builder(passwordLockingKey).loginType(LockingService.FailedLoginType.PASSWORD).build();
            boolean usernameLocked = this.accountLockingService.isLocked(usernameRequest);
            boolean passwordLocked = this.accountLockingService.isLocked(passwordRequest);
            if (!usernameLocked && !passwordLocked) {
                boolean showMyDeviceCheckbox = HtmlFormIdpAuthnAdapterUtils.showMyDeviceCheckbox(this.enableMyDevice, inParameters);
                HtmlFormIdpAuthnAdapterUtils.updateMyDeviceCookieValue(req, resp, this.enableMyDevice, showMyDeviceCheckbox, (Boolean)REMEMBER_DEVICE_MAPPING.getValue(req), this.myDeviceCookieName, this.myDeviceCookieLifetimeDays);
                TransactionalStateSupport transactionalStateSupport = new TransactionalStateSupport(resumeUrl);
                AuthenticateFormHandler authenticateFormHandler = new AuthenticateFormHandler(this.SESSION_KEY_LOGIN_CONTEXT, this.pwdCrdVal, this.trackAuthenticationTime, this.maxConsecutiveFailures, this.accountLockingService, this.adminAllowsPasswordChanges, this.pwmLocation, this.enablePasswordExpiryNotification, this.config.getId(), this.localIdentityProfileId, this.loginTemplateName, this.passwordExpiryTemplateName, this.cookieName, this.myDeviceCookieName, this.enableRememberUsername, this.resetType, this.enableRememberUsername, showMyDeviceCheckbox, this.allowUsernameEdits, this.rememberUsernameCookieLifetime, this.expiringPasswordWarningThreshold, this.loginChallengeTemplateName, this.pwmTemplateName, this.isCaptchaEnabledAuthentication(this.config), this.getCaptchaProviderId(this.config));
                loginContext = authenticateFormHandler.authenticateForm(req, resp, inParameters, authnPolicy, username, password, resumeUrl, null, transactionalStateSupport, true, null, isChainedUsernameAvailable, true, false, passwordManagementContext);
                if (Util.isEmpty((Map)loginContext.getAuthnIds())) {
                    if (!(loginContext.getException() instanceof PasswordCredentialChallengeException)) {
                        this.accountLockingService.logFailedLogin(userKey);
                        this.accountLockingService.logFailedPassword(passwordLockingKey);
                    }
                    usernameLocked = this.accountLockingService.isLocked(usernameRequest);
                    passwordLocked = this.accountLockingService.isLocked(passwordRequest);
                    if (loginContext.isError() && !loginContext.isRecoverable() && !usernameLocked && !passwordLocked) {
                        this.challengeWithForm(req, resp, inParameters, authnPolicy, resumeUrl, username, true, loginContext.getMessageKey(), loginContext.getRadiusServerError(), isChainedUsernameAvailable);
                    }
                } else {
                    this.accountLockingService.clearFailedLogins(userKey);
                    if (!Util.isEmpty((Map)captchaResponseAttributes)) {
                        loginContext.getAuthnIds().putAll(captchaResponseAttributes);
                    }
                    if (this.isSessionTracking()) {
                        this.sessionStateSupport.setAttribute(this.SESSION_KEY_AUTHN, loginContext.getAuthnIds(), req, resp, true);
                        this.sessionStateSupport.setAttribute(this.SESSION_KEY_USERNAME, username, req, resp, false);
                        this.sessionStateSupport.refreshSession(this.SESSION_KEY_LAST_ACTIVITY, req, resp);
                        this.sessionStateSupport.refreshSession(this.SESSION_KEY_FIRST_ACTIVITY, req, resp);
                    }
                    HtmlFormIdpAuthnAdapter.updateUserNameCookie(req, resp, username, isChainedUsernameAvailable, this.allowUsernameEdits, this.rememberUsernameCookieLifetime, this.cookieName);
                }
            }
            if (usernameLocked) {
                this.logLockedEvent(String.format("[source:%s] %s", "AccountLockingService", "Account Locked"));
                if (!this.failAuthenticationOnAccountLockout) {
                    this.challengeWithForm(req, resp, inParameters, authnPolicy, resumeUrl, username, true, "authn.srvr.msg.not.permitted.to.logon.at.this.time", loginContext.getRadiusServerError(), isChainedUsernameAvailable);
                }
            } else if (passwordLocked) {
                this.logLockedEvent(String.format("[source:%s] %s", "AccountLockingService", "Password Locked"));
            }
        }
        return loginContext;
    }

    private boolean isPasswordReset(HttpServletRequest request) {
        return this.isAuthnApiPasswordResetInitiated(request) || !AuthnApiSupport.getDefault().isApiRequest(request) && StringUtils.isNotBlank((String)request.getParameter(PASSWORD_RESET_FIELD));
    }

    private boolean isUsernameRecovery(HttpServletRequest request) {
        return this.isAuthnApiUsernameRecoveryInitiated(request) || !AuthnApiSupport.getDefault().isApiRequest(request) && StringUtils.isNotBlank((String)request.getParameter(USERNAME_RECOVERY_FIELD));
    }

    private void logLockedEvent(String s) {
        IdpAuditLogger.init();
        IdpAuditLogger.setStatus((String)"failure");
        IdpAuditLogger.setDescription((String)s);
        log.error((Object)s);
    }

    static void updateUserNameCookie(HttpServletRequest req, HttpServletResponse resp, String username, boolean isChainedUsernameAvailable, boolean allowUsernameEdits, int rememberUsernameCookieLifetime, String cookieName) {
        boolean enableCookieForChainedUsername = HtmlFormIdpAuthnAdapter.enableRememberChainedUsername(isChainedUsernameAvailable, allowUsernameEdits);
        if (enableCookieForChainedUsername) {
            boolean rememberUsername = (Boolean)REMEMBER_USERNAME_MAPPING.getValue(req);
            int age = rememberUsername ? HtmlFormIdpAuthnAdapter.getRememberUsernameCookieLifetime(rememberUsernameCookieLifetime) : 0;
            String cookieValue = rememberUsername ? HtmlFormIdpAuthnAdapter.encodeCookieValue(username) : "";
            HtmlFormIdpAuthnAdapterUtils.addCookie(cookieName, cookieValue, age, resp);
        }
    }

    public static int getRememberUsernameCookieLifetime(int cookieLifetime) {
        return 86400 * cookieLifetime;
    }

    private boolean enableRememberChainedUsername(boolean isChainedUsernameAvailable) {
        return HtmlFormIdpAuthnAdapter.enableRememberChainedUsername(isChainedUsernameAvailable, this.allowUsernameEdits);
    }

    public static boolean enableRememberChainedUsername(boolean isChainedUsernameAvailable, boolean allowUsernameEdits) {
        return !isChainedUsernameAvailable || allowUsernameEdits;
    }

    private boolean isSessionTracking() {
        return !this.sessionState.equals("None");
    }

    private void challengeWithForm(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, AuthnPolicy authnPolicy, String url, String name, boolean loginFailed, String authnMessageKey, String serverError, boolean isChainedUsernameAvailable) throws IOException {
        ChallengeWithForm form = new ChallengeWithForm.Builder().authnPolicy(authnPolicy).url(url).name(name).loginFailed(loginFailed).errorMessageKey(null).authnMessageKey(authnMessageKey).serverError(serverError).isChainedUsernameAvailable(isChainedUsernameAvailable).pwdCrdVal(this.pwdCrdVal).pwmLocation(this.pwmLocation).allowsChangePassword(this.adminAllowsPasswordChanges).loginTemplateName(this.loginTemplateName).localIdentityProfileId(this.localIdentityProfileId).cookieName(this.cookieName).resetType(this.resetType).enableRememberMyUsername(this.enableRememberUsername).showMyDeviceCheckbox(HtmlFormIdpAuthnAdapterUtils.showMyDeviceCheckbox(this.enableMyDevice, inParameters)).myDeviceChecked(HtmlFormIdpAuthnAdapterUtils.isMyDeviceSelected(req, this.myDeviceCookieName)).allowUsernameEdits(this.allowUsernameEdits).enableUsernameRecovery(HtmlFormIdpAuthnAdapter.supportsUsernameRecovery(this.config, this.pwdCrdVal)).captchaEnabled(this.isCaptchaEnabledAuthentication(this.config)).captchaProviderId(this.getCaptchaProviderId(this.config)).build();
        form.render(req, resp, inParameters);
    }

    public static String getForgetPasswordUrl(HttpServletRequest request, HttpServletResponse response) {
        String forgotPasswordEndpoint = AdapterPathSupport.convertPath((HttpServletRequest)request, (HttpServletResponse)response, (String)"/ext/pwdreset/Identify");
        return HtmlFormIdpAuthnAdapter.getFormattedEndpointURL(forgotPasswordEndpoint);
    }

    private static String getResumeUrlWithBase(String resumeUrl) {
        if (StringUtils.isNotBlank((String)resumeUrl) && !StringUtils.startsWithIgnoreCase((String)resumeUrl, (String)"http")) {
            String contextPath = PropertyInfo.getContextPath();
            if (contextPath != null && !"/".equals(contextPath) && ((String)resumeUrl).startsWith(contextPath)) {
                resumeUrl = ((String)resumeUrl).substring(contextPath.length());
            }
            String currentBaseUrl = BaseUrlAccessor.getCurrentBaseUrl();
            resumeUrl = currentBaseUrl + (String)resumeUrl;
        }
        return resumeUrl;
    }

    private static String getChangePasswordUrl(HttpServletRequest request, HttpServletResponse response) {
        String changePasswordEndpoint = AdapterPathSupport.convertPath((HttpServletRequest)request, (HttpServletResponse)response, (String)"/ext/pwdchange/Identify");
        return HtmlFormIdpAuthnAdapter.getFormattedEndpointURL(changePasswordEndpoint);
    }

    public static String getRecoverUsernameUrl(HttpServletRequest request, HttpServletResponse response) {
        String passwordRecoveryEndpoint = AdapterPathSupport.convertPath((HttpServletRequest)request, (HttpServletResponse)response, (String)"/ext/idrecovery/Recover");
        return HtmlFormIdpAuthnAdapter.getFormattedEndpointURL(passwordRecoveryEndpoint);
    }

    private static String getFormattedEndpointURL(String endpoint) {
        LinkedHashMap<String, String> queryParams = new LinkedHashMap<String, String>();
        queryParams.put("InternalRedirect", "true");
        return Util.appendQueryParams((String)endpoint, queryParams);
    }

    public static void promptForPasswordChange(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, AuthnPolicy authnPolicy, String adapterId, String resumeUrl, String authnMessageKey, boolean isChainedUsernameAvailable, String username, String pwmLocation, String pwmTemplateName, boolean adminAllowsPasswordChanges, String sessionKeyLoginContext) throws IOException {
        if (StringUtils.isBlank((String)pwmLocation)) {
            HtmlFormIdpAuthnAdapter.changePasswordWithForm(req, resp, inParameters, authnPolicy, adapterId, resumeUrl, authnMessageKey, isChainedUsernameAvailable, username, sessionKeyLoginContext);
        } else {
            HtmlFormIdpAuthnAdapter.changePasswordWithRedirectOrMessageTemplate(req, resp, inParameters, authnPolicy, adapterId, resumeUrl, pwmLocation, pwmTemplateName, authnMessageKey, adminAllowsPasswordChanges, isChainedUsernameAvailable, username, sessionKeyLoginContext);
        }
    }

    private static void changePasswordWithForm(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, AuthnPolicy authnPolicy, String adapterId, String resumeUrl, String authnMessageKey, boolean isChainedUsernameAvailable, String username, String sessionKeyLoginContext) throws IOException {
        HtmlFormIdpAuthnAdapter.savePasswordSessionState(req, resp, inParameters, authnPolicy, adapterId, resumeUrl, authnMessageKey, isChainedUsernameAvailable, username, sessionKeyLoginContext);
        if (AuthnApiSupport.getDefault().isApiRequest(req)) {
            PasswordChangeHandler.reissueRequestToPasswordChangeIdentifyServlet(req, resp);
        } else {
            String changePasswordUrl = HtmlFormIdpAuthnAdapter.getChangePasswordUrl(req, resp);
            resp.sendRedirect(changePasswordUrl);
        }
    }

    private static void changePasswordWithRedirectOrMessageTemplate(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, AuthnPolicy authnPolicy, String adapterId, String resumeUrl, String redirectUrl, String templateName, String authnMessageKey, boolean adminAllowsPasswordChanges, boolean isChainedUsernameAvailable, String username, String sessionKeyLoginContext) throws IOException {
        if (authnPolicy.allowUserInteraction() && adminAllowsPasswordChanges) {
            if (AuthnApiSupport.getDefault().isApiRequest(req)) {
                HtmlFormIdpAuthnAdapter.savePasswordSessionState(req, resp, inParameters, authnPolicy, adapterId, resumeUrl, authnMessageKey, isChainedUsernameAvailable, username, sessionKeyLoginContext);
                PasswordChangeHandler.reissueRequestToPasswordChangeIdentifyServlet(req, resp);
            } else if (StringUtils.isBlank((String)templateName)) {
                resp.sendRedirect(redirectUrl);
            } else {
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("headerMessage", "pwmHeaderMessage");
                params.put("authnMessageKey", authnMessageKey);
                params.put("redirectUrl", redirectUrl);
                params.put("linkText", "pwmLinkText");
                TemplateRendererUtil.render((HttpServletRequest)req, (HttpServletResponse)resp, (String)templateName, params);
            }
        }
    }

    private static void savePasswordSessionState(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, AuthnPolicy authnPolicy, String adapterId, String resumeUrl, String authnMessageKey, boolean isChainedUsernameAvailable, String username, String sessionKeyLoginContext) {
        String expiringUsername = null;
        if (AuthnApiSupport.getDefault().isApiRequest(req)) {
            expiringUsername = PasswordChangeHandler.getExpiringUsername(req);
            if (username == null && expiringUsername != null) {
                username = expiringUsername;
            }
        }
        ChangePasswordSessionState state = ChangePasswordSessionState.create(req, resp);
        state.setDefaultTemplateParams(TemplateParamUtil.populateDefaultTemplateParams(inParameters));
        state.setFromHtmlFormAdapter(true);
        state.setSessionKeyLoginContext(sessionKeyLoginContext);
        state.setChainedUsernameAvailable(isChainedUsernameAvailable);
        state.setUsername(username);
        state.setAuthnMessageKey(authnMessageKey);
        state.setAuthnPolicy(authnPolicy);
        state.setPasswordExpiring(expiringUsername != null || HtmlFormIdpAuthnAdapter.isResetPendingPassword(req, username));
        state.setResumeUrl(resumeUrl);
        state.setTargetResource(HtmlFormIdpAuthnAdapter.getResumeUrlWithBase(resumeUrl));
        state.setAdapterId(adapterId);
        state.setTrackedHttpParams((Map)inParameters.get("com.pingidentity.adapter.tracked.http.request.params"));
        state.setPartnerId(HtmlFormIdpAuthnAdapter.getPartnerId(inParameters));
    }

    public void configure(Configuration configuration) {
        String sessionMaxTimeout;
        this.maxConsecutiveFailures = Integer.parseInt(configuration.getFieldValue("Challenge Retries"));
        this.accountLockingService = MgmtFactory.getAccountLockingService().getInstance(this.getClass().getSimpleName() + configuration.getId());
        for (Row row : configuration.getTable("Credential Validators").getRows()) {
            this.pwdCrdVal.add(row.getFieldValue("Password Credential Validator Instance"));
        }
        Field lipField = configuration.getField("Local Identity Profile");
        if (lipField != null) {
            this.localIdentityProfileId = lipField.getValue();
        }
        if (HtmlFormIdpAuthnAdapter.supportsPasswordReset(this.pwdCrdVal)) {
            this.registerPasswordResetHandlers();
        }
        this.adminAllowsPasswordChanges = configuration.getBooleanFieldValue("Allow Password Changes");
        if (this.adminAllowsPasswordChanges && HtmlFormIdpAuthnAdapter.supportsPasswordChange(this.pwdCrdVal, this.pwmLocation)) {
            this.registerChangePasswordHandlers();
        }
        if (HtmlFormIdpAuthnAdapter.supportsUsernameRecovery(configuration, this.pwdCrdVal)) {
            this.registerRecoverUsernameHandlers();
        }
        if (configuration.getFieldValue("Session Timeout") != null && !configuration.getFieldValue("Session Timeout").equals("")) {
            this.sessionTimeout = Integer.valueOf(configuration.getFieldValue("Session Timeout"));
        }
        if (StringUtils.isNotBlank((String)(sessionMaxTimeout = configuration.getFieldValue("Session Max Timeout")))) {
            this.sessionMaxTimeout = Integer.valueOf(sessionMaxTimeout);
        }
        this.failAuthenticationOnAccountLockout = configuration.getBooleanFieldValue("Fail Authentication on Account Lockout", true);
        this.loginTemplateName = configuration.getFieldValue("Login Template");
        String logoutRedirectLocation = configuration.getFieldValue("Logout Redirect");
        String logoutTemplateName = configuration.getFieldValue("Logout Template");
        String logoutSubPath = configuration.getFieldValue("Logout Path");
        this.sessionState = configuration.getFieldValue("Session State");
        this.loginChallengeTemplateName = configuration.getFieldValue("Login Challenge Template");
        this.enableRememberUsername = configuration.getBooleanFieldValue("Enable 'Remember My Username'");
        this.enableMyDevice = configuration.getBooleanFieldValue("Enable 'This is My Device'");
        this.allowUsernameEdits = configuration.getBooleanFieldValue("Allow Username Edits During Chaining");
        String changePasswordEmailNotificationTemplateName = configuration.getFieldValue("Change Password Email Template");
        this.resetType = StringUtils.defaultIfEmpty((String)configuration.getFieldValue("Password Reset Type"), (String)"NONE");
        if (StringUtils.isBlank((String)changePasswordEmailNotificationTemplateName)) {
            changePasswordEmailNotificationTemplateName = "message-template-end-user-password-change.html";
        }
        try {
            this.rememberUsernameCookieLifetime = Integer.parseInt(configuration.getFieldValue("'Remember My Username' Lifetime"));
        }
        catch (NumberFormatException ne) {
            this.rememberUsernameCookieLifetime = 30;
        }
        try {
            this.myDeviceCookieLifetimeDays = Integer.parseInt(configuration.getFieldValue("'This is My Device' Lifetime"));
        }
        catch (NumberFormatException ne) {
            this.myDeviceCookieLifetimeDays = Integer.parseInt("30");
        }
        this.pwmLocation = configuration.getFieldValue("Password Management System");
        this.pwmTemplateName = configuration.getFieldValue("Password Management System Message Template");
        this.enablePasswordExpiryNotification = configuration.getBooleanFieldValue("Show Password Expiring Warning");
        this.passwordExpiryTemplateName = configuration.getFieldValue("Expiring Password Warning Template");
        if (StringUtils.isBlank((String)this.passwordExpiryTemplateName)) {
            this.passwordExpiryTemplateName = "html.form.password.expiring.notification.template.html";
        }
        try {
            this.expiringPasswordWarningThreshold = Long.parseLong(configuration.getFieldValue("Threshold for Expiring Password Warning")) * 86400000L;
        }
        catch (NumberFormatException ne) {
            // empty catch block
        }
        try {
            this.expiringPasswordSnoozeInterval = Integer.parseInt(configuration.getFieldValue("Snooze Interval for Expiring Password Warning")) * 3600;
        }
        catch (NumberFormatException ne) {
            // empty catch block
        }
        this.requireReAuthenticationAfterChangePassword = configuration.getBooleanFieldValue("Require Re-Authentication for Change Password Flow", true);
        this.requireReAuthenticationAfterPasswordReset = configuration.getBooleanFieldValue("Require Re-Authentication for Password Reset Flow", true);
        this.passwordUpdateTimeoutInMins = configuration.getIntFieldValue("Password Update Timeout");
        LogoutHandler logoutHandler = new LogoutHandler((IdpAuthenticationAdapter)this, logoutSubPath);
        logoutHandler.setRedirectDestination(logoutRedirectLocation);
        logoutHandler.setTemplateName(logoutTemplateName);
        logoutHandler.setDefaultContent("<HTML>You've been logged out of the system.</HTML>");
        this.trackAuthenticationTime = configuration.getBooleanFieldValue("Track Authentication Time");
        this.config = configuration;
        this.SESSION_KEY_LOGIN_CONTEXT = this.getClass().getSimpleName() + ":" + this.config.getId() + ":formAdapterLoginContext";
        this.setSessionTracking();
        this.cookieName = HtmlFormIdpAuthnAdapterUtils.getRememberUsernameCookieName(this.config.getId());
        this.myDeviceCookieName = HtmlFormIdpAuthnAdapterUtils.getMyDeviceCookieName(this.config.getId());
    }

    private void registerPasswordResetHandlers() {
        HandlerRegistry.registerHandler((String)"/pwdreset/Identify", (Handler)new com.pingidentity.adapters.htmlform.pwdreset.servlet.IdentifyServlet());
        HandlerRegistry.registerHandler((String)"/pwdreset/SecurityCode", (Handler)new SecurityCodeServlet());
        HandlerRegistry.registerHandler((String)"/pwdreset/Success", (Handler)new com.pingidentity.adapters.htmlform.pwdreset.servlet.SuccessServlet());
        HandlerRegistry.registerHandler((String)"/pwdreset/Resume", (Handler)new ResumeServlet());
        HandlerRegistry.registerHandler((String)"/pwdreset/Error", (Handler)new ErrorServlet());
        HandlerRegistry.registerHandler((String)"/pwdreset/Reset", (Handler)new ResetServlet());
        HandlerRegistry.registerHandler((String)"/pwdreset/Unlock", (Handler)new AccountUnlockServlet());
        HandlerRegistry.registerHandler((String)"/pwdreset/PingID", (Handler)new PingIDServlet());
        PolicyServlet policyServlet = new PolicyServlet();
        HandlerRegistry.registerHandler((String)"/pwdreset/Policy", (Handler)policyServlet);
        ProfileProcessFactory.addStaticResumeRequestFromAuthnResponseHandler((ResumeRequestFromAuthnResponseHandler)policyServlet);
    }

    private void registerChangePasswordHandlers() {
        HandlerRegistry.registerHandler((String)"/pwdchange/Identify", (Handler)new IdentifyServlet());
        HandlerRegistry.registerHandler((String)"/pwdchange/Success", (Handler)new SuccessServlet());
        HandlerRegistry.registerHandler((String)"/pwdchange/Error", (Handler)new com.pingidentity.adapters.htmlform.pwdchange.servlet.ErrorServlet());
        com.pingidentity.adapters.htmlform.pwdchange.servlet.PolicyServlet policyServlet = new com.pingidentity.adapters.htmlform.pwdchange.servlet.PolicyServlet();
        HandlerRegistry.registerHandler((String)"/pwdchange/Policy", (Handler)policyServlet);
        ProfileProcessFactory.addStaticResumeRequestFromAuthnResponseHandler((ResumeRequestFromAuthnResponseHandler)policyServlet);
    }

    private void registerRecoverUsernameHandlers() {
        HandlerRegistry.registerHandler((String)"/idrecovery/Recover", (Handler)new RecoverUsernameServlet(AbstractPasswordManagementServlet.Stage.IDENTIFYING));
        HandlerRegistry.registerHandler((String)"/idrecovery/EmailSent", (Handler)new RecoverUsernameServlet(AbstractPasswordManagementServlet.Stage.COMPLETED));
        HandlerRegistry.registerHandler((String)"/idrecovery/Error", (Handler)new com.pingidentity.adapters.htmlform.idrecovery.servlet.ErrorServlet());
    }

    public boolean logoutAuthN(Map authnIdentifiers, HttpServletRequest req, HttpServletResponse resp, String resumePath) {
        if (this.isSessionTracking()) {
            if (req == null && resp == null && resumePath == null) {
                return false;
            }
            this.sessionStateSupport.removeAttribute(this.SESSION_KEY_AUTHN, req, resp);
            this.sessionStateSupport.removeAttribute(this.SESSION_KEY_USERNAME, req, resp);
        }
        return true;
    }

    private boolean isValidRequest(HttpServletRequest request, HttpServletResponse response, Map<String, Object> inParameters) throws IOException {
        String chainedUsername = (String)inParameters.get("com.pingidentity.adapter.input.parameter.userid");
        String requestedUsername = (String)USERNAME_MAPPING.getValue(request);
        if (AuthnApiSupport.getDefault().isApiRequest(request) && !this.allowUsernameEdits && chainedUsername != null && requestedUsername != null && !chainedUsername.equals(requestedUsername)) {
            AuthnErrorDetail credentialValidationFailed = CommonErrorDetailSpec.CREDENTIAL_VALIDATION_FAILED.makeInstanceBuilder().userMessageKey("authn.api.username.mismatch").build();
            AuthnError validationError = CommonErrorSpec.VALIDATION_ERROR.makeInstanceBuilder().detail(credentialValidationFailed).build();
            AuthnApiSupport.getDefault().writeErrorResponse(request, response, validationError);
            return false;
        }
        return !AuthnApiSupport.getDefault().isApiRequest(request) || HtmlFormAuthnApiHandler.isValidApiPostRequest(request, response, (String)inParameters.get("com.pingidentity.adapter.input.parameter.resume.path"), this.localIdentityProfileId);
    }

    public AuthnAdapterResponse lookupAuthN(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters) throws IOException {
        AuthnAdapterResponse.AUTHN_STATUS responseStatus;
        Map responseAttributeMap = null;
        HtmlFormLoginContext loginContext = new HtmlFormLoginContext();
        String username = null;
        boolean isFormAuthenticationEvent = false;
        boolean modifiedAuthnPolicy = false;
        String resumeUrl = (String)inParameters.get("com.pingidentity.adapter.input.parameter.resume.path");
        if (HtmlFormAuthnApiHandler.isApiGetRequest(req) && HtmlFormAuthnApiHandler.isSavedApiStateFound(req, resp, resumeUrl)) {
            HtmlFormAuthnApiHandler.renderPreviousApiResponse(req, resp, resumeUrl);
        } else if (this.isValidRequest(req, resp, inParameters)) {
            String requestedAction = this.getRequestedAction(inParameters, req, resp);
            if (StringUtils.isNotBlank((String)requestedAction)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("A requested action of '" + requestedAction + "' was found."));
                }
                AuthnAdapterResponse authnAdapterResponse = new AuthnAdapterResponse();
                authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.ACTION);
                authnAdapterResponse.setAttributeMap(Collections.singletonMap("policy.action", requestedAction));
                return authnAdapterResponse;
            }
            AuthnPolicy authnPolicy = (AuthnPolicy)inParameters.get("com.pingidentity.adapter.input.parameter.authn.policy");
            if (Boolean.TRUE.equals(inParameters.get("com.pingidentity.adapter.input.parameter.try.lookup.authn")) && authnPolicy.allowUserInteraction()) {
                if (authnPolicy.reauthenticate()) {
                    AuthnAdapterResponse authnAdapterResponse = new AuthnAdapterResponse();
                    authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.INTERACTION_REQUIRED);
                    return authnAdapterResponse;
                }
                authnPolicy = new AuthnPolicy(false, authnPolicy.reauthenticate(), authnPolicy.getRequestAuthnContexts());
                inParameters.put("com.pingidentity.adapter.input.parameter.authn.policy", authnPolicy);
                modifiedAuthnPolicy = true;
            }
            username = inParameters.get("com.pingidentity.adapter.input.parameter.userid") == null ? null : (String)inParameters.get("com.pingidentity.adapter.input.parameter.userid");
            String usernameFromRequest = (String)USERNAME_MAPPING.getValue(req);
            PasswordManagementSessionState passwordManagementSessionState = this.handleReturnFromPasswordManagement(req, resp, resumeUrl);
            PasswordManagementAuthenticationContext passwordManagementContext = null;
            if (passwordManagementSessionState != null) {
                if (usernameFromRequest == null) {
                    usernameFromRequest = passwordManagementSessionState.getUsername();
                }
                if (!this.requireReAuthenticationAfterChangePassword && passwordManagementSessionState instanceof ChangePasswordSessionState || !this.requireReAuthenticationAfterPasswordReset && passwordManagementSessionState instanceof PasswordResetSessionState) {
                    passwordManagementContext = new PasswordManagementAuthenticationContext(passwordManagementSessionState.isSuccess(), passwordManagementSessionState.getPcvId());
                }
            }
            boolean isChainedUsernameAvailable = true;
            if (StringUtils.isBlank((String)username) || !StringUtils.isBlank((String)usernameFromRequest) && !usernameFromRequest.equals(username) && this.allowUsernameEdits) {
                username = usernameFromRequest;
                isChainedUsernameAvailable = false;
            }
            loginContext = this.handleLoginForm(req, resp, inParameters, authnPolicy, resumeUrl, loginContext, username, isChainedUsernameAvailable, passwordManagementContext);
            isFormAuthenticationEvent = true;
            responseAttributeMap = loginContext.getAuthnIds();
        }
        if (loginContext.isAlternateAuthnSystem()) {
            if (AuthnApiSupport.getDefault().isApiRequest(req)) {
                HtmlFormAuthnApiHandler.clearApiState(req, resp);
            }
            responseStatus = AuthnAdapterResponse.AUTHN_STATUS.ACTION;
            username = loginContext.getUserName();
        } else {
            responseStatus = resp.isCommitted() ? AuthnAdapterResponse.AUTHN_STATUS.IN_PROGRESS : (responseAttributeMap == null || responseAttributeMap.isEmpty() ? AuthnAdapterResponse.AUTHN_STATUS.FAILURE : AuthnAdapterResponse.AUTHN_STATUS.SUCCESS);
        }
        if (AuthnAdapterResponse.AUTHN_STATUS.SUCCESS.equals((Object)responseStatus) || AuthnAdapterResponse.AUTHN_STATUS.FAILURE.equals((Object)responseStatus)) {
            if (modifiedAuthnPolicy && AuthnAdapterResponse.AUTHN_STATUS.FAILURE.equals((Object)responseStatus)) {
                responseStatus = AuthnAdapterResponse.AUTHN_STATUS.INTERACTION_REQUIRED;
            }
            this.clearSessionLoginContext(resumeUrl, req, resp);
            if (AuthnApiSupport.getDefault().isApiRequest(req)) {
                HtmlFormAuthnApiHandler.clearApiState(req, resp);
            }
        }
        AuthnAdapterResponse authnAdapterResponse = new AuthnAdapterResponse();
        authnAdapterResponse.setAuthnStatus(responseStatus);
        authnAdapterResponse.setAttributeMap(responseAttributeMap);
        authnAdapterResponse.setUsername(username);
        authnAdapterResponse.setErrorMessage(AuthenticateFormHandler.getPasswordCredentialValidatorErrorMessage((Exception)((Object)loginContext.getException())));
        if (isFormAuthenticationEvent) {
            this.captchaPostAuthenticationCallback(req, resp, inParameters, authnAdapterResponse);
        }
        return authnAdapterResponse;
    }

    private void clearSessionLoginContext(String resumeUrl, HttpServletRequest request, HttpServletResponse response) {
        new TransactionalStateSupport(resumeUrl).removeAttribute(this.SESSION_KEY_LOGIN_CONTEXT, request, response);
    }

    private PasswordManagementSessionState handleReturnFromPasswordManagement(HttpServletRequest req, HttpServletResponse resp, String resumeUrl) {
        PasswordManagementSessionState passwordManagementSessionState = PasswordManagementSessionState.getAndPreserveTransactionId(req, resp, PasswordManagementSessionState.class);
        if (passwordManagementSessionState != null) {
            if (!StringUtils.equals((String)passwordManagementSessionState.getAdapterId(), (String)this.config.getId()) || !passwordManagementSessionState.doesResumeUrlMatch(resumeUrl)) {
                return null;
            }
            PasswordManagementSessionState.delete(req, resp);
            if (passwordManagementSessionState.isPasswordUpdateSessionExpired(this.passwordUpdateTimeoutInMins)) {
                return null;
            }
        }
        return passwordManagementSessionState;
    }

    private String getRequestedAction(Map<String, Object> inParameters, HttpServletRequest req, HttpServletResponse resp) {
        String requestedActionInParam = this.getRequestedActionFromInParams(inParameters);
        if (requestedActionInParam != null) {
            String resumeUrl = (String)inParameters.get("com.pingidentity.adapter.input.parameter.resume.path");
            TransactionalStateSupport txStateSupport = new TransactionalStateSupport(resumeUrl);
            Object isThirdPartyRegister = txStateSupport.getAttribute("local.identity.resume.registration", req, resp);
            if (isThirdPartyRegister != null && ((Boolean)isThirdPartyRegister).booleanValue()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Action query param was set, however registering with alternate auth source was requested. Ignoring action query param.");
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Using the query parameter '" + requestedActionInParam + "' for the policy.action attribute."));
                }
                txStateSupport.setAttribute("pf.query.param.action", (Object)true, req, resp);
                return requestedActionInParam;
            }
        }
        if (StringUtils.isNotBlank((String)this.localIdentityProfileId)) {
            LocalIdentityProfile lip = MgmtFactory.getLocalIdentityProfileManager().getProfile(this.localIdentityProfileId);
            if (lip != null) {
                SessionStateSupport sessionStateSupport;
                Object previousRequestedAction;
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Checking session state for the action attribute.");
                }
                if ((previousRequestedAction = (sessionStateSupport = new SessionStateSupport()).removeAttribute(lip.getPolicyActionStateKey(), req, resp)) != null) {
                    log.debug((Object)("Found the action '" + previousRequestedAction + "' to use from the session state."));
                    return (String)previousRequestedAction;
                }
            } else {
                log.debug((Object)("No local identity profile with id '" + this.localIdentityProfileId + "' was found. Processing HTML Form normally."));
            }
        }
        return null;
    }

    private String getRequestedActionFromInParams(Map<String, Object> inParameters) {
        AuthnPolicy authnPolicy = (AuthnPolicy)inParameters.get("com.pingidentity.adapter.input.parameter.authn.policy");
        if (authnPolicy != null && authnPolicy.allowUserInteraction() && authnPolicy.registrationRequested()) {
            if (StringUtils.isNotBlank((String)this.localIdentityProfileId)) {
                LocalIdentityProfile lip = MgmtFactory.getLocalIdentityProfileManager().getProfile(this.localIdentityProfileId);
                if (lip != null) {
                    if (lip.isRegistrationEnabled()) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"Prompt=create detected, a requested action of 'identity.registration' is set. Redirecting to the registration page.");
                        }
                        return "identity.registration";
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Registration requested but not enabled for local identity profile with id '" + this.localIdentityProfileId + "'. Processing HTML Form normally."));
                    }
                } else if (log.isDebugEnabled()) {
                    log.debug((Object)("Registration requested but no local identity profile with id '" + this.localIdentityProfileId + "' was found. Processing HTML Form normally."));
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"Registration requested but no local identity profile found. Processing HTML Form normally.");
            }
        }
        return (String)inParameters.get("policy.action");
    }

    private boolean isRegistrationRequested(Map<String, Object> inParameters) {
        LocalIdentityProfile lip = MgmtFactory.getLocalIdentityProfileManager().getProfile(this.localIdentityProfileId);
        if (lip != null && lip.isRegistrationEnabled()) {
            AuthnPolicy authnPolicy = (AuthnPolicy)inParameters.get("com.pingidentity.adapter.input.parameter.authn.policy");
            return authnPolicy != null && authnPolicy.allowUserInteraction() && authnPolicy.registrationRequested();
        }
        return false;
    }

    public IdpAuthnAdapterDescriptor getAdapterDescriptor() {
        IdpAuthnAdapterDescriptor result = new IdpAuthnAdapterDescriptor((ConfigurableAuthnAdapter)this, ADAPTER_NAME, this.httpFormGuiConfiguration.createAttributeContract(), true, this.httpFormGuiConfiguration.getGuiDescriptor(), false, VersionUtil.getVersion());
        HashMap<String, Boolean> metadata = new HashMap<String, Boolean>();
        metadata.put("EarlyCreateAndConfigure", true);
        metadata.put("FipsStatus", (Boolean)PluginFipsStatus.COMPLIANT);
        metadata.put("TryLookupAuthn", true);
        result.setMetadata(metadata);
        return result;
    }

    public Map<String, Object> getAdapterInfo() {
        return null;
    }

    public PluginApiSpec getApiSpec() {
        List<AuthnStateSpec> states = Arrays.asList(CommonStateSpec.USERNAME_PASSWORD_REQUIRED, CommonStateSpec.CHALLENGE_RESPONSE_REQUIRED, CommonStateSpec.MUST_CHANGE_PASSWORD, CommonStateSpec.CHANGE_PASSWORD_EXTERNAL, CommonStateSpec.NEW_PASSWORD_RECOMMENDED, CommonStateSpec.NEW_PASSWORD_REQUIRED, CommonStateSpec.SUCCESSFUL_PASSWORD_CHANGE, CommonStateSpec.ACCOUNT_RECOVERY_USERNAME_REQUIRED, CommonStateSpec.ACCOUNT_RECOVERY_OTL_VERIFICATION_REQUIRED, CommonStateSpec.RECOVERY_CODE_REQUIRED, CommonStateSpec.PASSWORD_RESET_REQUIRED, CommonStateSpec.SUCCESSFUL_PASSWORD_RESET, CommonStateSpec.USERNAME_RECOVERY_EMAIL_REQUIRED, CommonStateSpec.USERNAME_RECOVERY_EMAIL_SENT, CommonStateSpec.SUCCESSFUL_ACCOUNT_UNLOCK, CommonStateSpec.CURRENT_CREDENTIALS_REQUIRED);
        return new PluginApiSpec(states);
    }

    private void setSessionTracking() {
        String session = "SESSION";
        String username = "username";
        String firstActivity = "first-activity";
        String lastActivity = "last-activity";
        if (this.sessionState.equals("Per Adapter")) {
            this.SESSION_KEY_AUTHN = this.getClass().getSimpleName() + ":" + this.config.getId() + ":" + session;
            this.SESSION_KEY_USERNAME = this.getClass().getSimpleName() + ":" + this.config.getId() + ":" + username;
            this.SESSION_KEY_FIRST_ACTIVITY = this.getClass().getSimpleName() + ":" + this.config.getId() + ":" + firstActivity;
            this.SESSION_KEY_LAST_ACTIVITY = this.getClass().getSimpleName() + ":" + this.config.getId() + ":" + lastActivity;
        } else {
            this.SESSION_KEY_AUTHN = this.getClass().getSimpleName() + ":" + session;
            this.SESSION_KEY_USERNAME = this.getClass().getSimpleName() + ":" + username;
            this.SESSION_KEY_FIRST_ACTIVITY = this.getClass().getSimpleName() + ":" + firstActivity;
            this.SESSION_KEY_LAST_ACTIVITY = this.getClass().getSimpleName() + ":" + lastActivity;
        }
    }

    public static boolean supportsPasswordChange(List<String> pcvList, String passwordManagementLocation) {
        for (String pcvId : pcvList) {
            if (!HtmlFormIdpAuthnAdapterUtils.supportsPasswordChange(pcvId, passwordManagementLocation)) continue;
            return true;
        }
        log.error((Object)"The change password request fails because none of the configured password credential validators or the underlying datastores support password changes. Check the log for possible related messages from the password credential validators.");
        return false;
    }

    public static boolean supportsPasswordReset(List<String> pcvList) {
        for (String pcvId : pcvList) {
            if (!HtmlFormIdpAuthnAdapterUtils.supportsPasswordReset(pcvId)) continue;
            return true;
        }
        return false;
    }

    private static boolean supportsUsernameRecovery(Configuration configuration, List<String> pcvList) {
        return HtmlFormIdpAuthnAdapter.supportsUsernameRecovery(configuration.getBooleanFieldValue("Enable Username Recovery"), pcvList);
    }

    public static boolean supportsUsernameRecovery(boolean enableUsernameRecovery, List<String> pcvList) {
        if (enableUsernameRecovery) {
            for (String pcvId : pcvList) {
                PasswordCredentialValidator pcv = new PasswordCredentialValidatorAccessor().getPasswordCredentialValidator(pcvId);
                if (!(pcv instanceof RecoverableUsername)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isResetTypeNone(Configuration configuration) {
        String resetType = StringUtils.defaultIfEmpty((String)configuration.getFieldValue("Password Reset Type"), (String)"NONE");
        return HtmlFormIdpAuthnAdapter.isResetTypeNone(resetType);
    }

    public static boolean isResetTypeNone(String resetType) {
        return resetType.equals("NONE");
    }

    private boolean isSessionMaxExpired(HttpServletRequest req, HttpServletResponse resp) {
        return this.isSessionTracking() && this.sessionStateSupport.isSessionExpired(this.SESSION_KEY_FIRST_ACTIVITY, this.sessionMaxTimeout, req, resp);
    }

    private boolean isCaptchaEnabledAuthentication(Configuration configuration) {
        return configuration.getBooleanFieldValue("CAPTCHA for Authentication");
    }

    private String getCaptchaProviderId(Configuration configuration) {
        return configuration.getFieldValue("CAPTCHA Provider");
    }

    private static String encodeCookieValue(String val) {
        return ENCODING_PREFIX + Base64URL.encodeToString((byte[])val.getBytes(StandardCharsets.UTF_8));
    }

    private static String decodeCookieValue(String val) {
        if (val.startsWith(ENCODING_PREFIX)) {
            return Base64URL.decodeToString((String)val.substring(ENCODING_PREFIX.length()), (String)"UTF-8");
        }
        return val;
    }

    public Map<String, Object> authenticateUser(String username, String password, Map<String, Object> extraParams) {
        for (String pcv : this.pwdCrdVal) {
            PasswordCredentialValidator credentialValidator;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Attempting to authenticate against the PCV '" + pcv + "'."));
            }
            if ((credentialValidator = new PasswordCredentialValidatorAccessor().getPasswordCredentialValidator(pcv)) == null) continue;
            try {
                AttributeMap map = credentialValidator.processPasswordCredential(username, password);
                if (map != null && !map.isEmpty()) {
                    if (this.trackAuthenticationTime) {
                        map.put("org.sourceid.saml20.adapter.idp.authn.authnInst", Long.toString(System.currentTimeMillis()));
                    }
                    return new HashMap<String, Object>((Map<String, Object>)map);
                }
                log.trace((Object)"No attributes were returned. Unable to successfully authenticate the user with this PCV.");
            }
            catch (PasswordValidationException e) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)(pcv + " encountered an error: "), (Throwable)e);
            }
        }
        return Collections.emptyMap();
    }

    public boolean isDeferAuthenticationSessionRegistration() {
        return false;
    }

    public void onTransactionComplete(HttpServletRequest request, HttpServletResponse response, Map<String, Object> authnIdentifiersMap, AttributeMap policyResultMap) {
        throw new UnsupportedOperationException();
    }

    public void onTransactionComplete(HttpServletRequest request, HttpServletResponse response, Map<String, Object> authnIdentifiersMap, AttributeMap policyResultMap, Map<String, Object> parameters) {
        if (!this.isCaptchaEnabledAuthentication(this.config)) {
            return;
        }
        CaptchaProvider provider = this.getCaptchaProvider();
        if (provider instanceof TransactionAwareAuthenticationAdapter) {
            ((TransactionAwareAuthenticationAdapter)provider).onTransactionComplete(request, response, authnIdentifiersMap, policyResultMap, parameters);
        }
    }

    public void onTransactionFailure(HttpServletRequest request, HttpServletResponse response, Map<String, Object> authnIdentifiersMap, Map<String, Object> parameters) {
        if (!this.isCaptchaEnabledAuthentication(this.config)) {
            return;
        }
        CaptchaProvider provider = this.getCaptchaProvider();
        if (provider instanceof TransactionAwareAuthenticationAdapter) {
            ((TransactionAwareAuthenticationAdapter)provider).onTransactionFailure(request, response, authnIdentifiersMap, parameters);
        }
    }

    private void captchaPostAuthenticationCallback(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, AuthnAdapterResponse authnAdapterResponse) {
        if (!this.isCaptchaEnabledAuthentication(this.config)) {
            return;
        }
        CaptchaProvider captchaProvider = this.getCaptchaProvider();
        if (captchaProvider != null) {
            CaptchaContext context = new CaptchaContext.Builder().setRequest(req).setResponse(resp).setAction("login").setInParameters(CaptchaProviderUtil.filterInParameters(inParameters, (String)authnAdapterResponse.getUsername())).build();
            CaptchaProvider.AuthenticationStatus authenticationStatus = new CaptchaProvider.AuthenticationStatus(authnAdapterResponse);
            captchaProvider.postAuthenticationCallback(authenticationStatus, context);
        }
    }

    private CaptchaProvider getCaptchaProvider() {
        String captchaProviderId = this.getCaptchaProviderId(this.config);
        CaptchaProvider captchaProvider = CaptchaProviderAccessor.getCaptchaProvider((String)captchaProviderId);
        if (captchaProvider == null) {
            log.error((Object)("Risk Provider with the id of '" + captchaProviderId + "' not found. Check adapter configuration."));
            return null;
        }
        return captchaProvider;
    }

    private static String getPartnerId(Map<String, Object> inParameters) {
        if (inParameters.get("com.pingidentity.adapter.input.parameter.partner.entityid") != null) {
            return (String)inParameters.get("com.pingidentity.adapter.input.parameter.partner.entityid");
        }
        if (inParameters.get("com.pingidentity.adapter.input.parameter.oauth.client.id") != null) {
            return (String)inParameters.get("com.pingidentity.adapter.input.parameter.oauth.client.id");
        }
        return null;
    }
}

