/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.htmlform.idrecovery.common;

import com.pingidentity.adapters.htmlform.idp.HtmlFormIdpAuthnAdapter;
import com.pingidentity.adapters.htmlform.idrecovery.common.RecoverUsernameConfiguration;
import com.pingidentity.sdk.password.PasswordCredentialValidator;
import com.pingidentity.sdk.password.RecoverableUsername;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.adapter.conf.Row;
import org.sourceid.saml20.domain.IdpAuthnAdapterInstance;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public final class RecoverUsernameConfigHelper {
    private static final Log logger = LogFactory.getLog(RecoverUsernameConfigHelper.class);

    private RecoverUsernameConfigHelper() {
    }

    public static RecoverUsernameConfiguration get(String adapterId) {
        return RecoverUsernameConfigHelper.createUsernameRecoveryConfiguration(adapterId);
    }

    private static RecoverUsernameConfiguration createUsernameRecoveryConfiguration(String adapterId) {
        IdpAuthnAdapterInstance instance = (IdpAuthnAdapterInstance)MgmtFactory.getIdpAdapterManager().getInstance(adapterId);
        if (instance == null) {
            throw new IllegalArgumentException("Adapter ID " + adapterId + " does not exist");
        }
        RecoverUsernameConfiguration recoveryConfig = new RecoverUsernameConfiguration(adapterId);
        Configuration configuration = instance.getRuntimeCompositeConfiguration();
        recoveryConfig.setEnableUsernameRecovery(configuration.getBooleanFieldValue("Enable Username Recovery"));
        recoveryConfig.setRequireVerifiedEmail(configuration.getBooleanFieldValue("Require Verified Email"));
        recoveryConfig.setUsernameRecoveryTemplate(StringUtils.defaultIfEmpty((String)configuration.getFieldValue("Username Recovery Template"), (String)"username.recovery.template.html"));
        recoveryConfig.setUsernameRecoveryInfoTemplate(StringUtils.defaultIfEmpty((String)configuration.getFieldValue("Username Recovery Info Template"), (String)"username.recovery.info.template.html"));
        recoveryConfig.setUsernameRecoveryEmailTemplate(StringUtils.defaultIfEmpty((String)configuration.getFieldValue("Username Recovery Email Template"), (String)"message-template-username-recovery.html"));
        recoveryConfig.setUsernameRecoveryErrorTemplate(StringUtils.defaultIfEmpty((String)configuration.getFieldValue("Password Reset Error Template"), (String)"forgot-password-error.html"));
        recoveryConfig.setEnableCaptcha(configuration.getBooleanFieldValue("CAPTCHA for Username recovery"));
        recoveryConfig.setCaptchaProviderId(configuration.getFieldValue("CAPTCHA Provider"));
        recoveryConfig.setEnablePasswordRecovery(!HtmlFormIdpAuthnAdapter.isResetTypeNone(configuration));
        recoveryConfig.setNotificationPublisher(configuration.getFieldValue("Notification Publisher"));
        ArrayList<String> pcvIds = new ArrayList<String>();
        for (Row row : configuration.getTable("Credential Validators").getRows()) {
            String pcvId = row.getFieldValue("Password Credential Validator Instance");
            PasswordCredentialValidator pcv = MgmtFactory.getCredentialValidatorManager().getValidator(pcvId);
            boolean recoverableUsername = pcv instanceof RecoverableUsername;
            if (!recoverableUsername) continue;
            pcvIds.add(pcvId);
        }
        recoveryConfig.setPcvIds(pcvIds);
        return recoveryConfig;
    }
}

