/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.htmlform.idrecovery.servlet;

import com.pingidentity.adapters.htmlform.idrecovery.common.RecoverUsernameConfigHelper;
import com.pingidentity.adapters.htmlform.idrecovery.common.RecoverUsernameConfiguration;
import com.pingidentity.adapters.htmlform.idrecovery.common.RecoverUsernameSessionState;
import com.pingidentity.adapters.htmlform.pwdmgmt.servlet.AbstractPasswordManagementServlet;
import com.pingidentity.adapters.htmlform.render.handler.api.idrecovery.ApiUsernameRecoveryHandler;
import com.pingidentity.sdk.api.authn.util.AuthnApiSupport;
import java.io.IOException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractRecoverUsernameServlet
extends AbstractPasswordManagementServlet {
    protected final Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    public static final String INVALID_STATE_MESSAGE = "Invalid state (unauthorized method)";

    @Override
    protected RecoverUsernameSessionState getSessionState(HttpServletRequest request, HttpServletResponse response) {
        return RecoverUsernameSessionState.get(request, response);
    }

    @Override
    protected RecoverUsernameConfiguration getConfiguration(HttpServletRequest request, HttpServletResponse response) {
        String adapterId = this.getAdapterId(request, response);
        return RecoverUsernameConfigHelper.get(adapterId);
    }

    @Override
    protected void populateAdapterActionParam(Map<String, Object> stateParams) {
    }

    protected void doCancel(HttpServletRequest request, HttpServletResponse response) throws IOException {
        RecoverUsernameSessionState sessionState = this.getSessionState(request, response);
        sessionState.setStage(AbstractPasswordManagementServlet.Stage.ERROR);
        sessionState.setErrorMessageKey("username.recovery.template.error.cancel");
        if (AuthnApiSupport.getDefault().isApiRequest(request) && sessionState.isFromHtmlFormAdapter()) {
            ApiUsernameRecoveryHandler.reissueRequestToHtmlFormAdapter(request, response);
        } else if (!AuthnApiSupport.getDefault().isApiRequest(request) && sessionState.getTargetResource() != null) {
            this.redirect(response, sessionState.getTargetResource());
        } else {
            this.handleError(request, response, "username.recovery.template.error.cancel");
        }
    }

    protected void handleError(HttpServletRequest request, HttpServletResponse response, String errorMessageKey) throws IOException {
        RecoverUsernameSessionState sessionState = this.getSessionState(request, response);
        sessionState.setStage(AbstractPasswordManagementServlet.Stage.ERROR);
        sessionState.setErrorMessageKey(errorMessageKey);
        if (AuthnApiSupport.getDefault().isApiRequest(request)) {
            ApiUsernameRecoveryHandler.reissueRequestToUsernameRecoveryErrorServlet(request, response);
        } else {
            String errorUrl = request.getContextPath() + "/ext/idrecovery/Error";
            this.redirect(response, errorUrl);
        }
    }
}

