/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.htmlform.pwdchange.common;

import com.pingidentity.adapters.htmlform.idp.HtmlFormIdpAuthnAdapterUtils;
import com.pingidentity.adapters.htmlform.pwdchange.common.ChangePasswordConfiguration;
import com.pingidentity.sdk.password.ChangeablePasswordCredential;
import com.pingidentity.sdk.password.PasswordCredentialValidator;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.adapter.conf.Row;
import org.sourceid.saml20.domain.IdpAuthnAdapterInstance;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public final class ChangePasswordConfigHelper {
    private ChangePasswordConfigHelper() {
    }

    public static ChangePasswordConfiguration get(String adapterId) {
        return ChangePasswordConfigHelper.createPasswordChangeConfiguration(adapterId);
    }

    private static ChangePasswordConfiguration createPasswordChangeConfiguration(String adapterId) {
        IdpAuthnAdapterInstance instance = (IdpAuthnAdapterInstance)MgmtFactory.getIdpAdapterManager().getInstance(adapterId);
        if (instance == null) {
            throw new IllegalArgumentException("Adapter ID " + adapterId + " does not exist");
        }
        ChangePasswordConfiguration pwdConfig = new ChangePasswordConfiguration(adapterId);
        Configuration configuration = instance.getRuntimeCompositeConfiguration();
        pwdConfig.setAllowsChangePassword(configuration.getBooleanFieldValue("Allow Password Changes"));
        pwdConfig.setEnableRememberMyUsername(configuration.getBooleanFieldValue("Enable 'Remember My Username'"));
        pwdConfig.setAllowUsernameEdits(configuration.getBooleanFieldValue("Allow Username Edits During Chaining"));
        pwdConfig.setTrackAuthenticationTime(configuration.getBooleanFieldValue("Track Authentication Time"));
        pwdConfig.setEnablePasswordExpiryNotification(configuration.getBooleanFieldValue("Show Password Expiring Warning"));
        pwdConfig.setEnableChangePasswordEmailNotification(configuration.getBooleanFieldValue("Change Password Email Notification"));
        pwdConfig.setEnableUsernameRecovery(configuration.getBooleanFieldValue("Enable Username Recovery"));
        pwdConfig.setCaptchaEnabledPasswordChange(configuration.getBooleanFieldValue("CAPTCHA for Password change"));
        pwdConfig.setCaptchaProviderId(configuration.getFieldValue("CAPTCHA Provider"));
        pwdConfig.setNumInvalidAttempts(NumberUtils.toInt((String)configuration.getFieldValue("Challenge Retries"), (int)NumberUtils.toInt((String)"3")));
        pwdConfig.setPwChangeReauthDelay(Integer.parseInt(StringUtils.defaultIfEmpty((String)configuration.getFieldValue("Post-Password Change Re-Authentication Delay"), (String)"0")));
        pwdConfig.setPwmLocation(configuration.getFieldValue("Password Management System"));
        pwdConfig.setChangePasswordTemplateName(StringUtils.defaultIfEmpty((String)configuration.getFieldValue("Change Password Template"), (String)"html.form.change.password.template.html"));
        pwdConfig.setChangePasswordEmailNotificationTemplateName(StringUtils.defaultIfEmpty((String)configuration.getFieldValue("Change Password Email Template"), (String)"message-template-end-user-password-change.html"));
        pwdConfig.setChangePasswordMessageTemplateName(configuration.getFieldValue("Change Password Message Template"));
        pwdConfig.setSessionState(StringUtils.defaultIfEmpty((String)configuration.getFieldValue("Session State"), (String)"None"));
        pwdConfig.setResetType(StringUtils.defaultIfEmpty((String)configuration.getFieldValue("Password Reset Type"), (String)"NONE"));
        pwdConfig.setLoginTemplateName(configuration.getFieldValue("Login Template"));
        pwdConfig.setPasswordExpiryTemplateName(StringUtils.defaultIfEmpty((String)configuration.getFieldValue("Expiring Password Warning Template"), (String)"html.form.password.expiring.notification.template.html"));
        pwdConfig.setRememberUsernameCookieLifetime(NumberUtils.toInt((String)configuration.getFieldValue("'Remember My Username' Lifetime"), (int)Integer.parseInt("30")));
        pwdConfig.setExpiringPasswordWarningThreshold(NumberUtils.toLong((String)configuration.getFieldValue("Threshold for Expiring Password Warning"), (long)7L) * 86400000L);
        pwdConfig.setRequireReAuthenticationForPendingExpiry(configuration.getBooleanFieldValue("Require Re-Authentication For Expiring Password Flow"));
        pwdConfig.setNotificationPublisherId(configuration.getFieldValue("Notification Publisher"));
        String passwordUpdateTimeout = StringUtils.defaultIfEmpty((String)configuration.getFieldValue("Password Update Timeout"), null);
        pwdConfig.setPasswordUpdateTimeout(passwordUpdateTimeout == null ? null : Integer.valueOf(Integer.parseInt(passwordUpdateTimeout)));
        ArrayList<String> pcvIds = new ArrayList<String>();
        for (Row row : configuration.getTable("Credential Validators").getRows()) {
            String pcvId = row.getFieldValue("Password Credential Validator Instance");
            PasswordCredentialValidator pcv = MgmtFactory.getCredentialValidatorManager().getValidator(pcvId);
            boolean changeablePcv = pcv instanceof ChangeablePasswordCredential;
            if (!changeablePcv || !((ChangeablePasswordCredential)pcv).isPasswordChangeable()) continue;
            pcvIds.add(pcvId);
        }
        pwdConfig.setPcvIds(pcvIds);
        pwdConfig.setCookieName(HtmlFormIdpAuthnAdapterUtils.getRememberUsernameCookieName(adapterId));
        pwdConfig.setPolicyContractId(configuration.getFieldValue("Change Password Policy Contract"));
        return pwdConfig;
    }
}

