/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.htmlform.pwdchange.servlet;

import com.pingidentity.access.CaptchaProviderAccessor;
import com.pingidentity.adapters.htmlform.idp.HtmlFormIdpAuthnAdapterUtils;
import com.pingidentity.adapters.htmlform.pwdchange.common.ChangePasswordConfigHelper;
import com.pingidentity.adapters.htmlform.pwdchange.common.ChangePasswordConfiguration;
import com.pingidentity.adapters.htmlform.pwdchange.common.ChangePasswordSessionState;
import com.pingidentity.adapters.htmlform.pwdchange.handler.ChangePasswordHandler;
import com.pingidentity.adapters.htmlform.pwdchange.handler.IdentifyHandler;
import com.pingidentity.adapters.htmlform.pwdchange.model.IdentifyForm;
import com.pingidentity.adapters.htmlform.pwdchange.render.ChangePasswordWithForm;
import com.pingidentity.adapters.htmlform.pwdchange.servlet.AbstractChangePasswordServlet;
import com.pingidentity.adapters.htmlform.pwdchange.type.ChangePasswordResult;
import com.pingidentity.adapters.htmlform.pwdchange.type.IdentifyResult;
import com.pingidentity.adapters.htmlform.pwdmgmt.servlet.AbstractPasswordManagementServlet;
import com.pingidentity.adapters.htmlform.pwdreset.util.PwdResetAuditLogger;
import com.pingidentity.adapters.htmlform.render.handler.ResponseHandler;
import com.pingidentity.adapters.htmlform.render.handler.api.HtmlFormAuthnApiHandler;
import com.pingidentity.adapters.htmlform.render.handler.api.passwordchange.PasswordChangeHandler;
import com.pingidentity.common.util.EscapeUtils;
import com.pingidentity.sdk.api.authn.common.CommonErrorDetailSpec;
import com.pingidentity.sdk.api.authn.common.CommonErrorSpec;
import com.pingidentity.sdk.api.authn.common.CommonStateSpec;
import com.pingidentity.sdk.api.authn.model.AuthnError;
import com.pingidentity.sdk.api.authn.model.AuthnErrorDetail;
import com.pingidentity.sdk.api.authn.model.action.CheckCurrentCredentials;
import com.pingidentity.sdk.api.authn.model.action.CheckNewPassword;
import com.pingidentity.sdk.api.authn.util.AuthnApiSupport;
import com.pingidentity.sdk.api.authn.util.ParamMapping;
import com.pingidentity.sdk.captchaprovider.CaptchaContext;
import com.pingidentity.sdk.captchaprovider.CaptchaProvider;
import com.pingidentity.sdk.captchaprovider.CaptchaResult;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.saml20.profiles.AdapterPathSupport;
import org.sourceid.websso.profiles.ProcessRuntimeException;
import org.sourceid.websso.servlet.reqparam.InvalidRequestParameterException;

public class IdentifyServlet
extends AbstractChangePasswordServlet {
    private static final String ERROR_USER_NAME_BLANK = "usernameBlankError";
    private static final String ERROR_OLD_PASSWORD_BLANK = "oldPasswordBlankError";
    private static final String ERROR_PASSWORD_MISMATCH = "newPasswordMismatchError";
    private static final String ERROR_NEW_PASSWORD_BLANK = "newPasswordBlankError";
    private static final String ERROR_OLD_AND_NEW_PASSWORD_MATCH = "oldAndNewPasswordMatchError";
    private static final String ERROR_ACCOUNT_LOCKED = "accountLockedError";
    private static final String ERROR_CAPTCHA = "captchaError";
    private static final String ERROR_USERNAME_CHANGED = "usernameChangedAfterFirstFactor";
    private static final ParamMapping<CheckNewPassword, String> USERNAME_MAPPING = new ParamMapping("pf.username", CheckNewPassword.class, CheckNewPassword::getUsername, Function.identity());
    private static final ParamMapping<CheckNewPassword, String> PASSWORD_MAPPING = new ParamMapping("pf.pass", CheckNewPassword.class, CheckNewPassword::getExistingPassword, Function.identity());
    private static final ParamMapping<CheckNewPassword, String> NEW_PASSWORD_MAPPING = new ParamMapping("pf.new.pass1", CheckNewPassword.class, CheckNewPassword::getNewPassword, Function.identity());
    private static final ParamMapping<CheckNewPassword, String> NEW_PASSWORD_CONFIRMATION_MAPPING = new ParamMapping("pf.new.pass2", CheckNewPassword.class, CheckNewPassword::getNewPassword, Function.identity());
    private static final ParamMapping<CheckCurrentCredentials, String> USERNAME_MAPPING_POLICY = new ParamMapping("pf.username", CheckCurrentCredentials.class, CheckCurrentCredentials::getUsername, Function.identity());
    private static final ParamMapping<CheckCurrentCredentials, String> PASSWORD_MAPPING_POLICY = new ParamMapping("pf.pass", CheckCurrentCredentials.class, CheckCurrentCredentials::getPassword, Function.identity());
    private static Log logger = LogFactory.getLog(IdentifyServlet.class);

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        logger.debug((Object)"GET Request to /ext/pwdchange/Identify");
        if (!AuthnApiSupport.getDefault().isApiRequest(request) && !this.initializeSessionState(request, response)) {
            ResponseHandler.sendResourceNotFoundResponse(request, response);
            return;
        }
        if (!this.validStage(Arrays.asList(AbstractPasswordManagementServlet.Stage.IDENTIFYING, AbstractPasswordManagementServlet.Stage.AUTHENTICATED), request, response)) {
            this.handleError(request, response, "html.form.message.template.invalidState");
            return;
        }
        this.doShowChangePasswordForm(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        logger.debug((Object)"POST Request to /ext/pwdchange/Identify");
        if (!this.validStage(Arrays.asList(AbstractPasswordManagementServlet.Stage.IDENTIFYING, AbstractPasswordManagementServlet.Stage.AUTHENTICATED), request, response)) {
            this.handleError(request, response, "html.form.message.template.invalidState");
            return;
        }
        this.doSubmitChangePasswordForm(request, response);
    }

    private boolean initializeSessionState(HttpServletRequest request, HttpServletResponse response) {
        boolean internalRedirect;
        boolean bl = internalRedirect = request.getParameter("InternalRedirect") != null;
        if (!internalRedirect) {
            String username;
            String targetResource;
            ChangePasswordSessionState sessionState = ChangePasswordSessionState.create(request, response);
            String adapterId = this.getAdapterIdFromRequest(request);
            if (StringUtils.isNotBlank((String)adapterId)) {
                try {
                    ChangePasswordConfiguration configuration = ChangePasswordConfigHelper.get(adapterId);
                    if (!configuration.isAllowsChangePassword()) {
                        logger.warn((Object)("Password change is not enabled for adapter: " + adapterId));
                        return false;
                    }
                }
                catch (IllegalArgumentException e) {
                    logger.warn((Object)("Invalid adapter ID: " + adapterId));
                    return false;
                }
                sessionState.setAdapterId(adapterId);
            }
            if (StringUtils.isNotBlank((String)(targetResource = request.getParameter("TargetResource")))) {
                if (this.isValidTargetResource(targetResource)) {
                    sessionState.setTargetResource(targetResource);
                } else {
                    logger.warn((Object)("Ignoring specified Target Resource '" + targetResource + "' as it does not pass redirect validation"));
                }
            }
            if (StringUtils.isNotBlank((String)(username = request.getParameter("pf.username")))) {
                sessionState.setUsername(username);
            }
        }
        return true;
    }

    private void doShowChangePasswordForm(HttpServletRequest request, HttpServletResponse response) throws IOException {
        ChangePasswordSessionState state = this.getSessionState(request, response);
        state.refreshPasswordUpdateSession();
        if (this.isAuthnApiDirectLinkPasswordChangeInitialization(request, response, state)) {
            PasswordChangeHandler.createFlowAndRedirectToDefaultAuthnApp(request, response, state);
        } else {
            ChangePasswordWithForm.Builder changePasswordWithFormBuilder = new ChangePasswordWithForm.Builder();
            changePasswordWithFormBuilder.setErrorMessageKeyList(null).setAuthnMessageKey(state.getAuthnMessageKey()).setPwdQualityRequirementMetMsgList(Collections.emptyList()).setPwdQualityRequirementNotMetMsgList(Collections.emptyList()).build().render(request, response);
        }
    }

    private boolean isValidAuthApiPasswordChangeSubmission(HttpServletRequest request, HttpServletResponse response, ChangePasswordSessionState state, ChangePasswordConfiguration configuration) throws IOException {
        boolean isValid = true;
        boolean hasPolicy = StringUtils.isNotBlank((String)configuration.getPolicyContractId());
        if (AuthnApiSupport.getDefault().isApiRequest(request)) {
            if (state.isFromHtmlFormAdapter()) {
                String usernameFromRequest;
                String chainUsername = state.getUsername();
                String string = usernameFromRequest = hasPolicy ? (String)USERNAME_MAPPING_POLICY.getValue(request) : (String)USERNAME_MAPPING.getValue(request);
                if (!configuration.isAllowUsernameEdits() && state.isChainedUsernameAvailable() && chainUsername != null && usernameFromRequest != null && !chainUsername.equals(usernameFromRequest)) {
                    AuthnErrorDetail authnErrorDetail = CommonErrorDetailSpec.PASSWORD_CHANGE_ERROR.makeInstanceBuilder().userMessageKey("authn.api.username.mismatch").build();
                    AuthnError authnError = CommonErrorSpec.VALIDATION_ERROR.makeInstanceBuilder().detail(authnErrorDetail).build();
                    AuthnApiSupport.getDefault().writeErrorResponse(request, response, authnError);
                    isValid = false;
                } else {
                    isValid = HtmlFormAuthnApiHandler.isValidApiPostRequest(request, response, state.getResumeUrl(), null);
                }
            } else if (AbstractPasswordManagementServlet.Stage.AUTHENTICATED.equals((Object)state.getStage())) {
                isValid = HtmlFormAuthnApiHandler.isValidApiPostRequest(request, response, CommonStateSpec.NEW_PASSWORD_REQUIRED);
            } else if (AbstractPasswordManagementServlet.Stage.IDENTIFYING.equals((Object)state.getStage())) {
                if (hasPolicy) {
                    isValid = HtmlFormAuthnApiHandler.isValidApiPostRequest(request, response, CommonStateSpec.CURRENT_CREDENTIALS_REQUIRED);
                } else if (!this.isCancelPasswordChange(request) && StringUtils.isEmpty((String)((String)PASSWORD_MAPPING.getValue(request)))) {
                    AuthnApiSupport.getDefault().writeErrorResponse(request, response, CommonErrorSpec.VALIDATION_ERROR.makeInstanceBuilder().detail(CommonErrorDetailSpec.FIELD_REQUIRED.makeInstanceBuilder().message(String.format("Required field '%s' of type %s is missing.", "existingPassword", "String")).target("existingPassword").build()).build());
                    isValid = false;
                } else {
                    isValid = HtmlFormAuthnApiHandler.isValidApiPostRequest(request, response, CommonStateSpec.NEW_PASSWORD_REQUIRED);
                }
            }
            if (isValid && !this.validStage(AbstractPasswordManagementServlet.Stage.IDENTIFYING, request, response) && !this.validStage(AbstractPasswordManagementServlet.Stage.AUTHENTICATED, request, response)) {
                this.handleError(request, response, "html.form.message.template.invalidState");
            }
        }
        return isValid;
    }

    private boolean isCancelPasswordChange(HttpServletRequest request) {
        return AuthnApiSupport.getDefault().isApiRequest(request) && "cancelPasswordChange".equals(AuthnApiSupport.getDefault().getActionId(request)) || !AuthnApiSupport.getDefault().isApiRequest(request) && StringUtils.isNotBlank((String)request.getParameter("pf.cancel"));
    }

    private void doSubmitChangePasswordForm(HttpServletRequest request, HttpServletResponse response) throws IOException {
        ChangePasswordSessionState state = this.getSessionState(request, response);
        ChangePasswordConfiguration configuration = this.getConfiguration(request, response);
        if (!configuration.isAllowsChangePassword()) {
            throw new ProcessRuntimeException("Password change is not configured for idp adapter: " + state.getAdapterId());
        }
        if (this.isValidAuthApiPasswordChangeSubmission(request, response, state, configuration)) {
            if (this.isCancelPasswordChange(request)) {
                this.doCancel(request, response);
            } else {
                IdentifyForm identifyForm = this.parseRequest(request, response, state);
                PwdResetAuditLogger.init("PWD_CHANGE", request, response);
                PwdResetAuditLogger.setUserName((String)identifyForm.getUsername());
                if (!AuthnApiSupport.getDefault().isApiRequest(request) && !identifyForm.isSubmit()) {
                    logger.debug((Object)"Form was not submitted");
                    this.doCancel(request, response);
                    return;
                }
                boolean isPasswordUpdateTimedOut = state.isPasswordUpdateSessionExpired(configuration.getPasswordUpdateTimeout());
                if (isPasswordUpdateTimedOut) {
                    this.handlePasswordUpdateTimeout(request, response);
                    return;
                }
                if (AbstractPasswordManagementServlet.Stage.AUTHENTICATED.equals((Object)state.getStage())) {
                    if (identifyForm.getErrorList() != null && !identifyForm.getErrorList().isEmpty()) {
                        this.handleResumableError(request, response, identifyForm.getErrorList());
                    } else {
                        this.handleSuccessAction(request, response, state, configuration, identifyForm);
                    }
                    return;
                }
                if (AuthnApiSupport.getDefault().isApiRequest(request) && configuration.isCaptchaEnabledPasswordChange() && identifyForm.isSubmit() && HtmlFormAuthnApiHandler.isMissingAuthnApiCaptchaResponse(request)) {
                    HtmlFormAuthnApiHandler.sendCaptchaResponseMissingResponse(request, response);
                    return;
                }
                this.doCaptcha(request, response, configuration, identifyForm, state);
                if (AuthnApiSupport.getDefault().isApiRequest(request) && identifyForm.getErrorList().contains(ERROR_CAPTCHA)) {
                    PasswordChangeHandler.writeUsernameRecoveryCaptchaFailedResponse(request, response);
                    return;
                }
                if (identifyForm.getErrorList() != null && !identifyForm.getErrorList().isEmpty()) {
                    this.handleResumableError(request, response, identifyForm.getErrorList());
                    return;
                }
                IdentifyHandler identifyHandler = new IdentifyHandler(configuration);
                IdentifyResult identifyResult = identifyHandler.authenticateExistingCredentials(identifyForm, request, response, state);
                switch (identifyResult) {
                    case Authenticated: {
                        state.setUsername(identifyForm.getUsername());
                        if (!StringUtils.isEmpty((String)configuration.getPolicyContractId())) {
                            state.setStage(AbstractPasswordManagementServlet.Stage.AUTHENTICATING);
                            if (AuthnApiSupport.getDefault().isApiRequest(request)) {
                                PasswordChangeHandler.reissueRequestToPasswordChangePolicyServlet(request, response);
                                break;
                            }
                            String path = AdapterPathSupport.convertPath((HttpServletRequest)request, (HttpServletResponse)response, (String)"/ext/pwdchange/Policy");
                            this.redirect(response, path);
                            break;
                        }
                        this.handleSuccessAction(request, response, state, configuration, identifyForm);
                        break;
                    }
                    case NoUsername: {
                        break;
                    }
                    case AccountLocked: {
                        PwdResetAuditLogger.logFailure("User account is locked and cannot change password.");
                        this.handleResumableError(request, response, Arrays.asList(ERROR_ACCOUNT_LOCKED));
                        break;
                    }
                    case UserNotFound: {
                        break;
                    }
                    case Error: {
                        break;
                    }
                    case IncorrectCurrentPassword: {
                        break;
                    }
                    case PasswordExpired: {
                        break;
                    }
                    case Cancel: {
                        break;
                    }
                }
            }
        }
    }

    private void handleSuccessAction(HttpServletRequest request, HttpServletResponse response, ChangePasswordSessionState state, ChangePasswordConfiguration configuration, IdentifyForm identifyForm) throws IOException {
        ChangePasswordHandler changePasswordHandler = new ChangePasswordHandler(configuration);
        ChangePasswordResult changePasswordResult = changePasswordHandler.changePassword(identifyForm, request, response);
        if (ChangePasswordResult.Success.equals((Object)changePasswordResult)) {
            state.setSuccess(true);
            if (configuration.isEnablePasswordExpiryNotification()) {
                HtmlFormIdpAuthnAdapterUtils.addCookie("pf-hfa-exp-pwd", "", 0, response);
            }
            ChangePasswordSessionState passwordManagementSessionState = this.getSessionState(request, response);
            passwordManagementSessionState.setSuccessAuthenticationStageCompleted();
            String successEndpoint = AdapterPathSupport.convertPath((HttpServletRequest)request, (HttpServletResponse)response, (String)"/ext/pwdchange/Success");
            if (AuthnApiSupport.getDefault().isApiRequest(request)) {
                PasswordChangeHandler.reissueRequestToPasswordChangeSuccessServlet(request, response);
            } else {
                response.sendRedirect(successEndpoint);
            }
        } else if (!response.isCommitted()) {
            this.handleError(request, response, "html.form.message.template.unknownError");
        }
    }

    private void doCaptcha(HttpServletRequest req, HttpServletResponse response, ChangePasswordConfiguration configuration, IdentifyForm identifyForm, ChangePasswordSessionState state) {
        if (identifyForm.isSubmit() && configuration.isCaptchaEnabledPasswordChange()) {
            CaptchaProvider captchaProvider = CaptchaProviderAccessor.getCaptchaProvider((String)configuration.getCaptchaProviderId());
            Map<String, Object> parameters = this.getCaptchaProviderInParams(req, response, state);
            parameters.put("com.pingidentity.adapter.input.parameter.userid", EscapeUtils.escape((String)identifyForm.getUsername()));
            parameters.put("com.pingidentity.adapter.input.parameter.userid.authenticated", false);
            CaptchaContext context = new CaptchaContext.Builder().setRequest(req).setResponse(response).setAction("passwordChange").setInParameters(parameters).build();
            CaptchaResult captchaResult = captchaProvider.validateCaptcha(context);
            boolean isValid = captchaResult.isValid();
            if (!isValid) {
                logger.debug((Object)"Login failed: reCAPTCHA validation failure.");
                identifyForm.getErrorList().add(ERROR_CAPTCHA);
            }
        }
    }

    private void handlePasswordUpdateTimeout(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String errorMsg = "Password update timed out.";
        logger.debug((Object)errorMsg);
        PwdResetAuditLogger.logFailure(errorMsg);
        PwdResetAuditLogger.cleanupAuthnAttempt();
        this.handleError(req, resp, "html.form.change.password.template.passwordUpdateTimeoutError");
    }

    private IdentifyForm parseRequest(HttpServletRequest req, HttpServletResponse resp, ChangePasswordSessionState state) throws InvalidRequestParameterException {
        String password;
        String username;
        IdentifyForm identifyForm = new IdentifyForm();
        String newPassword1 = (String)NEW_PASSWORD_MAPPING.getValue(req);
        String newPassword2 = (String)NEW_PASSWORD_CONFIRMATION_MAPPING.getValue(req);
        ChangePasswordConfiguration configuration = this.getConfiguration(req, resp);
        boolean hasPolicy = StringUtils.isNotEmpty((String)configuration.getPolicyContractId());
        boolean isAuthenticated = AbstractPasswordManagementServlet.Stage.AUTHENTICATED.equals((Object)state.getStage());
        if (isAuthenticated) {
            username = state.getUsername();
            password = state.getCurrentPassword();
            if (StringUtils.isNotEmpty((String)((String)USERNAME_MAPPING.getValue(req))) && !StringUtils.equals((String)username, (String)((String)USERNAME_MAPPING.getValue(req))) || StringUtils.isNotEmpty((String)((String)PASSWORD_MAPPING.getValue(req))) && !StringUtils.equals((String)password, (String)((String)PASSWORD_MAPPING.getValue(req)))) {
                identifyForm.getErrorList().add(ERROR_USERNAME_CHANGED);
            }
        } else {
            if (hasPolicy) {
                username = (String)USERNAME_MAPPING_POLICY.getValue(req);
                password = (String)PASSWORD_MAPPING_POLICY.getValue(req);
            } else {
                username = (String)USERNAME_MAPPING.getValue(req);
                password = (String)PASSWORD_MAPPING.getValue(req);
            }
            if (StringUtils.isBlank((String)username)) {
                identifyForm.getErrorList().add(ERROR_USER_NAME_BLANK);
            }
            if (state.isChainedUsernameAvailable()) {
                if (!configuration.isAllowUsernameEdits() && !StringUtils.equals((String)username, (String)state.getUsername())) {
                    identifyForm.getErrorList().add(ERROR_USERNAME_CHANGED);
                }
            } else if (StringUtils.isNotEmpty((String)state.getUsername()) && !StringUtils.equals((String)username, (String)state.getUsername())) {
                identifyForm.getErrorList().add(ERROR_USERNAME_CHANGED);
            }
        }
        if ((!hasPolicy || AbstractPasswordManagementServlet.Stage.IDENTIFYING.equals((Object)state.getStage())) && StringUtils.isBlank((String)password)) {
            identifyForm.getErrorList().add(ERROR_OLD_PASSWORD_BLANK);
        }
        if (!hasPolicy || isAuthenticated) {
            if (StringUtils.isBlank((String)newPassword1) || StringUtils.isBlank((String)newPassword2)) {
                identifyForm.getErrorList().add(ERROR_NEW_PASSWORD_BLANK);
            }
            if (!StringUtils.equals((String)newPassword1, (String)newPassword2)) {
                identifyForm.getErrorList().add(ERROR_PASSWORD_MISMATCH);
            }
            if (StringUtils.equals((String)password, (String)newPassword1) || StringUtils.equals((String)password, (String)newPassword2)) {
                identifyForm.getErrorList().add(ERROR_OLD_AND_NEW_PASSWORD_MATCH);
            }
        }
        identifyForm.setUsername(username);
        identifyForm.setCurrentPassword(password);
        identifyForm.setNewPassword(newPassword1);
        identifyForm.setConfirmNewPassword(newPassword2);
        identifyForm.setSubmit("clicked".equals(req.getParameter("pf.ok")) || AuthnApiSupport.getDefault().isApiRequest(req));
        return identifyForm;
    }

    private boolean isAuthnApiDirectLinkPasswordChangeInitialization(HttpServletRequest request, HttpServletResponse response, ChangePasswordSessionState state) {
        return this.redirectToDefaultAuthnApp(request, response) && !AbstractPasswordManagementServlet.Stage.AUTHENTICATED.equals((Object)state.getStage());
    }
}

