/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.htmlform.pwdreset.common;

import com.pingidentity.adapters.htmlform.idp.HtmlFormIdpAuthnAdapter;
import com.pingidentity.adapters.htmlform.idp.HtmlFormIdpAuthnAdapterUtils;
import com.pingidentity.adapters.htmlform.pwdreset.common.PasswordResetConfiguration;
import com.pingidentity.sdk.account.AccountUnlockablePasswordCredential;
import com.pingidentity.sdk.password.PasswordCredentialValidator;
import com.pingidentity.sdk.password.ResettablePasswordCredential;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.adapter.conf.Row;
import org.sourceid.saml20.adapter.conf.Table;
import org.sourceid.saml20.domain.IdpAuthnAdapterInstance;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public final class PasswordResetConfigHelper {
    private static final Log logger = LogFactory.getLog(PasswordResetConfigHelper.class);

    private PasswordResetConfigHelper() {
    }

    public static PasswordResetConfiguration get(String adapterId) {
        return PasswordResetConfigHelper.createPasswordManagementConfiguration(adapterId);
    }

    private static PasswordResetConfiguration createPasswordManagementConfiguration(String adapterId) {
        PasswordResetConfiguration pwdConfig;
        block7: {
            IdpAuthnAdapterInstance instance = (IdpAuthnAdapterInstance)MgmtFactory.getIdpAdapterManager().getInstance(adapterId);
            if (instance == null) {
                throw new IllegalArgumentException("Adapter ID " + adapterId + " does not exist");
            }
            pwdConfig = new PasswordResetConfiguration(adapterId);
            Configuration configuration = instance.getRuntimeCompositeConfiguration();
            pwdConfig.setUsernameTemplate(StringUtils.defaultIfEmpty((String)configuration.getFieldValue("Password Reset Username Template"), (String)"forgot-password.html"));
            pwdConfig.setCodeTemplate(StringUtils.defaultIfEmpty((String)configuration.getFieldValue("Password Reset Code Template"), (String)"forgot-password-resume.html"));
            pwdConfig.setChangeTemplate(StringUtils.defaultIfEmpty((String)configuration.getFieldValue("Password Reset Template"), (String)"forgot-password-change.html"));
            pwdConfig.setErrorTemplate(StringUtils.defaultIfEmpty((String)configuration.getFieldValue("Password Reset Error Template"), (String)"forgot-password-error.html"));
            pwdConfig.setSuccessTemplate(StringUtils.defaultIfEmpty((String)configuration.getFieldValue("Password Reset Success Template"), (String)"forgot-password-success.html"));
            pwdConfig.setResetType(StringUtils.defaultIfEmpty((String)configuration.getFieldValue("Password Reset Type"), (String)"NONE"));
            pwdConfig.setCodeNumberOfCharacters(NumberUtils.toInt((String)configuration.getFieldValue("OTP Length"), (int)NumberUtils.toInt((String)"8")));
            pwdConfig.setOTPAllowedChars(StringUtils.defaultIfEmpty((String)configuration.getFieldValue("Allowed OTP Character Set"), (String)"23456789BCDFGHJKMNPQRSTVWXZbcdfghjkmnpqrstvwxz"));
            pwdConfig.setExpirationMinutes(NumberUtils.toInt((String)configuration.getFieldValue("OTP Time to Live"), (int)NumberUtils.toInt((String)"10")));
            pwdConfig.setNumInvalidAttempts(NumberUtils.toInt((String)configuration.getFieldValue("Challenge Retries"), (int)NumberUtils.toInt((String)"3")));
            pwdConfig.setEnableRememberMyUsername(configuration.getBooleanFieldValue("Enable 'Remember My Username'"));
            pwdConfig.setRememberMyUsernameCookieName(HtmlFormIdpAuthnAdapterUtils.getRememberUsernameCookieName(configuration.getId()));
            pwdConfig.setEnableCaptcha(configuration.getBooleanFieldValue("CAPTCHA for Password Reset"));
            pwdConfig.setCaptchaProviderId(configuration.getFieldValue("CAPTCHA Provider"));
            pwdConfig.setRequireVerifiedEmail(configuration.getBooleanFieldValue("Require Verified Email"));
            pwdConfig.setResetPolicyContractId(configuration.getFieldValue("Password Reset Policy Contract"));
            pwdConfig.setNotificationPublisherId(configuration.getFieldValue("Notification Publisher"));
            pwdConfig.setEnableUsernameRecovery(configuration.getBooleanFieldValue("Enable Username Recovery"));
            pwdConfig.setPwdResetOTLEmailNotificationTemplate(StringUtils.defaultIfEmpty((String)configuration.getFieldValue("Password Reset One-Time Link Email Template"), (String)"message-template-forgot-password-link.html"));
            pwdConfig.setPwdResetOTPEmailNotificationTemplate(StringUtils.defaultIfEmpty((String)configuration.getFieldValue("Password Reset One-Time Password Email Template"), (String)"message-template-forgot-password-code.html"));
            pwdConfig.setAccountDisabledEmailNotificationTemplate(StringUtils.defaultIfEmpty((String)configuration.getFieldValue("Account Disabled Email Template"), (String)"message-template-account-disabled.html"));
            pwdConfig.setPwdResetCompleteEmailNotificationTemplate(StringUtils.defaultIfEmpty((String)configuration.getFieldValue("Password Reset Complete Email Template"), (String)"message-template-forgot-password-complete.html"));
            pwdConfig.setPwdResetFailureEmailNotificationTemplate(StringUtils.defaultIfEmpty((String)configuration.getFieldValue("Password Reset Failed Email Template"), (String)"message-template-forgot-password-failed.html"));
            pwdConfig.setAccountUnlockEmailNotificationTemplate(StringUtils.defaultIfEmpty((String)configuration.getFieldValue("Account Unlock Email Template"), (String)"message-template-account-unlock-complete.html"));
            String passwordUpdateTimeout = StringUtils.defaultIfEmpty((String)configuration.getFieldValue("Password Update Timeout"), null);
            pwdConfig.setPasswordUpdateTimeout(passwordUpdateTimeout == null ? null : Integer.valueOf(Integer.parseInt(passwordUpdateTimeout)));
            int rememberUsernameCookieLifetime = HtmlFormIdpAuthnAdapter.getRememberUsernameCookieLifetime(NumberUtils.toInt((String)configuration.getFieldValue("'Remember My Username' Lifetime"), (int)Integer.parseInt("30")));
            pwdConfig.setRememberMyUsernameCookieLifetime(rememberUsernameCookieLifetime);
            boolean enableAccountUnlock = configuration.getBooleanFieldValue("Account Unlock");
            pwdConfig.setEnableAccountUnlock(enableAccountUnlock);
            pwdConfig.setUnlockTemplate(StringUtils.defaultIfEmpty((String)configuration.getFieldValue("Account Unlock Template"), (String)"account-unlock.html"));
            ArrayList<String> pcvIds = new ArrayList<String>();
            Table table = configuration.getTable("Credential Validators");
            if (table != null) {
                for (Row row : table.getRows()) {
                    String pcvId = row.getFieldValue("Password Credential Validator Instance");
                    PasswordCredentialValidator pcv = MgmtFactory.getCredentialValidatorManager().getValidator(pcvId);
                    boolean resettablePcv = pcv instanceof ResettablePasswordCredential;
                    boolean unlockable = pcv instanceof AccountUnlockablePasswordCredential;
                    if (!resettablePcv || !((ResettablePasswordCredential)pcv).isPasswordResettable()) continue;
                    pcvIds.add(pcvId);
                    if (!enableAccountUnlock || !unlockable) continue;
                    ((AccountUnlockablePasswordCredential)pcv).isAccountUnlockable();
                }
            }
            pwdConfig.setPcvIds(pcvIds);
            pwdConfig.setReAuthenticateAfterPasswordReset(configuration.getBooleanFieldValue("Require Re-Authentication for Password Reset Flow", true));
            byte[] pingidPropertiesBytes = configuration.getFileFieldValueAsByteArray("PingID Properties");
            Properties pingidProperties = new Properties();
            try {
                if (pingidPropertiesBytes != null && pingidPropertiesBytes.length > 0) {
                    pingidProperties.load(new ByteArrayInputStream(pingidPropertiesBytes));
                    if (!pingidProperties.isEmpty()) {
                        pwdConfig.setPingIdBase64Key(pingidProperties.getProperty("use_base64_key"));
                        pwdConfig.setPingIdToken(pingidProperties.getProperty("token"));
                        pwdConfig.setPingIdOrgAlias(pingidProperties.getProperty("org_alias"));
                        pwdConfig.setPingIdAdminUrl(pingidProperties.getProperty("admin_url"));
                        pwdConfig.setPingIdAuthenticatorUrl(pingidProperties.getProperty("authenticator_url"));
                    }
                }
            }
            catch (IOException ioe) {
                logger.error((Object)("An error has occurred when loading PingID configuration : " + ioe.getMessage()));
                if (!logger.isDebugEnabled()) break block7;
                logger.debug((Object)("An error has occurred when loading PingID configuration : " + ioe.getMessage()), (Throwable)ioe);
            }
        }
        return pwdConfig;
    }
}

