/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.htmlform.pwdreset.handler;

import com.pingidentity.adapters.htmlform.pwdreset.common.PasswordResetConfiguration;
import com.pingidentity.adapters.htmlform.pwdreset.handler.BaseHandler;
import com.pingidentity.adapters.htmlform.pwdreset.model.IdentifyForm;
import com.pingidentity.adapters.htmlform.pwdreset.type.IdentifyResult;
import com.pingidentity.adapters.htmlform.render.TemplateKey;
import com.pingidentity.common.util.CodeGenerationUtil;
import com.pingidentity.email.util.NotificationSupportHelper;
import com.pingidentity.locale.LocaleUtil;
import com.pingidentity.pf.sms.SmsSettings;
import com.pingidentity.sdk.api.authn.common.CommonActionSpec;
import com.pingidentity.sdk.api.authn.internal.InternalAuthnApiSupport;
import com.pingidentity.sdk.api.authn.util.AuthnApiSupport;
import com.pingidentity.sdk.password.ResettablePasswordCredential;
import com.pingidentity.sms.helper.SmsHelper;
import com.pingidentity.templates.mgmt.TemplateParamUtil;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.sourceid.common.IDGenerator;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.oauth20.protocol.Parameters;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.domain.AuthnApiApplication;
import org.sourceid.saml20.domain.NotificationSettings;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.util.plugin.AdapterDefaultTemplateParams;
import org.sourceid.token.PFInternalTokenGenerator;
import org.sourceid.token.PFInternalTokenTranslator;
import org.sourceid.token.jwt.JwtTokenGeneratorImpl;
import org.sourceid.token.jwt.PFInternalTokenException;
import org.sourceid.token.jwt.PFResetPasswordtoJwtTranslator;
import org.sourceid.util.log.AttributeMap;
import org.sourceid.websso.authn.AuthnApiPolicyUtil;
import org.sourceid.websso.servlet.reqparam.InvalidRequestParameterException;

public class IdentifyHandler
extends BaseHandler {
    private static final Logger logger = LogManager.getLogger(IdentifyHandler.class);
    private final PFInternalTokenGenerator pfInternalTokenGenerator = new JwtTokenGeneratorImpl((PFInternalTokenTranslator)new PFResetPasswordtoJwtTranslator());
    private static final String REDIRECTLESS_OTL_RESUME_TO_TEMPLATE = "redirectless-otl-resume-to-template";
    private final ConfigStore configStore = ConfigStoreFarm.getConfig((String)"com.pingidentity.adapters.htmlform.pwdreset.handler.IdentifyHandler");

    public IdentifyHandler(PasswordResetConfiguration configuration, HttpServletRequest request, HttpServletResponse response) {
        super(configuration, request, response);
    }

    public IdentifyResult validateUsername(IdentifyForm identifyForm, HttpServletRequest request) {
        if (this.isUsernameRecovery(request)) {
            return IdentifyResult.RecoverUsername;
        }
        if (!identifyForm.isSubmit()) {
            logger.debug("Form was not submitted");
            return IdentifyResult.Cancel;
        }
        if (identifyForm.getUsername() == null || identifyForm.getUsername().isEmpty()) {
            logger.debug("No Username found in the form data");
            return IdentifyResult.NoUsername;
        }
        AttributeMap userAttributes = null;
        String selectedPcvId = null;
        for (String pcvId : this.configuration.getPcvIds()) {
            try {
                userAttributes = this.getAttributes(identifyForm.getUsername(), pcvId);
                if (userAttributes == null) continue;
                selectedPcvId = pcvId;
                break;
            }
            catch (Exception e) {
                logger.error("Error retrieving user attributes. " + e.getMessage(), (Throwable)e);
                return null;
            }
        }
        CodeGenerationUtil.GeneratedCode gc = null;
        String referenceId = null;
        String adapterId = this.sessionState.getAdapterId();
        if ("OTL".equals(this.configuration.getResetType()) && userAttributes != null) {
            String code = adapterId + ":" + selectedPcvId + ":" + IDGenerator.rndAlphaNumeric((int)22);
            AttributeMap attrs = new AttributeMap();
            Map<String, Object> defaultParams = this.sessionState.getDefaultTemplateParams();
            List<String> topLevelTemplateParams = Arrays.asList(AdapterDefaultTemplateParams.ENTITY_ID.getParamName(), AdapterDefaultTemplateParams.CLIENT_ID.getParamName());
            if (defaultParams != null) {
                for (Map.Entry<String, Object> defaultParamEntry : defaultParams.entrySet()) {
                    if (!topLevelTemplateParams.contains(defaultParamEntry.getKey())) continue;
                    attrs.put(defaultParamEntry.getKey(), new AttributeValue((String)defaultParamEntry.getValue()));
                }
            }
            attrs.put("prCodeMapCode", new AttributeValue(code));
            attrs.put("prUsername", new AttributeValue(identifyForm.getUsername()));
            attrs.put("pcvId", new AttributeValue(selectedPcvId));
            attrs.put("adapterId", new AttributeValue(adapterId));
            attrs.put("prEnableRememberUsername", new AttributeValue(Boolean.toString(this.getSessionState().isRememberUsername())));
            attrs.put("prExpTime", new AttributeValue(String.valueOf(DateUtils.addMinutes((Date)new Date(), (int)this.configuration.getExpirationMinutes()).getTime())));
            this.checkAddAuthnApiAppIdToAttributes(request, attrs);
            this.sessionState.setCodeAttributeMap(attrs);
            try {
                referenceId = this.pfInternalTokenGenerator.encrypt((Map)attrs);
            }
            catch (PFInternalTokenException e) {
                throw new InvalidRequestParameterException(e.getMessage());
            }
        } else {
            gc = "SMS".equals(this.configuration.getResetType()) ? CodeGenerationUtil.generateSmsCode((int)this.configuration.getCodeNumberOfCharacters()) : CodeGenerationUtil.generateOtp((int)this.configuration.getCodeNumberOfCharacters(), (String)this.configuration.getOTPAllowedChars());
            AttributeMap attributeMap = new AttributeMap();
            attributeMap.put("prCodeMapCode", gc.getEncodedCode());
            attributeMap.put("prCodeMapTime", gc.getTimeGenerated());
            this.getSessionState().setCodeAttributeMap(attributeMap);
            this.getSessionState().setUsername(identifyForm.getUsername());
            this.getSessionState().setPcvId(selectedPcvId);
        }
        if (userAttributes == null) {
            logger.debug("Attributes not found for user: " + identifyForm.getUsername());
            return IdentifyResult.UserNotFound;
        }
        Locale locale = LocaleUtil.getUserLocale((HttpServletRequest)request);
        return this.doReset(identifyForm, userAttributes, gc, referenceId, selectedPcvId, locale);
    }

    private void checkAddAuthnApiAppIdToAttributes(HttpServletRequest request, AttributeMap attrs) {
        if (AuthnApiSupport.getDefault().isApiRequest(request)) {
            this.getSessionState().setAuthnApiFlowId(AuthnApiSupport.getDefault().getFlowId(request.getPathInfo()));
            Map stateParams = InternalAuthnApiSupport.getDefault().getStateParams(request);
            if (AuthnApiPolicyUtil.getDefault().isRedirectlessApiFlow(stateParams) && !this.configStore.getBooleanValue(REDIRECTLESS_OTL_RESUME_TO_TEMPLATE, false)) {
                AuthnApiApplication authnApiApplication;
                String authnApiAppId = (String)stateParams.get("currentAuthnApiApp");
                if (authnApiAppId != null && (authnApiApplication = MgmtFactory.getAuthnApiManager().getApiApplication(authnApiAppId)) != null) {
                    boolean authnApiAppAllowed = false;
                    if (MgmtFactory.getAuthnApiManager().getSettings().isRestrictAccessToRedirectlessMode()) {
                        if (authnApiApplication.getClientIdForRedirectlessMode() != null && authnApiApplication.getClientIdForRedirectlessMode().equals(stateParams.get(Parameters.CLIENT_ID))) {
                            authnApiAppAllowed = true;
                        } else if (logger.isDebugEnabled()) {
                            logger.debug("Will not save policy's authn API application (" + authnApiApplication.getName() + ") to use later, as flow is redirectless and client ID for flow (" + stateParams.get(Parameters.CLIENT_ID) + ") does not match the one configured for the authn API application");
                        }
                    } else {
                        authnApiAppAllowed = true;
                    }
                    if (authnApiAppAllowed) {
                        attrs.put("prAuthnApiAppID", new AttributeValue(authnApiAppId));
                    }
                }
            } else {
                attrs.put("prAuthnApiAppID", new AttributeValue(InternalAuthnApiSupport.getDefault().getAuthnApiAppId(request)));
            }
        }
    }

    private boolean isUsernameRecovery(HttpServletRequest request) {
        boolean isUsernameRecoveryTemplateButtonClicked = request.getParameter("pf.usernamerecovery") != null && "clicked".equals(request.getParameter("pf.usernamerecovery"));
        boolean isAuthnApiUsernameRecovery = AuthnApiSupport.getDefault().isApiRequest(request) && CommonActionSpec.RECOVER_USERNAME.isRequested(request);
        return isUsernameRecoveryTemplateButtonClicked || isAuthnApiUsernameRecovery;
    }

    private IdentifyResult doReset(IdentifyForm identifyForm, AttributeMap userAttributes, CodeGenerationUtil.GeneratedCode generatedCode, String referenceId, String pcvId, Locale locale) {
        switch (this.configuration.getResetType()) {
            case "OTL": {
                return this.sendOneTimeLink(identifyForm, userAttributes, referenceId, pcvId, locale);
            }
            case "OTP": {
                return this.sendOneTimePassword(identifyForm, userAttributes, generatedCode, pcvId, locale);
            }
            case "PingID": {
                return IdentifyResult.PingID;
            }
            case "SMS": {
                return this.sendTextMessage(identifyForm, userAttributes, generatedCode, pcvId, locale);
            }
            case "POLICY": {
                return IdentifyResult.Policy;
            }
        }
        return IdentifyResult.Error;
    }

    private IdentifyResult sendOneTimePassword(IdentifyForm identifyForm, AttributeMap userAttributes, CodeGenerationUtil.GeneratedCode generatedCode, String pcvId, Locale locale) {
        logger.debug("Starting Reset flow using OTP");
        ResettablePasswordCredential pcv = this.getPcv(pcvId);
        String email = userAttributes.getSingleValue(pcv.getMailAttribute());
        Map<String, Object> templateParams = this.getSessionState().getDefaultTemplateParams();
        templateParams.put(TemplateKey.USER_ATTRIBUTES.getKey(), TemplateParamUtil.convertAttributeMapToTemplateParams((AttributeMap)userAttributes));
        if (email != null && !email.isEmpty()) {
            String name = userAttributes.getSingleValue(pcv.getNameAttribute());
            if (name == null || name.isEmpty()) {
                name = identifyForm.getUsername();
            }
            boolean isEmailVerified = !this.configuration.isRequireVerifiedEmail() || Boolean.parseBoolean(userAttributes.getSingleValue(pcv.getMailVerifiedAttribute()));
            boolean isAccountDisabled = this.isAccountDisabled(pcv, userAttributes);
            if (isEmailVerified && isAccountDisabled) {
                this.sendAccountDisabledNotification(email, name, pcvId, locale, identifyForm);
                return IdentifyResult.AccountDisabledCodeNotSent;
            }
            if (isEmailVerified) {
                NotificationSupportHelper notificationSupportHelper = new NotificationSupportHelper();
                notificationSupportHelper.sendPasswordResetCode(email, name, generatedCode.getCode(), this.configuration.getAdapterId(), pcvId, locale, this.configuration.getNotificationPublisherId(), this.configuration.getPwdResetOTPEmailNotificationTemplate(), templateParams);
                if (logger.isDebugEnabled()) {
                    logger.debug("Reset OTP email queued to be sent to " + identifyForm.getUsername() + " at " + email);
                }
                return IdentifyResult.CodeSent;
            }
            logger.error("Email was not sent to '" + identifyForm.getUsername() + "' as '" + email + "' is not verified.");
            return IdentifyResult.EmailUnverifiedCodeNotSent;
        }
        logger.error("No email address found in directory for user: " + identifyForm.getUsername());
        return IdentifyResult.NoEmailAddress;
    }

    private IdentifyResult sendOneTimeLink(IdentifyForm identifyForm, AttributeMap userAttributes, String referenceId, String pcvId, Locale locale) {
        logger.debug("Starting Reset flow using OTL");
        ResettablePasswordCredential pcv = this.getPcv(pcvId);
        String email = userAttributes.getSingleValue(pcv.getMailAttribute());
        Map<String, Object> templateParams = this.getSessionState().getDefaultTemplateParams();
        templateParams.put(TemplateKey.USER_ATTRIBUTES.getKey(), TemplateParamUtil.convertAttributeMapToTemplateParams((AttributeMap)userAttributes));
        if (email != null && !email.isEmpty()) {
            String name = userAttributes.getSingleValue(pcv.getNameAttribute());
            if (name == null || name.isEmpty()) {
                name = identifyForm.getUsername();
            }
            try {
                boolean isEmailVerified = !this.configuration.isRequireVerifiedEmail() || Boolean.parseBoolean(userAttributes.getSingleValue(pcv.getMailVerifiedAttribute()));
                boolean isAccountDisabled = this.isAccountDisabled(pcv, userAttributes);
                if (isEmailVerified && isAccountDisabled) {
                    this.sendAccountDisabledNotification(email, name, pcvId, locale, identifyForm);
                    return IdentifyResult.AccountDisabledLinkNotSent;
                }
                if (isEmailVerified) {
                    NotificationSupportHelper notificationSupportHelper = new NotificationSupportHelper();
                    notificationSupportHelper.sendPasswordResetOneTimeLink(email, name, referenceId, "/ext/pwdreset/Resume", this.configuration.getAdapterId(), pcvId, locale, this.configuration.getNotificationPublisherId(), this.configuration.getPwdResetOTLEmailNotificationTemplate(), templateParams);
                    if (logger.isDebugEnabled()) {
                        logger.debug("Reset OTL email queued to be sent to " + identifyForm.getUsername() + " at " + email);
                    }
                    return IdentifyResult.LinkSent;
                }
                logger.error("Email was not sent to '" + identifyForm.getUsername() + "' as '" + email + "' is not verified.");
                return IdentifyResult.EmailUnverifiedLinkNotSent;
            }
            catch (Exception e) {
                logger.error("Error occurred while sending password reset link", (Throwable)e);
                return IdentifyResult.Error;
            }
        }
        logger.error("No email address found in directory for user: " + identifyForm.getUsername());
        return IdentifyResult.NoEmailAddress;
    }

    private IdentifyResult sendTextMessage(IdentifyForm identifyForm, AttributeMap userAttributes, CodeGenerationUtil.GeneratedCode generatedCode, String pcvId, Locale locale) {
        logger.debug("Starting Reset flow using SMS");
        ResettablePasswordCredential pcv = this.getPcv(pcvId);
        String toNumber = userAttributes.getSingleValue(pcv.getSmsAttribute());
        if (toNumber != null && !toNumber.isEmpty() && generatedCode != null && StringUtils.isNotEmpty((String)generatedCode.getCode())) {
            NotificationSettings settings = MgmtFactory.getNotificationMgr().getNotificationSettings();
            SmsSettings smsInfo = new SmsSettings(settings.getSmsAccountId(), settings.getSmsAuthToken(), settings.getSmsFromNumber());
            SmsHelper smsHelper = new SmsHelper(smsInfo);
            smsHelper.sendPasswordResetCode(generatedCode.getCode(), toNumber, locale);
            logger.debug("Request sent to SMS service for: " + identifyForm.getUsername() + " at number " + toNumber);
            return IdentifyResult.SmsServiceRequestSent;
        }
        logger.debug("No mobile phone found for user: " + identifyForm.getUsername());
        return IdentifyResult.NoMobilePhone;
    }

    private void sendAccountDisabledNotification(String email, String name, String pcvId, Locale locale, IdentifyForm identifyForm) {
        NotificationSupportHelper notificationSupportHelper = new NotificationSupportHelper();
        notificationSupportHelper.sendAccountDisabled(email, name, this.configuration.getAdapterId(), pcvId, locale, this.configuration.getNotificationPublisherId(), this.configuration.getAccountDisabledEmailNotificationTemplate());
        if (logger.isDebugEnabled()) {
            logger.debug("Account disabled email queued to be sent to " + identifyForm.getUsername() + " at " + email);
        }
    }

    private boolean isAccountDisabled(ResettablePasswordCredential pcv, AttributeMap attributeMap) {
        return ResettablePasswordCredential.AccountEnabledStatus.DISABLED.equals((Object)pcv.getAccountEnabledStatus(attributeMap));
    }
}

