/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.htmlform.pwdreset.servlet;

import com.pingidentity.access.CaptchaProviderAccessor;
import com.pingidentity.adapters.htmlform.idp.HtmlFormIdpAuthnAdapter;
import com.pingidentity.adapters.htmlform.idrecovery.common.RecoverUsernameSessionState;
import com.pingidentity.adapters.htmlform.pwdmgmt.servlet.AbstractPasswordManagementServlet;
import com.pingidentity.adapters.htmlform.pwdreset.common.PasswordResetConfiguration;
import com.pingidentity.adapters.htmlform.pwdreset.common.PasswordResetSessionState;
import com.pingidentity.adapters.htmlform.pwdreset.handler.IdentifyHandler;
import com.pingidentity.adapters.htmlform.pwdreset.model.IdentifyForm;
import com.pingidentity.adapters.htmlform.pwdreset.servlet.AbstractPasswordResetServlet;
import com.pingidentity.adapters.htmlform.pwdreset.type.IdentifyResult;
import com.pingidentity.adapters.htmlform.pwdreset.util.PwdResetAuditLogger;
import com.pingidentity.adapters.htmlform.pwdreset.util.UrlUtil;
import com.pingidentity.adapters.htmlform.render.TemplateKey;
import com.pingidentity.adapters.htmlform.render.handler.ResponseHandler;
import com.pingidentity.adapters.htmlform.render.handler.api.HtmlFormAuthnApiHandler;
import com.pingidentity.adapters.htmlform.render.handler.api.passwordreset.ApiPasswordResetUsernameRequiredHandler;
import com.pingidentity.adapters.htmlform.render.handler.api.passwordreset.PasswordResetHandler;
import com.pingidentity.adapters.htmlform.render.util.CaptchaProviderRenderUtil;
import com.pingidentity.common.util.CrossSiteRequestForgeryHelper;
import com.pingidentity.common.util.EscapeUtils;
import com.pingidentity.common.util.TrackedParamsUtil;
import com.pingidentity.sdk.api.authn.common.CommonActionSpec;
import com.pingidentity.sdk.api.authn.model.action.CheckAccountRecoveryUsername;
import com.pingidentity.sdk.api.authn.util.AuthnApiSupport;
import com.pingidentity.sdk.api.authn.util.ParamMapping;
import com.pingidentity.sdk.captchaprovider.CaptchaContext;
import com.pingidentity.sdk.captchaprovider.CaptchaProvider;
import com.pingidentity.sdk.captchaprovider.CaptchaResult;
import java.io.IOException;
import java.util.Map;
import java.util.function.Function;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.websso.profiles.ProcessRuntimeException;
import org.sourceid.websso.servlet.reqparam.InvalidRequestParameterException;

public class IdentifyServlet
extends AbstractPasswordResetServlet {
    private static final Log logger = LogFactory.getLog(IdentifyServlet.class);
    private static final ParamMapping<CheckAccountRecoveryUsername, String> USERNAME_MAPPING = new ParamMapping("username", CheckAccountRecoveryUsername.class, CheckAccountRecoveryUsername::getUsername, Function.identity());

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        logger.debug((Object)"GET Request to /ext/pwdreset/Identify");
        if (!AuthnApiSupport.getDefault().isApiRequest(request)) {
            this.initializeSessionState(request, response);
        }
        if (!this.validStage(AbstractPasswordManagementServlet.Stage.IDENTIFYING, request, response)) {
            this.handleError(request, response, "forgot-password-error.invalidState");
            return;
        }
        Map<String, Object> defaultParams = this.getDefaultTemplateParams(request, response);
        String cSRFToken = CrossSiteRequestForgeryHelper.getCSRFToken((HttpServletRequest)request, (HttpServletResponse)response);
        defaultParams.put(TemplateKey.CSRF_TOKEN.getKey(), cSRFToken);
        String username = this.getUsername(request, response);
        if (username != null && !username.isEmpty()) {
            defaultParams.put(TemplateKey.SAVED_USERNAME.getKey(), EscapeUtils.escape((String)username));
        }
        try {
            PasswordResetConfiguration configuration = this.getConfiguration(request, response);
            if (HtmlFormIdpAuthnAdapter.isResetTypeNone(configuration.getResetType())) {
                ResponseHandler.sendResourceNotFoundResponse(request, response);
                return;
            }
        }
        catch (IllegalArgumentException ex) {
            logger.error((Object)ex);
            ResponseHandler.sendResourceNotFoundResponse(request, response);
            return;
        }
        if (this.redirectToDefaultAuthnApp(request, response)) {
            PasswordResetHandler.redirectToPasswordResetIdentifyServlet(request, response, this.getAdapterId(request, response));
            return;
        }
        this.render(request, response, defaultParams);
    }

    private Map<String, Class<?>> getActionIdToModelMapping(HttpServletRequest request, HttpServletResponse response) {
        boolean isSupportUsernameRecovery = this.getConfiguration(request, response).isEnableUsernameRecovery();
        return new ApiPasswordResetUsernameRequiredHandler(isSupportUsernameRecovery).getActionIdToModelMapping(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        logger.debug((Object)"POST Request to /ext/pwdreset/Identify");
        if (!this.validStage(AbstractPasswordManagementServlet.Stage.IDENTIFYING, request, response)) {
            this.handleError(request, response, "forgot-password-error.invalidState");
            return;
        }
        if (AuthnApiSupport.getDefault().isApiRequest(request) && !AuthnApiSupport.getDefault().isValidAuthnApiPostRequest(request, response, this.getActionIdToModelMapping(request, response))) {
            return;
        }
        if (StringUtils.isNotBlank((String)request.getParameter("pf.passwordreset"))) {
            logger.debug((Object)"New reset request parameter received. Handling as GET...");
            this.doGet(request, response);
            return;
        }
        UrlUtil urlUtil = new UrlUtil(request);
        PwdResetAuditLogger.init("PWD_RESET_REQUEST", request, response);
        Map<String, Object> defaultParams = this.getDefaultTemplateParams(request, response);
        if (!this.validStage(AbstractPasswordManagementServlet.Stage.IDENTIFYING, request, response)) {
            PwdResetAuditLogger.logFailure("Invalid state (unauthorized method)");
            this.handleError(request, response, "forgot-password-error.invalidState");
            return;
        }
        if (!AuthnApiSupport.getDefault().isApiRequest(request)) {
            String cSRFToken = this.validateCSRFToken(request, response);
            if (cSRFToken == null) {
                PwdResetAuditLogger.logFailure("Invalid state (unauthorized method)");
                this.handleError(request, response, "forgot-password-error.invalidState");
                return;
            }
            defaultParams.put(TemplateKey.CSRF_TOKEN.getKey(), cSRFToken);
        }
        IdentifyForm form = null;
        IdentifyResult validationResult = null;
        PasswordResetConfiguration configuration = this.getConfiguration(request, response);
        PasswordResetSessionState sessionState = this.getSessionState(request, response);
        try {
            form = this.parseRequest(request, response);
            if (form.isSubmit() && configuration.isEnableCaptcha()) {
                if (AuthnApiSupport.getDefault().isApiRequest(request) && HtmlFormAuthnApiHandler.isMissingAuthnApiCaptchaResponse(request)) {
                    HtmlFormAuthnApiHandler.sendCaptchaResponseMissingResponse(request, response);
                    return;
                }
                CaptchaProvider captchaProvider = CaptchaProviderAccessor.getCaptchaProvider((String)configuration.getCaptchaProviderId());
                Map<String, Object> parameters = this.getCaptchaProviderInParams(request, response, sessionState);
                parameters.put("com.pingidentity.adapter.input.parameter.userid", EscapeUtils.escape((String)form.getUsername()));
                parameters.put("com.pingidentity.adapter.input.parameter.userid.authenticated", false);
                CaptchaContext context = new CaptchaContext.Builder().setRequest(request).setResponse(response).setAction("passwordReset").setInParameters(parameters).build();
                CaptchaResult captchaResult = captchaProvider.validateCaptcha(context);
                boolean isValid = captchaResult.isValid();
                if (!isValid) {
                    logger.debug((Object)"Login failed: reCAPTCHA validation failure.");
                    validationResult = IdentifyResult.CaptchaError;
                }
            }
            if (validationResult == null) {
                PwdResetAuditLogger.setUserName((String)form.getUsername());
                IdentifyHandler handler = new IdentifyHandler(configuration, request, response);
                validationResult = handler.validateUsername(form, request);
            }
        }
        catch (IOException | InvalidRequestParameterException e) {
            logger.error((Object)e.getMessage());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)e.getMessage(), e);
            }
            validationResult = IdentifyResult.Error;
        }
        IdentifyServlet.auditRequestResult(validationResult);
        switch (validationResult) {
            case PingID: {
                this.setStage(AbstractPasswordManagementServlet.Stage.AUTHENTICATING, request, response);
                if (AuthnApiSupport.getDefault().isApiRequest(request)) {
                    PasswordResetHandler.reissueRequestToPasswordResetPingIDServlet(request, response);
                    break;
                }
                this.redirect(response, urlUtil.buildPingIdUrl());
                break;
            }
            case UserNotFound: 
            case NoEmailAddress: {
                if ("PingID".equals(configuration.getResetType()) || "POLICY".equals(configuration.getResetType())) {
                    this.handleError(request, response, "forgot-password-error.notEnrolled");
                    break;
                }
                this.setStage(AbstractPasswordManagementServlet.Stage.COMPLETED, request, response);
                if ("OTL".equals(configuration.getResetType())) {
                    sessionState.setSuccessMessageKey("forgot-password-success.onetimeLinkSent");
                    if (AuthnApiSupport.getDefault().isApiRequest(request)) {
                        PasswordResetHandler.reissueRequestToPasswordResetSuccessServlet(request, response);
                        break;
                    }
                    this.redirect(response, urlUtil.buildSuccessUrl());
                    break;
                }
            }
            case AccountDisabledCodeNotSent: 
            case EmailUnverifiedCodeNotSent: 
            case CodeSent: 
            case SmsServiceRequestSent: 
            case NoMobilePhone: {
                this.setStage(AbstractPasswordManagementServlet.Stage.AUTHENTICATING, request, response);
                if (AuthnApiSupport.getDefault().isApiRequest(request)) {
                    PasswordResetHandler.reissueRequestToPasswordResetSecurityCodeServlet(request, response);
                    break;
                }
                this.redirect(response, urlUtil.buildSecurityCodeUrl());
                break;
            }
            case EmailUnverifiedLinkNotSent: 
            case AccountDisabledLinkNotSent: 
            case LinkSent: {
                this.setStage(AbstractPasswordManagementServlet.Stage.COMPLETED, request, response);
                sessionState.setUsername(form.getUsername());
                sessionState.setSuccessMessageKey("forgot-password-success.onetimeLinkSent");
                if (AuthnApiSupport.getDefault().isApiRequest(request)) {
                    PasswordResetHandler.reissueRequestToPasswordResetSuccessServlet(request, response);
                    break;
                }
                this.redirect(response, urlUtil.buildSuccessUrl());
                break;
            }
            case CaptchaError: {
                this.handleError(request, response, "forgot-password-error.captchaError");
                break;
            }
            case Error: {
                this.handleError(request, response, "forgot-password-error.unknownError");
                break;
            }
            case RecoverUsername: {
                RecoverUsernameSessionState newSessionState = RecoverUsernameSessionState.create(request, response);
                newSessionState.setAdapterId(sessionState.getAdapterId());
                newSessionState.setTargetResource(sessionState.getTargetResource());
                newSessionState.setTrackedHttpParams(sessionState.getTrackedHttpParams());
                newSessionState.setFromHtmlFormAdapter(sessionState.isFromHtmlFormAdapter());
                newSessionState.setDefaultTemplateParams(sessionState.getDefaultTemplateParams());
                if (AuthnApiSupport.getDefault().isApiRequest(request)) {
                    PasswordResetHandler.reissueRequestToUsernameRecoveryServlet(request, response);
                    break;
                }
                this.redirect(response, HtmlFormIdpAuthnAdapter.getRecoverUsernameUrl(request, response), false);
                break;
            }
            case Cancel: {
                this.doCancel(request, response);
                break;
            }
            case NoUsername: {
                defaultParams.put("errorMessageKey", "forgot-password.noUsername");
                this.render(request, response, defaultParams);
                break;
            }
            case Policy: {
                sessionState.setStage(AbstractPasswordManagementServlet.Stage.AUTHENTICATING);
                if (AuthnApiSupport.getDefault().isApiRequest(request)) {
                    PasswordResetHandler.reissueRequestToPasswordResetPolicyServlet(request, response);
                    break;
                }
                this.redirect(response, urlUtil.buildPolicyUrl());
            }
        }
    }

    private IdentifyForm parseRequest(HttpServletRequest request, HttpServletResponse response) throws InvalidRequestParameterException, IOException {
        IdentifyForm identifyForm = new IdentifyForm(request);
        String username = (String)USERNAME_MAPPING.getValue(request);
        identifyForm.setUsername(username);
        identifyForm.setSubmit("clicked".equals(request.getParameter("Resume")) || CommonActionSpec.CHECK_ACCOUNT_RECOVERY_USERNAME.isRequested(request));
        return identifyForm;
    }

    private void render(HttpServletRequest request, HttpServletResponse response, Map<String, Object> params) throws IOException {
        PasswordResetConfiguration configuration = this.getConfiguration(request, response);
        params.put(TemplateKey.URL.getKey(), request.getContextPath() + "/");
        params.put(TemplateKey.USERNAME_FIELD.getKey(), "username");
        params.put(TemplateKey.OK.getKey(), "Resume");
        params.put(TemplateKey.CANCEL.getKey(), "Cancel");
        params.put(TemplateKey.USERNAME_RECOVERY.getKey(), "pf.usernamerecovery");
        params.put(TemplateKey.SUPPORTS_USERNAME_RECOVERY.getKey(), configuration.isEnableUsernameRecovery());
        params.put(TemplateKey.CAPTCHA_ENABLED.getKey(), configuration.isEnableCaptcha());
        if (configuration.isEnableCaptcha()) {
            CaptchaProviderRenderUtil.addCaptchaProviderParametersToTemplateParameters(request, response, configuration.getCaptchaProviderId(), "passwordReset", TemplateKey.SITE_KEY.getKey(), params);
        }
        if (!params.containsKey(TemplateKey.SAVED_USERNAME.getKey())) {
            params.put(TemplateKey.SAVED_USERNAME.getKey(), "");
        }
        try {
            ResponseHandler.renderPasswordResetUsernameRequiredResponse(request, response, configuration.getUsernameTemplate(), params);
        }
        catch (Exception ex) {
            throw new ProcessRuntimeException("Error on Request to /ext/pwdreset/Identify", (Throwable)ex);
        }
    }

    private static void auditRequestResult(IdentifyResult validationResult) {
        switch (validationResult) {
            case Cancel: 
            case NoUsername: {
                break;
            }
            case CaptchaError: 
            case Error: {
                PwdResetAuditLogger.logFailure("System error (see server log)");
                break;
            }
            case UserNotFound: {
                PwdResetAuditLogger.logFailure("User not found");
                break;
            }
            case NoEmailAddress: {
                PwdResetAuditLogger.logFailure("Email address not found");
                break;
            }
            case NoMobilePhone: {
                PwdResetAuditLogger.logFailure("Phone number for SMS not found");
                break;
            }
            case EmailUnverifiedCodeNotSent: 
            case EmailUnverifiedLinkNotSent: {
                PwdResetAuditLogger.logFailure("User found but email address not verified.");
                break;
            }
            case PingID: 
            case CodeSent: 
            case SmsServiceRequestSent: 
            case LinkSent: {
                PwdResetAuditLogger.log();
                break;
            }
        }
    }

    private void initializeSessionState(HttpServletRequest request, HttpServletResponse response) {
        boolean internalRedirect;
        boolean bl = internalRedirect = request.getParameter("InternalRedirect") != null;
        if (!internalRedirect) {
            TrackedParamsUtil paramsUtil;
            Map trackedHttpParams;
            String targetResource;
            PasswordResetSessionState sessionState = PasswordResetSessionState.create(request, response);
            String adapterId = this.getAdapterIdFromRequest(request);
            if (StringUtils.isNotEmpty((String)adapterId)) {
                sessionState.setAdapterId(adapterId);
            }
            if (StringUtils.isNotEmpty((String)(targetResource = request.getParameter("TargetResource")))) {
                if (this.isValidTargetResource(targetResource)) {
                    sessionState.setTargetResource(targetResource);
                } else {
                    logger.warn((Object)String.format("Ignoring request parameter TargetResource '%s' as it does not pass TargetResource validation.", targetResource));
                }
            }
            if (!(trackedHttpParams = (paramsUtil = new TrackedParamsUtil()).retrieveTrackedParams(request)).isEmpty()) {
                sessionState.setTrackedHttpParams(trackedHttpParams);
            }
        }
    }
}

