/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.htmlform.pwdreset.servlet;

import com.pingidentity.adapters.htmlform.pwdmgmt.servlet.AbstractPasswordManagementServlet;
import com.pingidentity.adapters.htmlform.pwdreset.common.PasswordResetConfiguration;
import com.pingidentity.adapters.htmlform.pwdreset.common.PasswordResetSessionState;
import com.pingidentity.adapters.htmlform.pwdreset.handler.PingIDHandler;
import com.pingidentity.adapters.htmlform.pwdreset.model.PingIDForm;
import com.pingidentity.adapters.htmlform.pwdreset.servlet.AbstractPasswordResetServlet;
import com.pingidentity.adapters.htmlform.pwdreset.type.PingIDResult;
import com.pingidentity.adapters.htmlform.pwdreset.util.PwdResetAuditLogger;
import com.pingidentity.adapters.htmlform.pwdreset.util.UrlUtil;
import com.pingidentity.adapters.htmlform.render.handler.api.HtmlFormAuthnApiHandler;
import com.pingidentity.adapters.htmlform.render.handler.api.passwordreset.PasswordResetHandler;
import com.pingidentity.common.util.PropertyInfo;
import com.pingidentity.sdk.api.authn.util.AuthnApiSupport;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PingIDServlet
extends AbstractPasswordResetServlet {
    private static Log logger = LogFactory.getLog(PingIDServlet.class);

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        logger.debug((Object)"GET Request to /ext/pwdreset/PingID");
        PasswordResetConfiguration configuration = this.getConfiguration(request, response);
        if (!this.validStage(AbstractPasswordManagementServlet.Stage.AUTHENTICATING, request, response) || !this.validResetType(configuration.getResetType())) {
            this.handleError(request, response, "forgot-password-error.invalidState");
            return;
        }
        PwdResetAuditLogger.init("PWD_RESET_REQUEST_RESPONSE", request, response);
        if (AuthnApiSupport.getDefault().isApiRequest(request)) {
            HtmlFormAuthnApiHandler.clearApiState(request, response);
            this.saveAuthnApiStateToSession(request, response);
            AuthnApiSupport.getDefault().writeResumeResponse(request, response, this.getPingIDUrl());
            return;
        }
        PingIDForm form = new PingIDForm(request);
        String username = this.getUsername(request, response);
        PwdResetAuditLogger.setUserName((String)username);
        PingIDHandler handler = new PingIDHandler(configuration, request, response);
        String pcvId = this.getSessionState(request, response).getPcvId();
        String pingIdUsername = handler.getPingUserId(username, pcvId);
        if (pingIdUsername != null && handler.isActiveForAuthentication(pingIdUsername)) {
            try {
                UrlUtil urlUtil = new UrlUtil(request);
                String returnUrl = form.getRootPath() + urlUtil.buildPingAuthReturnUrl();
                handler.sendAuthRequest(pingIdUsername, returnUrl, request, response);
            }
            catch (Exception e) {
                PwdResetAuditLogger.logFailure("PingID request failed (see server log)");
                String pingIDAuthenticatorPath = configuration.getPingIdAuthenticatorUrl() + "/auth";
                logger.error((Object)("Error posting request to: " + pingIDAuthenticatorPath), (Throwable)e);
                this.handleError(request, response, "forgot-password-error.authFailed");
            }
        } else {
            PwdResetAuditLogger.logFailure("PingID user not enrolled");
            this.handleError(request, response, "forgot-password-error.notEnrolled");
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        logger.debug((Object)"POST Request to /ext/pwdreset/PingID");
        PasswordResetConfiguration configuration = this.getConfiguration(request, response);
        if (!this.validStage(AbstractPasswordManagementServlet.Stage.AUTHENTICATING, request, response) || !this.validResetType(configuration.getResetType())) {
            this.handleError(request, response, "forgot-password-error.invalidState");
            return;
        }
        PwdResetAuditLogger.init("PWD_RESET_REQUEST_RESPONSE", request, response);
        PingIDForm form = new PingIDForm(request);
        String username = this.getUsername(request, response);
        PwdResetAuditLogger.setUserName((String)username);
        PingIDHandler handler = new PingIDHandler(configuration, request, response);
        PingIDResult result = handler.validatePingID(form);
        PasswordResetSessionState sessionState = this.getSessionState(request, response);
        String authnApiAppId = sessionState.getAuthnApiAppId();
        String authnApiFlowId = sessionState.getAuthnApiFlowId();
        switch (result) {
            case Success: {
                if (configuration.getPasswordUpdateTimeout() != null) {
                    sessionState.refreshPasswordUpdateSession();
                }
                this.setStage(AbstractPasswordManagementServlet.Stage.AUTHENTICATED, request, response);
                if (authnApiAppId != null && authnApiFlowId != null) {
                    this.handleAuthnApiSuccessActionRedirect(request, response, configuration, authnApiAppId, authnApiFlowId);
                    break;
                }
                this.handleSuccessAction(request, response, configuration);
                break;
            }
            case Canceled: {
                PwdResetAuditLogger.logFailure("PingID authentication canceled");
                sessionState.setStage(AbstractPasswordManagementServlet.Stage.ERROR);
                sessionState.setErrorMessageKey("forgot-password-error.cancel");
                if (sessionState.isAuthnApiPasswordResetVerificationPending()) {
                    PasswordResetHandler.redirectToAuthnApplicationHtmlFormAdapter(request, response, authnApiAppId, authnApiFlowId);
                    break;
                }
                this.doCancel(request, response);
                break;
            }
            case Expired: {
                PwdResetAuditLogger.logFailure("PingID request expired");
                this.handleError(request, response, "forgot-password-error.authFailed");
                break;
            }
            case AuthFailed: {
                PwdResetAuditLogger.logFailure("PingID authentication failed");
                this.handleError(request, response, "forgot-password-error.authFailed");
                break;
            }
            default: {
                PwdResetAuditLogger.logFailure("PingID unexpected error (see server log)");
                this.handleError(request, response, "");
            }
        }
    }

    private boolean validResetType(String resetType) {
        return "PingID".equals(resetType);
    }

    private void saveAuthnApiStateToSession(HttpServletRequest request, HttpServletResponse response) {
        PasswordResetSessionState sessionState = this.getSessionState(request, response);
        sessionState.setAuthnApiPasswordResetVerificationPending(true);
        sessionState.setAuthnApiAppId(PasswordResetHandler.getAuthnApiAppId(request));
        sessionState.setAuthnApiFlowId(AuthnApiSupport.getDefault().getFlowId(request.getPathInfo()));
    }

    @Override
    protected void handleError(HttpServletRequest request, HttpServletResponse response, String errorMessageKey) throws IOException {
        PasswordResetSessionState sessionState = this.getSessionState(request, response);
        sessionState.setStage(AbstractPasswordManagementServlet.Stage.ERROR);
        sessionState.setErrorMessageKey(errorMessageKey);
        if (sessionState.isAuthnApiPasswordResetVerificationPending()) {
            PasswordResetHandler.redirectToPasswordResetErrorServlet(request, response, sessionState.getAuthnApiAppId(), sessionState.getAuthnApiFlowId());
        } else {
            UrlUtil urlUtil = new UrlUtil(request);
            this.redirect(response, urlUtil.buildErrorUrl());
        }
    }

    private String getPingIDUrl() {
        String contextPath = PropertyInfo.getContextPath();
        return "/".equals(contextPath) ? "/ext/pwdreset/PingID" : contextPath + "/ext/pwdreset/PingID";
    }
}

