/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.htmlform.pwdreset.servlet;

import com.pingidentity.adapters.htmlform.idp.HtmlFormIdpAuthnAdapterUtils;
import com.pingidentity.adapters.htmlform.pwdmgmt.servlet.AbstractPasswordManagementServlet;
import com.pingidentity.adapters.htmlform.pwdreset.common.PasswordResetConfiguration;
import com.pingidentity.adapters.htmlform.pwdreset.common.PasswordResetSessionState;
import com.pingidentity.adapters.htmlform.pwdreset.handler.ResetHandler;
import com.pingidentity.adapters.htmlform.pwdreset.model.ResetForm;
import com.pingidentity.adapters.htmlform.pwdreset.servlet.AbstractPasswordResetServlet;
import com.pingidentity.adapters.htmlform.pwdreset.type.ResetResult;
import com.pingidentity.adapters.htmlform.pwdreset.util.PwdResetAuditLogger;
import com.pingidentity.adapters.htmlform.pwdreset.util.UrlUtil;
import com.pingidentity.adapters.htmlform.render.TemplateKey;
import com.pingidentity.adapters.htmlform.render.handler.ResponseHandler;
import com.pingidentity.adapters.htmlform.render.handler.api.HtmlFormAuthnApiHandler;
import com.pingidentity.adapters.htmlform.render.handler.api.passwordreset.PasswordResetHandler;
import com.pingidentity.common.util.CrossSiteRequestForgeryHelper;
import com.pingidentity.locale.LocaleUtil;
import com.pingidentity.sdk.api.authn.common.CommonStateSpec;
import com.pingidentity.sdk.api.authn.spec.AuthnStateSpec;
import com.pingidentity.sdk.api.authn.util.AuthnApiSupport;
import com.pingidentity.sdk.password.PasswordPolicyRequirementResetException;
import com.pingidentity.sdk.password.PasswordResetException;
import com.pingidentity.sdk.password.ResettablePasswordCredential;
import com.pingidentity.templates.mgmt.TemplateParamUtil;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.util.log.AttributeMap;
import org.sourceid.websso.profiles.ProcessRuntimeException;

public class ResetServlet
extends AbstractPasswordResetServlet {
    private static Log logger = LogFactory.getLog(ResetServlet.class);

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        logger.debug((Object)"GET Request to /ext/pwdreset/Reset");
        if (!this.validStage(AbstractPasswordManagementServlet.Stage.AUTHENTICATED, request, response)) {
            this.handleError(request, response, "forgot-password-error.invalidState");
            return;
        }
        Map<String, Object> defaultParams = this.getDefaultTemplateParams(request, response);
        String cSRFToken = CrossSiteRequestForgeryHelper.getCSRFToken((HttpServletRequest)request, (HttpServletResponse)response);
        defaultParams.put(TemplateKey.CSRF_TOKEN.getKey(), cSRFToken);
        this.render(request, response, defaultParams);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        ResetResult validationResult;
        List pwdReqNotMetMsgList;
        List pwdReqMetMsgList;
        String exceptionMessage;
        PasswordResetConfiguration configuration;
        String username;
        Map<String, Object> defaultParams;
        UrlUtil urlUtil;
        block23: {
            logger.debug((Object)"POST Request to /ext/pwdreset/Reset");
            if (!this.validStage(AbstractPasswordManagementServlet.Stage.AUTHENTICATED, request, response)) {
                this.handleError(request, response, "forgot-password-error.invalidState");
                return;
            }
            PwdResetAuditLogger.init("PWD_RESET", request, response);
            if (AuthnApiSupport.getDefault().isApiRequest(request) && !HtmlFormAuthnApiHandler.isValidApiPostRequest(request, response, this.getExpectedState(request, response))) {
                return;
            }
            urlUtil = new UrlUtil(request);
            defaultParams = this.getDefaultTemplateParams(request, response);
            if (!AuthnApiSupport.getDefault().isApiRequest(request)) {
                String cSRFToken = this.validateCSRFToken(request, response);
                if (cSRFToken == null) {
                    PwdResetAuditLogger.logFailure("Invalid state (unauthorized method)");
                    this.handleError(request, response, "forgot-password-error.invalidState");
                    return;
                }
                defaultParams.put(TemplateKey.CSRF_TOKEN.getKey(), cSRFToken);
            }
            ResetForm form = new ResetForm(request);
            username = this.getUsername(request, response);
            PwdResetAuditLogger.setUserName((String)username);
            configuration = this.getConfiguration(request, response);
            ResetHandler handler = new ResetHandler(configuration, request, response);
            exceptionMessage = null;
            pwdReqMetMsgList = Collections.EMPTY_LIST;
            pwdReqNotMetMsgList = Collections.EMPTY_LIST;
            try {
                validationResult = handler.resetPassword(form, request, response);
            }
            catch (PasswordResetException e) {
                validationResult = ResetResult.PasswordConstraintViolation;
                exceptionMessage = e.getMessage();
                if (!(e instanceof PasswordPolicyRequirementResetException)) break block23;
                Locale userLocale = LocaleUtil.getUserLocale((HttpServletRequest)request);
                exceptionMessage = null;
                pwdReqMetMsgList = ((PasswordPolicyRequirementResetException)e).getRequirementsMet(userLocale);
                pwdReqNotMetMsgList = ((PasswordPolicyRequirementResetException)e).getRequirementsNotMet(userLocale);
            }
        }
        PasswordResetSessionState sessionState = this.getSessionState(request, response);
        switch (validationResult) {
            case NoNewPassword: {
                PwdResetAuditLogger.logFailure("Password not provided");
                defaultParams.put(TemplateKey.ERROR_MESSAGE_KEY.getKey(), "forgot-password-change.noNewPassword");
                this.render(request, response, defaultParams);
                break;
            }
            case NoConfirmPassword: {
                PwdResetAuditLogger.logFailure("Confirm password not provided");
                defaultParams.put(TemplateKey.ERROR_MESSAGE_KEY.getKey(), "forgot-password-change.noConfirmPassword");
                this.render(request, response, defaultParams);
                break;
            }
            case PasswordConstraintViolation: {
                PwdResetAuditLogger.logFailure("Password policy constraint violation");
                if (CollectionUtils.isNotEmpty((Collection)pwdReqMetMsgList)) {
                    defaultParams.put(TemplateKey.PWD_QUALITY_REQ_MET_MSG_LIST.getKey(), pwdReqMetMsgList);
                }
                if (CollectionUtils.isNotEmpty((Collection)pwdReqNotMetMsgList)) {
                    defaultParams.put(TemplateKey.PWD_QUALITY_REQ_NOT_MET_MSG_LIST.getKey(), pwdReqNotMetMsgList);
                }
                defaultParams.put(TemplateKey.ERROR_MESSAGE_KEY.getKey(), StringUtils.isEmpty((String)exceptionMessage) ? "forgot-password-change.doesNotMatchPasswordConstraint" : exceptionMessage);
                this.render(request, response, defaultParams);
                break;
            }
            case Expired: {
                PwdResetAuditLogger.logFailure("Reset token expired");
                this.handleError(request, response, "forgot-password-error.codeExpired");
                break;
            }
            case Success: {
                PwdResetAuditLogger.log();
                this.resetLoginAttempt(request, response);
                if (configuration.isEnableRememberMyUsername() && this.getSessionState(request, response).isRememberUsername()) {
                    String cookieName = configuration.getRememberMyUsernameCookieName();
                    int age = configuration.getRememberMyUsernameCookieLifetime();
                    HtmlFormIdpAuthnAdapterUtils.addCookie(cookieName, username, age, response);
                }
                sessionState.setSuccessAuthenticationStageCompleted();
                if ("OTL".equals(configuration.getResetType()) || StringUtils.isEmpty((String)this.getSessionState(request, response).getResumeUrl())) {
                    sessionState.setSuccessMessageKey("forgot-password-success.passwordChangeSuccessfulNoContinue");
                } else {
                    sessionState.setSuccessMessageKey("forgot-password-success.passwordChangeSuccessful");
                }
                if (AuthnApiSupport.getDefault().isApiRequest(request)) {
                    PasswordResetHandler.reissueRequestToPasswordResetSuccessServlet(request, response);
                    break;
                }
                this.redirect(response, urlUtil.buildSuccessUrl());
                break;
            }
            case PasswordUpdateTimedOut: {
                PwdResetAuditLogger.logFailure("Password update timed out.");
                this.handleError(request, response, "forgot-password-error.passwordUpdateTimedOut");
                break;
            }
            case Error: {
                PwdResetAuditLogger.logFailure("Unexpected error setting password (see server log)");
                this.handleError(request, response, "forgot-password-error.passwordChangeFailed");
                break;
            }
            case PasswordMismatch: {
                PwdResetAuditLogger.logFailure("Password mismatch");
                defaultParams.put(TemplateKey.ERROR_MESSAGE_KEY.getKey(), "forgot-password-change.passwordMismatch");
                this.render(request, response, defaultParams);
                break;
            }
            case Cancel: {
                logger.debug((Object)"Reset canceled");
                this.doCancel(request, response);
                break;
            }
            default: {
                PwdResetAuditLogger.logFailure("Unexpected error with resetting the password (see server log)");
                this.handleError(request, response, "forgot-password-error.unknownError");
            }
        }
    }

    private void render(HttpServletRequest request, HttpServletResponse response, Map<String, Object> params) {
        params.put("url", request.getContextPath() + "/");
        params.put("password1", "Password1");
        params.put("password2", "Password2");
        params.put(TemplateKey.OK.getKey(), "Reset");
        params.put(TemplateKey.CANCEL.getKey(), "Cancel");
        String pcvId = this.getSessionState(request, response).getPcvId();
        String username = this.getSessionState(request, response).getUsername();
        Map userAttributes = this.getSessionState(request, response).getUserAttributes();
        if (userAttributes.isEmpty()) {
            ResettablePasswordCredential pcv = (ResettablePasswordCredential)MgmtFactory.getCredentialValidatorManager().getValidator(pcvId);
            userAttributes = TemplateParamUtil.convertAttributeMapToTemplateParams((AttributeMap)pcv.findUser(username));
        }
        params.put(TemplateKey.USER_ATTRIBUTES.getKey(), userAttributes);
        try {
            PasswordResetConfiguration configuration = this.getConfiguration(request, response);
            ResponseHandler.renderPasswordResetNewPasswordRequiredResponse(request, response, configuration.getChangeTemplate(), params);
        }
        catch (Exception ex) {
            throw new ProcessRuntimeException("Error on Request to /ext/pwdreset/Reset", (Throwable)ex);
        }
    }

    private AuthnStateSpec<?> getExpectedState(HttpServletRequest request, HttpServletResponse response) {
        return CommonStateSpec.PASSWORD_RESET_REQUIRED;
    }
}

