/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.htmlform.pwdreset.servlet;

import com.pingidentity.adapters.htmlform.pwdmgmt.servlet.AbstractPasswordManagementServlet;
import com.pingidentity.adapters.htmlform.pwdreset.common.PasswordResetConfiguration;
import com.pingidentity.adapters.htmlform.pwdreset.common.PasswordResetSessionState;
import com.pingidentity.adapters.htmlform.pwdreset.handler.ResumeHandler;
import com.pingidentity.adapters.htmlform.pwdreset.model.ResumeForm;
import com.pingidentity.adapters.htmlform.pwdreset.servlet.AbstractPasswordResetServlet;
import com.pingidentity.adapters.htmlform.pwdreset.type.ResumeResult;
import com.pingidentity.adapters.htmlform.pwdreset.util.PwdResetAuditLogger;
import com.pingidentity.adapters.htmlform.render.handler.api.passwordreset.PasswordResetHandler;
import java.io.IOException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.service.AdapterAuthnSourceKey;
import org.sourceid.saml20.service.AuthnSourceKey;
import org.sourceid.token.PFInternalTokenTranslator;
import org.sourceid.token.jwt.JwtTokenGeneratorImpl;
import org.sourceid.token.jwt.PFInternalTokenException;
import org.sourceid.token.jwt.PFResetPasswordtoJwtTranslator;

public class ResumeServlet
extends AbstractPasswordResetServlet {
    private static final Logger logger = LoggerFactory.getLogger(ResumeServlet.class);

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        AttributeValue adapterId;
        Map attrs;
        logger.debug("GET Request to {}", (Object)"/ext/pwdreset/Resume");
        PwdResetAuditLogger.init("PWD_RESET_REQUEST_RESPONSE", request, response);
        ResumeForm form = new ResumeForm(request);
        PFResetPasswordtoJwtTranslator jwtTranslator = new PFResetPasswordtoJwtTranslator();
        JwtTokenGeneratorImpl tokenGenerator = new JwtTokenGeneratorImpl((PFInternalTokenTranslator)jwtTranslator);
        PasswordResetSessionState oldSessionState = this.getSessionState(request, response);
        PasswordResetSessionState sessionState = PasswordResetSessionState.create(request, response);
        sessionState.setStage(AbstractPasswordManagementServlet.Stage.AUTHENTICATING);
        if (StringUtils.isBlank((String)form.getReferenceId())) {
            logger.debug("referenceId is blank in request, cannot resume password reset flow, returning error");
            PwdResetAuditLogger.logFailure("Invalid OTL (no ref ID in request)");
            this.handleError(request, response, "forgot-password-error.noCodeInRequest");
            return;
        }
        try {
            attrs = tokenGenerator.decrypt(form.getReferenceId());
            adapterId = (AttributeValue)attrs.get("adapterId");
        }
        catch (PFInternalTokenException e) {
            switch (e.getError()) {
                case 1: {
                    String auditLogLinkExpiredMsg = "OTL expired";
                    try {
                        Map attrs2 = tokenGenerator.getClaimsFromExpiredJwt(e);
                        String authnApiAppId = ResumeServlet.getAuthnApiAppId(attrs2);
                        if (authnApiAppId != null) {
                            this.handleRedirectAuthnApiAppPasswordResetError(request, response, sessionState, authnApiAppId, oldSessionState.getAuthnApiFlowId(), "forgot-password-error.linkExpired", "OTL expired");
                            return;
                        }
                    }
                    catch (PFInternalTokenException ex) {
                        logger.debug("One-time link expired and PingFederate was unable to extract authentication API app ID claim from the link. Falling back to standard error handling.", (Throwable)ex);
                    }
                    this.handleLinkErrorWithLogging(request, response, "OTL expired", "Code not validated within time tolerance", "forgot-password-error.linkExpired");
                    return;
                }
            }
            logger.debug("the OTL is invalid, returning error", (Throwable)e);
            PwdResetAuditLogger.logFailure("Invalid OTL (invalid data in ref ID)");
            this.handleError(request, response, "forgot-password-error.invalidCode");
            return;
        }
        if (adapterId == null) {
            PwdResetAuditLogger.logFailure("Invalid OTL (no data for ref ID)");
            this.handleError(request, response, "forgot-password-error.invalidLink");
            return;
        }
        if (!this.validResetType(adapterId.getValue())) {
            PwdResetAuditLogger.logFailure("Invalid state (unauthorized method)");
            this.handleError(request, response, "forgot-password-error.invalidState");
            return;
        }
        try {
            PwdResetAuditLogger.setUserName((String)oldSessionState.getUsername());
            PwdResetAuditLogger.setAuthnSourceId((AuthnSourceKey)new AdapterAuthnSourceKey(adapterId.getValue()));
            PasswordResetConfiguration configuration = this.getConfiguration(adapterId.getValue());
            ResumeHandler handler = new ResumeHandler(configuration, request, response);
            ResumeResult validationResult = handler.validateLink(form, request, response, attrs);
            String username = this.getUsername(request, response);
            PwdResetAuditLogger.setUserName((String)username);
            switch (validationResult) {
                case Error: {
                    PwdResetAuditLogger.logFailure("OTL unexpected error (see server log)");
                    this.handleError(request, response, "forgot-password-error.unknownError");
                    break;
                }
                case Success: {
                    String authnApiAppId;
                    if (configuration.getPasswordUpdateTimeout() != null) {
                        sessionState.refreshPasswordUpdateSession();
                    }
                    this.setStage(AbstractPasswordManagementServlet.Stage.AUTHENTICATED, request, response);
                    sessionState.setOtlAuthenticated(true);
                    if (StringUtils.equals((String)this.getCode(oldSessionState), (String)this.getCode(sessionState))) {
                        sessionState.setTargetResource(oldSessionState.getTargetResource());
                        sessionState.setResumeUrl(oldSessionState.getResumeUrl());
                        sessionState.setFromHtmlFormAdapter(oldSessionState.isFromHtmlFormAdapter());
                        sessionState.setTrackedHttpParams(oldSessionState.getTrackedHttpParams());
                        sessionState.setDefaultTemplateParams(oldSessionState.getDefaultTemplateParams());
                    }
                    if ((authnApiAppId = ResumeServlet.getAuthnApiAppId(attrs)) != null) {
                        this.handleAuthnApiSuccessActionRedirect(request, response, configuration, authnApiAppId, oldSessionState.getAuthnApiFlowId());
                        break;
                    }
                    this.handleSuccessAction(request, response, configuration);
                    break;
                }
                case LinkUsed: {
                    String authnApiAppId = ResumeServlet.getAuthnApiAppId(attrs);
                    String auditLogLinkAlreadyUsed = "OTL already used";
                    if (authnApiAppId != null) {
                        this.handleRedirectAuthnApiAppPasswordResetError(request, response, sessionState, authnApiAppId, oldSessionState.getAuthnApiFlowId(), "forgot-password-error.linkUsed", "OTL already used");
                        break;
                    }
                    this.handleLinkErrorWithLogging(request, response, "OTL already used", "The OTL has already been used for a successful password reset and cannot be re-used.", "forgot-password-error.linkUsed");
                    break;
                }
                case InvalidLink: {
                    PwdResetAuditLogger.logFailure("Invalid OTL (no data for ref ID)");
                    this.handleError(request, response, "forgot-password-error.invalidLink");
                    break;
                }
                case NoReferenceId: {
                    PwdResetAuditLogger.logFailure("Invalid OTL (ref ID not found)");
                    this.handleError(request, response, "forgot-password-error.noCodeInRequest");
                }
            }
        }
        catch (Exception ex) {
            PwdResetAuditLogger.logFailure("OTL unexpected error (see server log)");
            logger.error("Error occurred on /ext/pwdreset/Resume", (Throwable)ex);
            this.handleError(request, response, "forgot-password-error.unknownError");
        }
    }

    private void handleRedirectAuthnApiAppPasswordResetError(HttpServletRequest request, HttpServletResponse response, PasswordResetSessionState sessionState, String authnApiAppId, String flowId, String errMsgKey, String auditLogMsg) throws IOException {
        PwdResetAuditLogger.logFailure(auditLogMsg);
        sessionState.setStage(AbstractPasswordManagementServlet.Stage.ERROR);
        sessionState.setErrorMessageKey(errMsgKey);
        PasswordResetHandler.redirectToPasswordResetErrorServlet(request, response, authnApiAppId, flowId);
    }

    private static String getAuthnApiAppId(Map<String, AttributeValue> attrs) {
        return attrs.get("prAuthnApiAppID") == null ? null : attrs.get("prAuthnApiAppID").getValue();
    }

    @Override
    protected boolean canSkipStageValidation() {
        return true;
    }

    private String getCode(PasswordResetSessionState sessionState) {
        if (sessionState.getCodeAttributeMap() == null) {
            return null;
        }
        return sessionState.getCodeAttributeMap().getSingleValue("prCodeMapCode");
    }

    private void handleLinkErrorWithLogging(HttpServletRequest request, HttpServletResponse response, String auditLogMsg, String logMsg, String errorMessageKey) throws IOException {
        PwdResetAuditLogger.logFailure(auditLogMsg);
        logger.error(logMsg);
        this.handleError(request, response, errorMessageKey);
    }

    private boolean validResetType(String adapterId) {
        PasswordResetConfiguration configuration = this.getConfiguration(adapterId);
        return "OTL".equals(configuration.getResetType());
    }
}

