/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.htmlform.render;

import com.pingidentity.adapters.htmlform.idp.HtmlFormIdpAuthnAdapter;
import com.pingidentity.adapters.htmlform.render.TemplateKey;
import com.pingidentity.adapters.htmlform.render.handler.ResponseHandler;
import com.pingidentity.adapters.htmlform.render.util.CaptchaProviderRenderUtil;
import com.pingidentity.auth.login.WebAuthNUtil;
import com.pingidentity.common.util.CookieMonster;
import com.pingidentity.common.util.HTMLEncoder;
import com.pingidentity.localidentity.LocalIdentityProfile;
import com.pingidentity.sdk.api.authn.util.AuthnApiSupport;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.sourceid.common.Util;
import org.sourceid.saml20.adapter.idp.authn.AuthnPolicy;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class ChallengeWithForm {
    private String url = null;
    private String localIdentityProfileId = null;
    private String name = null;
    private String errorMessageKey = null;
    private String authnMessageKey = null;
    private String serverError = null;
    private String pwmLocation = null;
    private String loginTemplateName = null;
    private String cookieName = null;
    private String resetType = null;
    private AuthnPolicy authnPolicy = null;
    private List<String> pwdCrdVal = new ArrayList<String>();
    private boolean allowsChangePassword = false;
    private boolean enableRememberMyUsername = false;
    private boolean showMyDeviceCheckbox = false;
    private boolean myDeviceChecked = false;
    private boolean allowUsernameEdits = false;
    private boolean loginFailed = false;
    private boolean isChainedUsernameAvailable = false;
    private boolean enableUsernameRecovery = false;
    private boolean captchaEnabled = false;
    private String captchaProviderId = "";

    private ChallengeWithForm() {
    }

    public void render(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters) throws IOException {
        if (this.authnPolicy.allowUserInteraction()) {
            LocalIdentityProfile lip;
            HashMap<String, Object> params = new HashMap<String, Object>();
            boolean usernameEditable = HtmlFormIdpAuthnAdapter.enableRememberChainedUsername(this.isChainedUsernameAvailable, this.allowUsernameEdits);
            boolean rememberChainedUsername = HtmlFormIdpAuthnAdapter.enableRememberChainedUsername(this.isChainedUsernameAvailable, this.allowUsernameEdits);
            params.put(TemplateKey.URL.getKey(), this.url);
            params.put(TemplateKey.ADAPTER_ID_FIELD.getKey(), "pf.adapterId");
            params.put(TemplateKey.NAME.getKey(), "pf.username");
            params.put(TemplateKey.USERNAME.getKey(), HTMLEncoder.encode((String)this.name) == null ? "" : HTMLEncoder.encode((String)this.name));
            params.put(TemplateKey.USERNAME_EDITABLE.getKey(), usernameEditable);
            params.put(TemplateKey.IS_CHAINED_USERNAME_AVAILABLE.getKey(), this.isChainedUsernameAvailable);
            params.put(TemplateKey.PASS.getKey(), "pf.pass");
            params.put(TemplateKey.OK.getKey(), "pf.ok");
            params.put(TemplateKey.CANCEL.getKey(), "pf.cancel");
            params.put(TemplateKey.PASSWORD_RESET.getKey(), "pf.passwordreset");
            params.put(TemplateKey.USERNAME_RECOVERY.getKey(), "pf.usernamerecovery");
            params.put(TemplateKey.LOGIN_FAILED.getKey(), this.loginFailed);
            params.put(TemplateKey.SUPPORTS_PASSWORD_CHANGE.getKey(), this.allowsChangePassword && (!AuthnApiSupport.getDefault().isApiRequest(req) || StringUtils.isBlank((String)this.pwmLocation)) && HtmlFormIdpAuthnAdapter.supportsPasswordChange(this.pwdCrdVal, this.pwmLocation));
            params.put(TemplateKey.SUPPORTS_PASSWORD_RESET.getKey(), this.allowsChangePassword && HtmlFormIdpAuthnAdapter.supportsPasswordReset(this.pwdCrdVal) && !HtmlFormIdpAuthnAdapter.isResetTypeNone(this.resetType));
            params.put(TemplateKey.SUPPORTS_USERNAME_RECOVERY.getKey(), HtmlFormIdpAuthnAdapter.supportsUsernameRecovery(this.enableUsernameRecovery, this.pwdCrdVal));
            params.put(TemplateKey.ENABLE_REMEMBER_USERNAME.getKey(), rememberChainedUsername && this.enableRememberMyUsername);
            params.put(TemplateKey.REMEMBER_USERNAME.getKey(), "pf.rememberUsername");
            String cookieValue = CookieMonster.getCookieValue((String)this.cookieName, (HttpServletRequest)req);
            params.put(TemplateKey.REMEMBER_USERNAME_COOKIE_EXISTS.getKey(), StringUtils.isNotBlank((String)cookieValue));
            params.put(TemplateKey.SHOW_MY_DEVICE_CHECKBOX.getKey(), this.showMyDeviceCheckbox);
            params.put(TemplateKey.MY_DEVICE.getKey(), "pf.myDevice");
            params.put(TemplateKey.MY_DEVICE_CHECKED.getKey(), this.myDeviceChecked ? "checked" : "");
            params.put(TemplateKey.CHANGE_PASSWORD.getKey(), "ChangePassword");
            Map<String, String> changePasswordParam = this.getChangePasswordParam();
            params.put(TemplateKey.CHANGE_PASSWORD_URL.getKey(), Util.appendQueryParams((String)this.url, changePasswordParam));
            params.put(TemplateKey.ERROR_MESSAGE_KEY.getKey(), this.errorMessageKey);
            params.put(TemplateKey.AUTHN_MESSAGE_KEY.getKey(), this.authnMessageKey);
            params.put(TemplateKey.SERVER_ERROR.getKey(), this.serverError);
            params.put(TemplateKey.CAPTCHA_ENABLED.getKey(), this.captchaEnabled);
            if (this.captchaEnabled) {
                CaptchaProviderRenderUtil.addCaptchaProviderParametersToTemplateParameters(req, resp, this.captchaProviderId, "login", TemplateKey.SITE_KEY.getKey(), params);
            }
            if (this.localIdentityProfileId != null && (lip = MgmtFactory.getLocalIdentityProfileManager().getProfile(this.localIdentityProfileId)) != null) {
                params.put(TemplateKey.ALTERNATIVE_AUTHN_SOURCES.getKey(), WebAuthNUtil.filterWebAuthNSource((HttpServletRequest)req, (List)lip.getAuthSourceStrings()));
                params.put(TemplateKey.REGISTRATION_ENABLED.getKey(), lip.isRegistrationEnabled());
                params.put(TemplateKey.REGISTRATION_VALUE.getKey(), "pf.registration");
                params.put(TemplateKey.ALTERNATIVE_AUTHN_SYSTEM.getKey(), "pf.alternateAuthnSystem");
            }
            ResponseHandler.renderLoginResponse(req, resp, this.loginTemplateName, params, this.localIdentityProfileId);
        }
    }

    private Map<String, String> getChangePasswordParam() {
        HashMap<String, String> changePasswordParam = new HashMap<String, String>();
        changePasswordParam.put("ChangePassword", "true");
        return changePasswordParam;
    }

    public static class Builder {
        private String url = null;
        private String localIdentityProfileId = null;
        private String name = null;
        private String errorMessageKey = null;
        private String authnMessageKey = null;
        private String serverError = null;
        private String pwmLocation = null;
        private String loginTemplateName = null;
        private String cookieName = null;
        private String resetType = null;
        private AuthnPolicy authnPolicy = null;
        private List<String> pwdCrdVal = new ArrayList<String>();
        private boolean allowsChangePassword = false;
        private boolean enableRememberMyUsername = false;
        private boolean showMyDeviceCheckbox = false;
        private boolean myDeviceChecked = false;
        private boolean allowUsernameEdits = false;
        private boolean loginFailed = false;
        private boolean isChainedUsernameAvailable = false;
        private boolean enableUsernameRecovery = false;
        private boolean captchaEnabled = false;
        private String captchaProviderId = "";

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder authnPolicy(AuthnPolicy authnPolicy) {
            this.authnPolicy = authnPolicy;
            return this;
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder serverError(String serverError) {
            this.serverError = serverError;
            return this;
        }

        public Builder authnMessageKey(String authnMessageKey) {
            this.authnMessageKey = authnMessageKey;
            return this;
        }

        public Builder errorMessageKey(String errorMessageKey) {
            this.errorMessageKey = errorMessageKey;
            return this;
        }

        public Builder loginFailed(boolean loginFailed) {
            this.loginFailed = loginFailed;
            return this;
        }

        public Builder localIdentityProfileId(String localIdentityProfileId) {
            this.localIdentityProfileId = localIdentityProfileId;
            return this;
        }

        public Builder pwmLocation(String pwmLocation) {
            this.pwmLocation = pwmLocation;
            return this;
        }

        public Builder loginTemplateName(String loginTemplateName) {
            this.loginTemplateName = loginTemplateName;
            return this;
        }

        public Builder cookieName(String cookieName) {
            this.cookieName = cookieName;
            return this;
        }

        public Builder resetType(String resetType) {
            this.resetType = resetType;
            return this;
        }

        public Builder pwdCrdVal(List<String> pwdCrdVal) {
            this.pwdCrdVal = pwdCrdVal;
            return this;
        }

        public Builder allowsChangePassword(boolean allowsChangePassword) {
            this.allowsChangePassword = allowsChangePassword;
            return this;
        }

        public Builder enableRememberMyUsername(boolean enableRememberMyUsername) {
            this.enableRememberMyUsername = enableRememberMyUsername;
            return this;
        }

        public Builder showMyDeviceCheckbox(boolean showMyDeviceCheckbox) {
            this.showMyDeviceCheckbox = showMyDeviceCheckbox;
            return this;
        }

        public Builder myDeviceChecked(boolean myDeviceChecked) {
            this.myDeviceChecked = myDeviceChecked;
            return this;
        }

        public Builder allowUsernameEdits(boolean allowUsernameEdits) {
            this.allowUsernameEdits = allowUsernameEdits;
            return this;
        }

        public Builder isChainedUsernameAvailable(boolean isChainedUsernameAvailable) {
            this.isChainedUsernameAvailable = isChainedUsernameAvailable;
            return this;
        }

        public Builder enableUsernameRecovery(boolean enableUsernameRecovery) {
            this.enableUsernameRecovery = enableUsernameRecovery;
            return this;
        }

        public Builder captchaEnabled(boolean captchaEnabled) {
            this.captchaEnabled = captchaEnabled;
            return this;
        }

        public Builder captchaProviderId(String captchaProviderId) {
            this.captchaProviderId = captchaProviderId;
            return this;
        }

        public ChallengeWithForm build() {
            ChallengeWithForm form = new ChallengeWithForm();
            form.name = this.name;
            form.authnPolicy = this.authnPolicy;
            form.url = this.url;
            form.serverError = this.serverError;
            form.authnMessageKey = this.authnMessageKey;
            form.errorMessageKey = this.errorMessageKey;
            form.loginFailed = this.loginFailed;
            form.localIdentityProfileId = this.localIdentityProfileId;
            form.pwmLocation = this.pwmLocation;
            form.loginTemplateName = this.loginTemplateName;
            form.cookieName = this.cookieName;
            form.pwdCrdVal = this.pwdCrdVal;
            form.allowsChangePassword = this.allowsChangePassword;
            form.enableRememberMyUsername = this.enableRememberMyUsername;
            form.showMyDeviceCheckbox = this.showMyDeviceCheckbox;
            form.myDeviceChecked = this.myDeviceChecked;
            form.allowUsernameEdits = this.allowUsernameEdits;
            form.isChainedUsernameAvailable = this.isChainedUsernameAvailable;
            form.enableUsernameRecovery = this.enableUsernameRecovery;
            form.resetType = this.resetType;
            form.captchaEnabled = this.captchaEnabled;
            form.captchaProviderId = this.captchaProviderId;
            return form;
        }
    }
}

