/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.htmlform.render.handler.api.login;

import com.pingidentity.adapters.htmlform.render.TemplateKey;
import com.pingidentity.adapters.htmlform.render.handler.api.HtmlFormAuthnApiHandler;
import com.pingidentity.sdk.api.authn.common.CommonErrorDetailSpec;
import com.pingidentity.sdk.api.authn.common.CommonErrorSpec;
import com.pingidentity.sdk.api.authn.common.CommonStateSpec;
import com.pingidentity.sdk.api.authn.model.AuthnError;
import com.pingidentity.sdk.api.authn.model.AuthnErrorDetail;
import com.pingidentity.sdk.api.authn.model.AuthnState;
import com.pingidentity.sdk.api.authn.model.state.ChallengeResponseRequired;
import com.pingidentity.sdk.api.authn.spec.AuthnActionSpec;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ApiLoginChallengeHandler
extends HtmlFormAuthnApiHandler {
    private static final String HTML_FORM_CHALLENGE_TEMPLATE_ERROR_MESSAGE_KEY_PREFIX = "html.form.login.challenge.template.";

    @Override
    public AuthnState<?> getAuthnState(HttpServletRequest request, HttpServletResponse response, Map<String, Object> templateParams) {
        return CommonStateSpec.CHALLENGE_RESPONSE_REQUIRED.makeInstance(request, (Object)((ChallengeResponseRequired)this.getApiModel(request, response, templateParams)));
    }

    @Override
    public Object getApiModel(HttpServletRequest request, HttpServletResponse response, Map<String, Object> templateParams) {
        ChallengeResponseRequired model = new ChallengeResponseRequired();
        model.setChallengeQuestion(TemplateKey.CHALLENGE_QUESTION.getStringValue(templateParams));
        return model;
    }

    @Override
    public AuthnError getApiError(HttpServletRequest request, HttpServletResponse response, Map<String, Object> templateParams) {
        AuthnError authnError = null;
        String errorKey = TemplateKey.ERROR_MESSAGE_KEY.getStringValue(templateParams);
        if (errorKey != null) {
            AuthnErrorDetail.Builder detailSpec = CommonErrorDetailSpec.INVALID_CHALLENGE_RESPONSE.makeInstanceBuilder();
            if ("challengeResponseBlankError".equals(errorKey)) {
                detailSpec.userMessageKey(HTML_FORM_CHALLENGE_TEMPLATE_ERROR_MESSAGE_KEY_PREFIX + errorKey);
            }
            authnError = CommonErrorSpec.VALIDATION_ERROR.makeInstanceBuilder().detail(detailSpec.build()).build();
        }
        return authnError;
    }

    @Override
    public Map<String, Class<?>> getActionIdToModelMapping(HttpServletRequest request, HttpServletResponse response) {
        HashMap mapping = new HashMap();
        for (AuthnActionSpec actionSpec : CommonStateSpec.CHALLENGE_RESPONSE_REQUIRED.getActions()) {
            mapping.put(actionSpec.getId(), actionSpec.getModelClass());
        }
        return mapping;
    }
}

