/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.htmlform.render.handler.api.passwordchange;

import com.pingidentity.adapters.htmlform.render.TemplateKey;
import com.pingidentity.adapters.htmlform.render.handler.api.passwordchange.PasswordChangeHandler;
import com.pingidentity.locale.LocaleUtil;
import com.pingidentity.sdk.api.authn.common.CommonStateSpec;
import com.pingidentity.sdk.api.authn.model.AuthnError;
import com.pingidentity.sdk.api.authn.model.AuthnState;
import com.pingidentity.sdk.api.authn.model.state.AuthenticationFailed;
import com.pingidentity.sdk.api.authn.model.state.Canceled;
import com.pingidentity.sdk.api.authn.model.state.Resume;
import com.pingidentity.sdk.locale.LanguagePackMessages;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ApiPasswordChangeErrorHandler
extends PasswordChangeHandler {
    private static final String API_ERROR_MESSAGE = "Password change failed.";

    @Override
    public AuthnState<?> getAuthnState(HttpServletRequest request, HttpServletResponse response, Map<String, Object> templateParams) {
        String messageKey = TemplateKey.AUTHN_MESSAGE_KEY.getStringValue(templateParams);
        if ("html.form.message.template.passwordChangedCancelHeaderMessage".equals(messageKey)) {
            String targetResource = ApiPasswordChangeErrorHandler.getSessionState(request, response).getTargetResource();
            if (targetResource != null) {
                Resume resume = new Resume();
                resume.setResumeUrl(targetResource);
                return CommonStateSpec.RESUME.makeInstance(request, (Object)resume);
            }
            return CommonStateSpec.CANCELED.makeInstance(request, (Object)new Canceled("PASSWORD_CHANGE"));
        }
        return CommonStateSpec.FAILED.makeInstance(request, (Object)((AuthenticationFailed)this.getApiModel(request, response, templateParams)));
    }

    @Override
    public Object getApiModel(HttpServletRequest request, HttpServletResponse response, Map<String, Object> templateParams) {
        AuthenticationFailed model = new AuthenticationFailed();
        model.setAdapterId(ApiPasswordChangeErrorHandler.getNonConnBasedAdapterId(request));
        model.setMessage(API_ERROR_MESSAGE);
        String messageKey = TemplateKey.AUTHN_MESSAGE_KEY.getStringValue(templateParams);
        model.setUserMessage(new LanguagePackMessages("pingfederate-messages", LocaleUtil.getUserLocale((HttpServletRequest)request)).getMessage(messageKey));
        return model;
    }

    @Override
    public AuthnError getApiError(HttpServletRequest request, HttpServletResponse response, Map<String, Object> templateParams) {
        return null;
    }

    @Override
    public Map<String, Class<?>> getActionIdToModelMapping(HttpServletRequest request, HttpServletResponse response) {
        return new HashMap();
    }
}

