/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.htmlform.render.handler.api.passwordchange;

import com.pingidentity.adapters.htmlform.pwdchange.common.ChangePasswordSessionState;
import com.pingidentity.adapters.htmlform.render.handler.api.HtmlFormAuthnApiHandler;
import com.pingidentity.common.util.Pair;
import com.pingidentity.locale.LocaleUtil;
import com.pingidentity.sdk.api.authn.common.CommonStateSpec;
import com.pingidentity.sdk.api.authn.internal.InternalAuthnApiSupport;
import com.pingidentity.sdk.api.authn.model.state.AuthenticationFailed;
import com.pingidentity.sdk.api.authn.util.AuthnApiSupport;
import com.pingidentity.sdk.locale.LanguagePackMessages;
import java.io.IOException;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.sourceid.saml20.domain.AuthnApiApplication;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.websso.profiles.ProcessRuntimeException;

public abstract class PasswordChangeHandler
extends HtmlFormAuthnApiHandler {
    private static final String HTML_FORM_ADAPTER_PASSWORD_CHANGE_EXPIRING_ACCOUNT_USERNAME = "html_form_adapter_password_change_expiring_account_username";
    private static final String HTML_FORM_ADAPTER_PASSWORD_CHANGE_EXPIRING_ACCOUNT_PCV_ID = "html_form_adapter_password_change_expiring_account_pcv_id";
    private static final String IDENTIFY_SERVLET = "/pwdchange/Identify";
    private static final String SUCCESS_SERVLET = "/pwdchange/Success";
    private static final String POLICY_SERVLET = "/pwdchange/Policy";
    private static final String ERROR_SERVLET = "/pwdchange/Error";

    public static void reissueRequestToHtmlFormAdapter(HttpServletRequest request, HttpServletResponse response) {
        HtmlFormAuthnApiHandler.reissueRequestToHtmlFormAdapter(request, response);
    }

    public static void saveExpiringUsernamePCVPair(HttpServletRequest request, String username, String pcvId) {
        PasswordChangeHandler.putApiStateParam(request, HTML_FORM_ADAPTER_PASSWORD_CHANGE_EXPIRING_ACCOUNT_USERNAME, username);
        PasswordChangeHandler.putApiStateParam(request, HTML_FORM_ADAPTER_PASSWORD_CHANGE_EXPIRING_ACCOUNT_PCV_ID, pcvId);
    }

    public static String getExpiringUsername(HttpServletRequest request) {
        Pair<String, String> expiringUsernamePCVPair = PasswordChangeHandler.getExpiringUsernamePCVPair(request);
        return expiringUsernamePCVPair == null ? null : (String)expiringUsernamePCVPair.getLeft();
    }

    public static String getExpiringUserPCVID(HttpServletRequest request) {
        Pair<String, String> expiringUsernamePCVPair = PasswordChangeHandler.getExpiringUsernamePCVPair(request);
        return expiringUsernamePCVPair == null ? null : (String)expiringUsernamePCVPair.getRight();
    }

    private static Pair<String, String> getExpiringUsernamePCVPair(HttpServletRequest request) {
        String username = (String)PasswordChangeHandler.getApiStateParam(request, HTML_FORM_ADAPTER_PASSWORD_CHANGE_EXPIRING_ACCOUNT_USERNAME);
        String pcv = (String)PasswordChangeHandler.getApiStateParam(request, HTML_FORM_ADAPTER_PASSWORD_CHANGE_EXPIRING_ACCOUNT_PCV_ID);
        return username != null && pcv != null ? new Pair((Object)username, (Object)pcv) : null;
    }

    public static void createFlowAndRedirectToDefaultAuthnApp(HttpServletRequest request, HttpServletResponse response, ChangePasswordSessionState state) throws IOException {
        HashMap stateParams = new HashMap();
        if (state.getAdapterId() != null) {
            InternalAuthnApiSupport.getDefault().setCurrentAuthnPlugin(request, stateParams, InternalAuthnApiSupport.AuthnPluginType.IDP_ADAPTER, state.getAdapterId());
        }
        AuthnApiApplication defaultApp = MgmtFactory.getAuthnApiManager().getDefaultApplication();
        if (!MgmtFactory.getAuthnApiManager().isApiEnabled() || defaultApp == null) {
            throw new ProcessRuntimeException("Failed to redirect to default authentication api application : authentication api is not enabled or default authentication application is not configured properly.");
        }
        InternalAuthnApiSupport.getDefault().saveLastAuthnApiApplication(stateParams, defaultApp.getId());
        InternalAuthnApiSupport.getDefault().createFlowAndRedirectToDefaultAuthnApp(request, response, stateParams, IDENTIFY_SERVLET);
    }

    public static void reissueRequestToPasswordChangeIdentifyServlet(HttpServletRequest request, HttpServletResponse response) {
        PasswordChangeHandler.reissueRequestToHandler(request, response, IDENTIFY_SERVLET);
    }

    public static void reissueRequestToPasswordChangeSuccessServlet(HttpServletRequest request, HttpServletResponse response) {
        PasswordChangeHandler.reissueRequestToHandler(request, response, SUCCESS_SERVLET);
    }

    public static void writeUsernameRecoveryCaptchaFailedResponse(HttpServletRequest request, HttpServletResponse response) throws IOException {
        AuthenticationFailed model = new AuthenticationFailed();
        model.setAdapterId(PasswordChangeHandler.getNonConnBasedAdapterId(request));
        LanguagePackMessages lpm = new LanguagePackMessages("pingfederate-messages", LocaleUtil.getUserLocale((HttpServletRequest)request));
        model.setUserMessage(lpm.getMessage("authn.api.captcha.error"));
        AuthnApiSupport.getDefault().writeAuthnStateResponse(request, response, CommonStateSpec.FAILED.makeInstance(request, (Object)model));
    }

    public static void reissueRequestToPasswordChangePolicyServlet(HttpServletRequest request, HttpServletResponse response) {
        PasswordChangeHandler.reissueRequestToHandler(request, response, POLICY_SERVLET);
    }

    public static void reissueRequestToPasswordChangeError(HttpServletRequest request, HttpServletResponse response) {
        PasswordChangeHandler.reissueRequestToHandler(request, response, ERROR_SERVLET);
    }

    protected static ChangePasswordSessionState getSessionState(HttpServletRequest request, HttpServletResponse response) {
        return ChangePasswordSessionState.get(request, response);
    }
}

