/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.htmlform.render.handler.api.passwordreset;

import com.pingidentity.adapters.htmlform.render.TemplateKey;
import com.pingidentity.adapters.htmlform.render.handler.api.passwordreset.PasswordResetHandler;
import com.pingidentity.locale.LocaleUtil;
import com.pingidentity.sdk.api.authn.common.CommonStateSpec;
import com.pingidentity.sdk.api.authn.model.AuthnError;
import com.pingidentity.sdk.api.authn.model.AuthnState;
import com.pingidentity.sdk.api.authn.model.state.AuthenticationFailed;
import com.pingidentity.sdk.api.authn.model.state.Canceled;
import com.pingidentity.sdk.api.authn.model.state.Resume;
import com.pingidentity.sdk.locale.LanguagePackMessages;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ApiPasswordResetErrorHandler
extends PasswordResetHandler {
    private static final String PASSWORD_RESET_ERROR_MESSAGE = "Password reset failed.";
    private static final String PASSWORD_RESET_OPERATION = "ACCOUNT_RECOVERY";

    @Override
    public AuthnState<?> getAuthnState(HttpServletRequest request, HttpServletResponse response, Map<String, Object> templateParams) {
        String messageKey = TemplateKey.ERROR_MESSAGE_KEY.getStringValue(templateParams);
        if ("forgot-password-error.cancel".equals(messageKey)) {
            String targetResource = ApiPasswordResetErrorHandler.getSessionState(request, response).getTargetResource();
            if (targetResource != null) {
                Resume resume = new Resume();
                resume.setResumeUrl(targetResource);
                return CommonStateSpec.RESUME.makeInstance(request, (Object)resume);
            }
            return CommonStateSpec.CANCELED.makeInstance(request, (Object)new Canceled(PASSWORD_RESET_OPERATION));
        }
        return CommonStateSpec.FAILED.makeInstance(request, (Object)((AuthenticationFailed)this.getApiModel(request, response, templateParams)));
    }

    @Override
    public Object getApiModel(HttpServletRequest request, HttpServletResponse response, Map<String, Object> templateParams) {
        AuthenticationFailed model = new AuthenticationFailed();
        model.setAdapterId(ApiPasswordResetErrorHandler.getNonConnBasedAdapterId(request));
        model.setMessage(PASSWORD_RESET_ERROR_MESSAGE);
        String messageKey = TemplateKey.ERROR_MESSAGE_KEY.getStringValue(templateParams);
        model.setUserMessage(new LanguagePackMessages("pingfederate-messages", LocaleUtil.getUserLocale((HttpServletRequest)request)).getMessage(messageKey));
        return model;
    }

    @Override
    public AuthnError getApiError(HttpServletRequest request, HttpServletResponse response, Map<String, Object> templateParams) {
        return null;
    }

    @Override
    public Map<String, Class<?>> getActionIdToModelMapping(HttpServletRequest request, HttpServletResponse response) {
        return new HashMap();
    }
}

