/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.htmlform.render.handler.api.passwordreset;

import com.pingidentity.adapters.htmlform.render.TemplateKey;
import com.pingidentity.adapters.htmlform.render.handler.api.passwordreset.PasswordResetHandler;
import com.pingidentity.adapters.htmlform.render.util.CaptchaProviderRenderUtil;
import com.pingidentity.sdk.api.authn.common.CommonErrorDetailSpec;
import com.pingidentity.sdk.api.authn.common.CommonErrorSpec;
import com.pingidentity.sdk.api.authn.common.CommonStateSpec;
import com.pingidentity.sdk.api.authn.model.AuthnError;
import com.pingidentity.sdk.api.authn.model.AuthnErrorDetail;
import com.pingidentity.sdk.api.authn.model.AuthnState;
import com.pingidentity.sdk.api.authn.model.state.PasswordResetRequired;
import com.pingidentity.sdk.api.authn.model.state.interfaces.CaptchaProviderEnabledState;
import com.pingidentity.sdk.api.authn.spec.AuthnActionSpec;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;

public class ApiPasswordResetNewPasswordRequiredHandler
extends PasswordResetHandler {
    @Override
    public AuthnState<?> getAuthnState(HttpServletRequest request, HttpServletResponse response, Map<String, Object> templateParams) {
        return CommonStateSpec.PASSWORD_RESET_REQUIRED.makeInstance(request, (Object)((PasswordResetRequired)this.getApiModel(request, response, templateParams)));
    }

    @Override
    public Object getApiModel(HttpServletRequest request, HttpServletResponse response, Map<String, Object> templateParams) {
        PasswordResetRequired model = new PasswordResetRequired();
        CaptchaProviderRenderUtil.addCaptchaProviderParametersToModels((CaptchaProviderEnabledState)model, templateParams);
        return model;
    }

    @Override
    public AuthnError getApiError(HttpServletRequest request, HttpServletResponse response, Map<String, Object> templateParams) {
        AuthnError authnError = null;
        List<String> fulfilledPasswordRequirements = TemplateKey.PWD_QUALITY_REQ_MET_MSG_LIST.getStringListValue(templateParams);
        List<String> failedPasswordRequirements = TemplateKey.PWD_QUALITY_REQ_NOT_MET_MSG_LIST.getStringListValue(templateParams);
        String errorMessage = TemplateKey.ERROR_MESSAGE_KEY.getStringValue(templateParams);
        if (StringUtils.isNotBlank((String)errorMessage)) {
            authnError = "forgot-password-change.doesNotMatchPasswordConstraint".equals(errorMessage) ? CommonErrorSpec.VALIDATION_ERROR.makeInstanceBuilder().detail((AuthnErrorDetail)this.getPasswordPolicyViolationDetail("ACCOUNT_RECOVERY_ERROR", "Password reset error was encountered.", "authn.api.password.reset.password.constraint.not.met", fulfilledPasswordRequirements, failedPasswordRequirements)).build() : CommonErrorSpec.VALIDATION_ERROR.makeInstanceBuilder().detail(CommonErrorDetailSpec.ACCOUNT_RECOVERY_ERROR.makeInstanceBuilder().userMessage(errorMessage).build()).build();
        }
        return authnError;
    }

    @Override
    public Map<String, Class<?>> getActionIdToModelMapping(HttpServletRequest request, HttpServletResponse response) {
        HashMap mapping = new HashMap();
        for (AuthnActionSpec spec : CommonStateSpec.PASSWORD_RESET_REQUIRED.getActions()) {
            mapping.put(spec.getId(), spec.getModelClass());
        }
        return mapping;
    }
}

